/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a node of the repository
 */
Ext.define('Ametys.repository.RepositoryNode',
{
    config: {
        /**
         * @cfg {String} id The unique id of the node
         */
        /**
         * @method getId Get the #cfg-id
         * @return {String} The id
         */
        /** @ignore */
        id: null,
        /**
         * @cfg {String} rootId The id of the root explorer node of the element
         */
        /**
         * @method getRootId Get the #cfg-rootId
         * @return {String} The root id
         */
        /** @ignore */
        path: null,
        /**
         * @cfg {String} parentId The unique id of the parent
         */
        /**
         * @method getParentId Get the #cfg-parentId
         * @return {String} The parent id
         */
        /** @ignore */
        pathWithGroups: null,
        /**
         * @cfg {String} name The name of the node
         */
        /**
         * @method getName Get the #cfg-name
         * @return {String} The name
         */
        /** @ignore */
        name: null,
        /**
         * @cfg {Number} index The node index (for same-name siblings).
         */
        /**
         * @method getIndex Get the node #cfg-index
         * @return {Number} The node index.
         */
        /** @ignore */
        index: null,
        /**
         * @cfg {Boolean} hasOrderableChildNodes `true` if the node hasOrderableChildNodes
         */
        /**
         * @method isHasOrderableChildNodes Test if the node hasOrderableChildNodes
         * @return {Boolean} `true` if the node hasOrderableChildNodes.
         */
        /** @ignore */
        hasOrderableChildNodes: false,
        /**
         * @cfg {Boolean} locked `true` if the node is locked
         */
        /**
         * @method isLocked Test if the node is locked
         * @return {Boolean} `true` if the node is locked.
         */
        /** @ignore */
        locked: false,
        /**
         * @cfg {String} checkedOut `true` if the node is checked out.
         */
        /**
         * @method isCheckedOut Test if the node is checked out.
         * @return {Boolean} `true` if the node is checked out.
         */
        /** @ignore */
        checkedOut: true
    },
    
    /**
     * Creates a node instance
     * @param {Object} config See configuration doc.
     */
    constructor: function(config)
    {
        this.initConfig(config);
    },
    
    /**
     * Get the node's properties
     * @return {Object} The node's properties
     */
    getProperties: function(initialProperty)
    {
        return Ext.apply({
            id: this._id,
            path: this._path,
            pathWithGroups: this._pathWithGroups,
            name: this._name,
            index: this._index,
            hasOrderableChildNodes: this._hasOrderableChildNodes,
            locked: this._locked,
            checkedOut: this._checkedOut
        }, initialProperty);
    }
    
});

