/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button for removing a task.
 * @private
 */
Ext.define('Ametys.plugins.coreui.schedule.RemoveTaskButtonController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
    },
    
    /**
     * Listener when the content has been modified
     * Will update the state of the buttons effectively upon the current selection.
     * @param {Ametys.message.Message} message The modified message.
     * @protected
     */
    _onModified: function(message)
    {
        this.refresh();
    },
    
    updateState: function()
    {
        this.disable();
        
        var taskId = this.getMatchingTargets()[0].getParameters().id;
        Ametys.plugins.core.schedule.Scheduler.isRunning([taskId], this._isRunningCb, {scope: this, refreshing: true});
    },
    
    /**
     * @private
     * Callback function invoked after getting the task state
     * @param {Object} response The server response
     * @param {String} response.error if an error occurred
     * @param {Boolean} response.running if the current task target is currently running
     */
    _isRunningCb: function(response)
    {
        if (response.error)
        {
            this.setDescription("{{i18n PLUGINS_CORE_UI_TASKS_REMOVE_DESCRIPTION_ERROR}}");
            this.disable();
        }
        else
        {
            var isRunning = response.running;
            this.setAdditionalDescription(isRunning ? this.getInitialConfig('selection-description-isrunning') : '');
            this.setDisabled(isRunning);
        }
    }
});
