/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Tool showing the script text input to type into.
 * @private
 */
Ext.define('Ametys.plugins.coreui.script.ScriptTool',
{
    extend: 'Ametys.tool.Tool',
    
    /**
     * The number of lines in the editor footer, currently forced at 3. 
     * @private
     */
    _footerLineCount: 3,

    /**
     * Toggle the edition of the header and footer of the editor
     * @private
     */
    _allowHeaderFooterEdit: false,
    
    createPanel: function()
    {
        this._helpTooltipBtn = Ext.create("Ext.Component", {
            cls: 'uitool-script-help-tooltip ametysicon-question13'
        });
        
        Ametys.plugins.coreui.script.ScriptToolHelper.initializeTooltipHelp(this._helpTooltipBtn.getId());
        
        var footerLine1 = "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_FOOTER_HINT_LINE1}}".replace(/\r\n|\r|\n/, "");
        var footerLine2 = "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_FOOTER_HINT_LINE2}}".replace(/\r\n|\r|\n/, "");
        
        this.scriptEditor = Ext.create('Ametys.form.field.Code', {
            mode: 'javascript',
            stateful: true,
            stateId: this.getId() + "$code",
            cls: "uitool-script-editor",
            
            value: "function main() { \n  \n  \n  \n  \n} \n" + footerLine1 + "\n" + footerLine2,
            
            cmParams: {
                extraKeys: {
                    "Ctrl-A": Ext.bind(this._selectAll, this),
                    "Cmd-A": Ext.bind(this._selectAll, this)
                }
            },

            listeners: {
                beforechange: {
                    fn: function (cm, change) {
                        if (!this._allowHeaderFooterEdit && (change.from.line == 0 || change.to.line >= cm.doc.lineCount() - this._footerLineCount))
                        {
                            change.cancel();
                        }
                    },
                    scope: this
                }
            }
        });
        
        this._panel = Ext.create('Ext.panel.Panel', {
            layout: 'fit',
            scrollable: false,
            cls: 'uitool-script',
            
            items: this.scriptEditor,
            
            listeners: {
                'afterrender': Ext.bind(function (panel) {
                    var cmpId = panel.getId() + '-' + Ext.id();
                    
                    panel.getEl().insertFirst({
                        id: cmpId,
                        tag: 'div', 
                        cls: "uitool-script-help-tooltip-container"
                    });
                    
                    this._helpTooltipBtn.render(cmpId);
                }, this)
            }
        });
        
        return this._panel;
    },
    
    getMBSelectionInteraction: function() 
    {
        return Ametys.tool.Tool.MB_TYPE_NOSELECTION;
    },
    
    getType: function()
    {
        return Ametys.tool.Tool.TYPE_REPOSITORY;  
    },
    
    /**
     * Called by the key binding Ctrl-A, overrides the default selection to only the editable lines.
     * @private
     */
    _selectAll: function(cm)
    {
        var lastLine = cm.doc.lineCount() - this._footerLineCount - 1;
        var lastLineLength = cm.doc.getLine(lastLine).length;
        cm.setSelection({line: 1, ch: 0}, {line: lastLine, ch: lastLineLength}, {bias: 1});
    }
});
