/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This class is a singleton to handle actions on scheduled tasks.
 * @private
 */
Ext.define('Ametys.plugins.coreui.tools.RefreshActions', {
    singleton: true, 
    
    /**
     * Refreshes the currently focused tool
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    refreshTool: function(controller)
    {
        var tool = Ametys.tool.ToolsManager.getFocusedTool();
        if (tool != null)
        {
            tool.refresh(true);
        }
    }
});
