/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button reflecting the state of the system announcement message
 * @private
 */
Ext.define('Ametys.plugins.admin.system.SystemAnnouncementController', {
	extend: 'Ametys.ribbon.element.ui.button.OpenToolButtonController',
	
	/**
	 * @cfg {String} [announcement-on-description] The description when when the system announcement is on
	 */
	/**
	 * @cfg {String} [announcement-off-description] The description when when the system announcement is off
	 */
	
	constructor: function(config)
	{
		this.callParent(arguments);
		Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
	},

	/**
	 * Listener when the toggle state of the button has been initialized/modified
	 * Will update the state of the button
	 * @param {Ametys.message.Message} message The modified message.
	 * @protected
	 */
	_onModified: function (message)
	{
		var target = message.getTarget('system-announcement');
		if (target != null)
		{
			var state = target.getParameters().state;
			if ("activated" == state)
			{
				this.setAdditionalDescription (this.getInitialConfig("announcement-on-description") || null);
			}
			else
			{
				this.setAdditionalDescription (this.getInitialConfig("announcement-off-description") || null);
			}
		}
	}
});
