/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Tool showing the script tool results.
 * @private
 */
Ext.define('Ametys.plugins.coreui.script.ConsoleTool',
{
    extend: 'Ametys.tool.Tool',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        // Bus messages listeners
        Ametys.message.MessageBus.on('console-script-executed', this._onScriptExecution, this);
    },
    
    createPanel: function()
    {
        return Ext.create('Ext.panel.Panel', {
            layout: 'fit',
            cls: 'coreui-script-result-tool',
            scrollable: true,
            html: ''
        });
    },
    
    getMBSelectionInteraction: function()
    {
        return Ametys.tool.Tool.MB_TYPE_LISTENING;
    },
    
    getType: function()
    {
        return Ametys.tool.Tool.TYPE_REPOSITORY;  
    },
    
    /**
     * Called when a script has been executed.
     * @param {Ametys.message.Message} message The bus message.
     * @private
     */
    _onScriptExecution: function(message)
    {
        this.addResult(message.getParameters().result);
    },
    
    /**
     * Add a script execution result to the panel.
     * @param {Object} result The script execution result. 
     */
    addResult: function(result)
    {
        var html = Ametys.plugins.coreui.script.ScriptToolHelper.formatConsoleOutput(result);
        
        this.getContentPanel().update(this.getContentPanel().body.getHtml() + html);
        this.getContentPanel().scrollTo(0, 100000000, true);
    }
    
});
