/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.dao;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.workflow.component.WorkflowLanguageManager;
import org.ametys.plugins.workflow.dao.WorkflowStepDAO;
import org.ametys.plugins.workflow.support.I18nHelper;
import org.ametys.plugins.workflow.support.WorflowRightHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowSessionHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class WorkflowTransitionDAO
implements Component,
Serviceable {
    public static final String ROLE = WorkflowTransitionDAO.class.getName();
    public static final I18nizableText DEFAULT_ACTION_NAME = new I18nizableText("plugin.workflow", "PLUGIN_WORKFLOW_DEFAULT_ACTION_LABEL");
    private static final String __DEFAULT_SVG_ACTION_ICON_PATH = "plugin:cms://resources/img/history/workflow/action_0_16.png";
    private static final String __DEFAULT_ACTION_ICON_PATH = "/plugins/cms/resources/img/history/workflow/action_0_16.png";
    protected WorkflowSessionHelper _workflowSessionHelper;
    protected WorflowRightHelper _workflowRightHelper;
    protected WorkflowLanguageManager _workflowLanguageManager;
    protected WorkflowHelper _workflowHelper;
    protected WorkflowStepDAO _workflowStepDAO;
    protected I18nHelper _i18nHelper;
    protected Context _context;

    public void service(ServiceManager smanager) throws ServiceException {
        this._workflowSessionHelper = (WorkflowSessionHelper)((Object)smanager.lookup(WorkflowSessionHelper.ROLE));
        this._workflowHelper = (WorkflowHelper)((Object)smanager.lookup(WorkflowHelper.ROLE));
        this._workflowRightHelper = (WorflowRightHelper)smanager.lookup(WorflowRightHelper.ROLE);
        this._i18nHelper = (I18nHelper)((Object)smanager.lookup(I18nHelper.ROLE));
        this._workflowLanguageManager = (WorkflowLanguageManager)smanager.lookup(WorkflowLanguageManager.ROLE);
        this._workflowStepDAO = (WorkflowStepDAO)((Object)smanager.lookup(WorkflowStepDAO.ROLE));
    }

    @Callable(rights={""})
    public Map<String, Object> getTransitionInfos(String workflowName, Integer transitionId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        HashMap<String, Object> transitionInfos = new HashMap<String, Object>();
        Set<Integer> transitionIds = this._workflowHelper.getAllActions(workflowDescriptor);
        I18nizableText labelKey = DEFAULT_ACTION_NAME;
        if (transitionId != null) {
            transitionIds.remove(transitionId);
            transitionInfos.put("id", transitionId);
            ActionDescriptor action = workflowDescriptor.getAction(transitionId.intValue());
            labelKey = this.getActionLabel(action);
            transitionInfos.put("finalStep", action.getUnconditionalResult().getStep());
        }
        transitionInfos.put("ids", transitionIds);
        Map<String, String> translations = this._workflowSessionHelper.getTranslation(workflowName, labelKey);
        if (translations == null) {
            translations = new HashMap<String, String>();
            translations.put(this._workflowLanguageManager.getCurrentLanguage(), this._i18nHelper.translateKey(workflowDescriptor.getName(), labelKey, DEFAULT_ACTION_NAME));
        }
        transitionInfos.put("labels", translations);
        return transitionInfos;
    }

    @Callable(rights={""})
    public Set<Map<String, Object>> getAvailableActions(String workflowName, Integer parentStepId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkReadRight(workflowDescriptor);
        HashSet<Map<String, Object>> availableActions = new HashSet<Map<String, Object>>();
        if (0 != parentStepId) {
            StepDescriptor parentStep = workflowDescriptor.getStep(parentStepId.intValue());
            List actions = parentStep.getActions();
            List steps = workflowDescriptor.getSteps();
            for (StepDescriptor step : steps) {
                List outgoingActions = step.getActions();
                for (ActionDescriptor outgoingAction : outgoingActions) {
                    if (actions.contains(outgoingAction)) continue;
                    availableActions.add(this._getActionInfos(workflowName, outgoingAction));
                }
            }
        }
        return availableActions;
    }

    private Map<String, Object> _getActionInfos(String workflowName, ActionDescriptor action) {
        HashMap<String, Object> actionInfos = new HashMap<String, Object>();
        int actionId = action.getId();
        actionInfos.put("id", actionId);
        actionInfos.put("label", this.getActionLabel(workflowName, action) + " (" + actionId + ")");
        return actionInfos;
    }

    @Callable(rights={""})
    public Map<String, Object> createTransition(String workflowName, Integer parentStepId, int transitionId, Map<String, String> labels, int finalStepId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        if (this._workflowHelper.getAllActions(workflowDescriptor).contains(transitionId)) {
            return Map.of("message", "duplicate-id");
        }
        DescriptorFactory factory = new DescriptorFactory();
        ActionDescriptor action = factory.createActionDescriptor();
        action.setId(transitionId);
        I18nizableText actionNameI18nKey = this._i18nHelper.generateI18nKey(workflowName, "ACTION", transitionId);
        action.setName(actionNameI18nKey.toString());
        ResultDescriptor finalStep = factory.createResultDescriptor();
        finalStep.setStep(finalStepId);
        action.setUnconditionalResult(finalStep);
        if (this.isInitialStep(parentStepId)) {
            workflowDescriptor.addInitialAction(action);
        } else {
            StepDescriptor stepDescriptor = workflowDescriptor.getStep(parentStepId.intValue());
            stepDescriptor.getActions().add(action);
        }
        this._workflowSessionHelper.updateTranslations(workflowName, actionNameI18nKey, labels);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getActionProperties(workflowDescriptor, action, parentStepId);
    }

    private Map<String, Object> _getActionProperties(WorkflowDescriptor workflowDescriptor, ActionDescriptor action, Integer stepId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("actionId", action.getId());
        results.put("actionLabels", this.getActionLabel(workflowDescriptor.getName(), action));
        results.put("stepId", stepId);
        results.put("stepLabel", this._workflowStepDAO.getStepLabel(workflowDescriptor, stepId));
        results.put("workflowId", workflowDescriptor.getName());
        return results;
    }

    private boolean isInitialStep(Integer stepIdToInt) {
        return stepIdToInt == 0;
    }

    @Callable(rights={""})
    public Map<String, Object> addTransitions(String workflowName, Integer parentStepId, List<Integer> transitionIds) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        Map<String, Object> results = new HashMap<String, Object>();
        if (parentStepId != 0) {
            StepDescriptor step = workflowDescriptor.getStep(parentStepId.intValue());
            for (Integer id : transitionIds) {
                ActionDescriptor action = this._getAction(workflowDescriptor, id);
                step.getActions().add(action);
                if (!action.isCommon()) {
                    this._updateWorkflowCommonAction(workflowDescriptor, id, action);
                    continue;
                }
                step.getCommonActions().add(id);
            }
            this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
            results = this._getActionProperties(workflowDescriptor, workflowDescriptor.getAction(transitionIds.get(0).intValue()), parentStepId);
        } else {
            results.put("message", "initial-step");
        }
        return results;
    }

    private ActionDescriptor _getAction(WorkflowDescriptor workflowDescriptor, Integer actionId) {
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        if (action == null) {
            Map commonActions = workflowDescriptor.getCommonActions();
            action = (ActionDescriptor)commonActions.get(actionId);
        }
        return action;
    }

    protected void _updateWorkflowCommonAction(WorkflowDescriptor workflowDescriptor, int actionId, ActionDescriptor action) {
        ArrayList<StepDescriptor> stepsToUpdate = new ArrayList<StepDescriptor>();
        List steps = workflowDescriptor.getSteps();
        for (StepDescriptor step : steps) {
            if (step.getAction(actionId) == null) continue;
            step.getActions().remove(action);
            stepsToUpdate.add(step);
        }
        workflowDescriptor.addCommonAction(action);
        for (StepDescriptor step : stepsToUpdate) {
            step.getCommonActions().add(actionId);
            step.getActions().add(action);
        }
    }

    @Callable(rights={""})
    public Map<String, Object> editTransitionLabel(String workflowName, Integer stepId, Integer actionId, String newMainLabel) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        this._updateActionName(workflowName, action);
        I18nizableText actionKey = this.getActionLabel(action);
        this._workflowSessionHelper.updateTranslations(workflowName, actionKey, Map.of(this._workflowLanguageManager.getCurrentLanguage(), newMainLabel));
        return this._getActionProperties(workflowDescriptor, action, stepId);
    }

    private void _updateActionName(String workflowName, ActionDescriptor action) {
        I18nizableText actionKey;
        String defaultCatalog = this._workflowHelper.getWorkflowCatalog(workflowName);
        if (!defaultCatalog.equals((actionKey = this.getActionLabel(action)).getCatalogue())) {
            String newName = new I18nizableText(defaultCatalog, actionKey.getKey()).toString();
            action.setName(newName);
        }
    }

    @Callable(rights={""})
    public Map<String, Object> editTransition(String workflowName, Integer stepId, Integer oldId, Integer newId, Map<String, String> labels, Integer finalStepId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(oldId.intValue());
        if (!newId.equals(oldId)) {
            if (this._workflowHelper.getAllActions(workflowDescriptor).contains(newId)) {
                return Map.of("message", "duplicate-id");
            }
            if (action.isCommon()) {
                workflowDescriptor.getCommonActions().remove(oldId, action);
                List steps = workflowDescriptor.getSteps();
                for (StepDescriptor step : steps) {
                    if (step.getAction(oldId.intValue()) == null) continue;
                    List commonActions = step.getCommonActions();
                    commonActions.remove(commonActions.indexOf(oldId));
                    commonActions.add(newId);
                }
                action.setId(newId.intValue());
                workflowDescriptor.getCommonActions().put(newId, action);
            } else {
                action.setId(newId.intValue());
            }
        }
        DescriptorFactory factory = new DescriptorFactory();
        ResultDescriptor finalStep = factory.createResultDescriptor();
        finalStep.setStep(finalStepId.intValue());
        action.setUnconditionalResult(finalStep);
        this._updateActionName(workflowName, action);
        I18nizableText actionKey = this.getActionLabel(action);
        this._workflowSessionHelper.updateTranslations(workflowName, actionKey, labels);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getActionProperties(workflowDescriptor, action, stepId);
    }

    @Callable(rights={""})
    public Map<String, Object> removeTransition(String workflowName, Integer parentStepId, Integer transitionId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ActionDescriptor actionToRemove = null;
        if (this.isInitialStep(parentStepId)) {
            actionToRemove = workflowDescriptor.getInitialAction(transitionId.intValue());
            this._workflowSessionHelper.removeTranslation(workflowName, new I18nizableText("application", actionToRemove.getName()));
            workflowDescriptor.getInitialActions().remove(actionToRemove);
        } else {
            StepDescriptor stepDescriptor = workflowDescriptor.getStep(parentStepId.intValue());
            actionToRemove = workflowDescriptor.getAction(transitionId.intValue());
            stepDescriptor.getActions().remove(actionToRemove);
            if (actionToRemove.isCommon()) {
                List commonActions = stepDescriptor.getCommonActions();
                commonActions.remove(commonActions.indexOf(transitionId));
                this._manageCommonAction(workflowDescriptor, actionToRemove);
            } else {
                I18nizableText actionKey = this.getActionLabel(actionToRemove);
                this._workflowSessionHelper.removeTranslation(workflowName, actionKey);
            }
        }
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getActionProperties(workflowDescriptor, actionToRemove, parentStepId);
    }

    protected void _manageCommonAction(WorkflowDescriptor workflowDescriptor, ActionDescriptor action) {
        List steps;
        int numberOfUse;
        Integer id;
        Map commonActions = workflowDescriptor.getCommonActions();
        if (commonActions.containsKey(id = Integer.valueOf(action.getId())) && (numberOfUse = this._getNumberOfUse(id, steps = workflowDescriptor.getSteps())) == 1) {
            StepDescriptor parentStep = this._getParentStep(steps, id).get();
            List stepCommonActions = parentStep.getCommonActions();
            stepCommonActions.remove(stepCommonActions.indexOf(id));
            parentStep.getActions().remove(action);
            workflowDescriptor.getCommonActions().remove(id, action);
            ActionDescriptor actionCopy = this._copyAction(action);
            parentStep.getActions().add(actionCopy);
            this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        }
    }

    private Optional<StepDescriptor> _getParentStep(List<StepDescriptor> steps, int actionId) {
        return steps.stream().filter(s -> s.getAction(actionId) != null).findFirst();
    }

    private ActionDescriptor _copyAction(ActionDescriptor actionToCopy) {
        DescriptorFactory factory = new DescriptorFactory();
        ActionDescriptor action = factory.createActionDescriptor();
        action.setId(actionToCopy.getId());
        action.setName(actionToCopy.getName());
        action.setUnconditionalResult(actionToCopy.getUnconditionalResult());
        action.getConditionalResults().addAll(actionToCopy.getConditionalResults());
        action.setMetaAttributes(actionToCopy.getMetaAttributes());
        action.setRestriction(actionToCopy.getRestriction());
        action.getPreFunctions().addAll(actionToCopy.getPreFunctions());
        action.getPostFunctions().addAll(actionToCopy.getPostFunctions());
        return action;
    }

    @Callable(rights={""})
    public int getNumberOfUse(String workflowName, Integer actionId) {
        WorkflowDescriptor workflow = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        return this._getNumberOfUse(actionId, workflow.getSteps());
    }

    private int _getNumberOfUse(Integer actionId, List<StepDescriptor> steps) {
        int stepSize = steps.size();
        int numberOfUse = 0;
        for (int index = 0; index < stepSize; ++index) {
            if (steps.get(index).getAction(actionId.intValue()) == null) continue;
            ++numberOfUse;
        }
        return numberOfUse;
    }

    public String getActionLabel(String workflowName, ActionDescriptor action) {
        I18nizableText label = this.getActionLabel(action);
        return this._i18nHelper.translateKey(workflowName, label, DEFAULT_ACTION_NAME);
    }

    public String getActionIconPath(String workflowName, ActionDescriptor action) {
        I18nizableText label = this.getActionLabel(action);
        label = this._workflowSessionHelper.getOldLabelKeyIfCloned(workflowName, label);
        return this._workflowHelper.getElementIconPath(label, __DEFAULT_ACTION_ICON_PATH);
    }

    public String getActionIconPathAsBase64(String workflowName, ActionDescriptor action) {
        I18nizableText label = this.getActionLabel(action);
        label = this._workflowSessionHelper.getOldLabelKeyIfCloned(workflowName, label);
        return this._workflowHelper.getElementIconAsBase64(label, __DEFAULT_SVG_ACTION_ICON_PATH);
    }

    public I18nizableText getActionLabel(ActionDescriptor action) {
        return new I18nizableText("application", action.getName());
    }
}

