/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.dao;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.workflow.component.WorkflowLanguageManager;
import org.ametys.plugins.workflow.dao.WorkflowTransitionDAO;
import org.ametys.plugins.workflow.definition.WorkflowDefinitionExtensionPoint;
import org.ametys.plugins.workflow.support.I18nHelper;
import org.ametys.plugins.workflow.support.WorflowRightHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowSessionHelper;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceResolver;

public class WorkflowsDAO
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = WorkflowsDAO.class.getName();
    public static final String META_NEW_WORKFLOW = "new-workflow";
    protected WorkflowHelper _workflowHelper;
    protected WorkflowSessionHelper _workflowSessionHelper;
    protected WorflowRightHelper _workflowRightHelper;
    protected WorkflowLanguageManager _workflowLanguageManager;
    protected I18nHelper _i18nHelper;
    protected Context _cocoonContext;
    protected I18nUtils _i18nUtils;
    protected org.apache.avalon.framework.context.Context _context;
    protected final String _regexPattern = "^[a-zA-Z\\-]+$";
    protected WorkflowDefinitionExtensionPoint _workflowDefinitionEP;
    protected WorkflowTransitionDAO _workflowTransitionDAO;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected SourceResolver _sourceResolver;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._workflowDefinitionEP = (WorkflowDefinitionExtensionPoint)((Object)manager.lookup(WorkflowDefinitionExtensionPoint.ROLE));
        this._workflowHelper = (WorkflowHelper)((Object)manager.lookup(WorkflowHelper.ROLE));
        this._workflowRightHelper = (WorflowRightHelper)manager.lookup(WorflowRightHelper.ROLE);
        this._workflowSessionHelper = (WorkflowSessionHelper)((Object)manager.lookup(WorkflowSessionHelper.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._workflowLanguageManager = (WorkflowLanguageManager)manager.lookup(WorkflowLanguageManager.ROLE);
        this._i18nHelper = (I18nHelper)((Object)manager.lookup(I18nHelper.ROLE));
        this._workflowTransitionDAO = (WorkflowTransitionDAO)manager.lookup(WorkflowTransitionDAO.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    @Callable(rights={""})
    public Map<String, Object> getWorkflowRootProperties(String workflowName) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        HashMap<String, Object> infos = new HashMap<String, Object>();
        if (workflowDescriptor != null && this._workflowRightHelper.canRead(workflowDescriptor)) {
            infos.put("id", workflowName);
            infos.put("label", this._workflowSessionHelper.getWorkflowLabel(workflowName));
            infos.put("hasChildren", workflowDescriptor.getSteps().size() > 0);
            infos.put("hasChanges", this._workflowSessionHelper.hasChanges(workflowName));
            infos.put("isNew", workflowDescriptor.getMetaAttributes().containsKey(META_NEW_WORKFLOW));
            infos.put("canWrite", this._workflowRightHelper.canWrite(workflowDescriptor));
        } else {
            String errorMsg = workflowDescriptor != null ? "cant-read" : "workflow-unknown";
            infos.put("error", errorMsg);
        }
        return infos;
    }

    @Callable(rights={""})
    public Map<String, Object> getWorkflowsList() {
        ArrayList workflows2json = new ArrayList();
        Set<String> workflowNames = this._workflowSessionHelper.getWorkflowNames();
        for (String workflowName : workflowNames) {
            WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
            if (!this._workflowRightHelper.canRead(workflowDescriptor)) continue;
            LinkedHashMap<String, Object> workflowData = new LinkedHashMap<String, Object>();
            workflowData.put("title", this._workflowSessionHelper.getWorkflowLabel(workflowName));
            workflowData.put("id", workflowName);
            workflowData.put("hasChanges", this._workflowSessionHelper.hasChanges(workflowName));
            workflows2json.add(workflowData);
        }
        return Map.of("workflows", workflows2json);
    }

    @Callable(rights={""})
    public Map<String, Object> saveChanges(String workflowName) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            if (!this._setErrors(workflowDescriptor, results)) {
                workflowDescriptor.getMetaAttributes().remove(META_NEW_WORKFLOW);
                this._writeWorklowFile(workflowName, workflowDescriptor);
                this._writeI18nTranslations(workflowName, this._workflowSessionHelper.getTranslations(workflowName));
                this._workflowSessionHelper.cloneImages(workflowName);
                this._workflowSessionHelper.deleteSession(workflowName);
                this._workflowDefinitionEP.addOrUpdateExtension(workflowName);
                this._i18nHelper.clearCaches();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("workflow.name", workflowName);
                this._observationManager.notify(new Event("workflow.saved", this._currentUserProvider.getUser(), params));
            }
            results.put("workflowId", workflowName);
        }
        catch (FileNotFoundException e) {
            results.put("message", "file-not-found");
            this.getLogger().error("An error occured while overwriting workflow file: {}", (Object)workflowName, (Object)e);
        }
        catch (Exception e) {
            results.put("message", "sax-error");
            this.getLogger().error("An error occured while saxing i18n catalogs file", (Throwable)e);
        }
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> reinit(String workflowName) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        if (workflowDescriptor.getMetaAttributes().containsKey(META_NEW_WORKFLOW)) {
            return Map.of("message", "new_workflow");
        }
        this._workflowSessionHelper.deleteSession(workflowName);
        return Map.of("workflowId", workflowName);
    }

    protected boolean _setErrors(WorkflowDescriptor workflowDescriptor, Map<String, Object> results) {
        if (workflowDescriptor.getInitialActions().isEmpty()) {
            results.put("message", "empty-initials-actions");
            return true;
        }
        Set<Integer> transitionIds = this._workflowHelper.getAllActions(workflowDescriptor);
        return this._hasEmptyOperator(workflowDescriptor, transitionIds, results) || this._hasEmptyConditionalResult(workflowDescriptor, results, transitionIds);
    }

    protected boolean _hasEmptyConditionalResult(WorkflowDescriptor workflowDescriptor, Map<String, Object> results, Set<Integer> transitionIds) {
        HashSet<CallSite> invalidTransitions = new HashSet<CallSite>();
        for (Integer id : transitionIds) {
            ActionDescriptor action = workflowDescriptor.getAction(id.intValue());
            String actionLabel = this._workflowTransitionDAO.getActionLabel(workflowDescriptor.getName(), action) + "(" + action.getId() + ")";
            List conditionalResults = action.getConditionalResults();
            for (ConditionalResultDescriptor resultDescriptor : conditionalResults) {
                List conditions = resultDescriptor.getConditions();
                if (conditions.isEmpty()) {
                    results.put("message", "empty-conditionnal-result");
                    invalidTransitions.add((CallSite)((Object)actionLabel));
                    continue;
                }
                if (!this._hasOperatorWithoutChild((ConditionsDescriptor)conditions.get(0))) continue;
                results.put("message", "empty-result-operator");
                invalidTransitions.add((CallSite)((Object)actionLabel));
            }
        }
        results.put("invalidTransitions", invalidTransitions.isEmpty() ? null : invalidTransitions);
        return results.get("message") != null;
    }

    protected boolean _hasEmptyOperator(WorkflowDescriptor workflowDescriptor, Set<Integer> transitionIds, Map<String, Object> results) {
        HashSet<CallSite> invalidTransitions = new HashSet<CallSite>();
        for (Integer id : transitionIds) {
            ConditionsDescriptor rootOperator;
            ActionDescriptor action = workflowDescriptor.getAction(id.intValue());
            if (action == null) continue;
            String actionLabel = this._i18nHelper.translateKey(workflowDescriptor.getName(), new I18nizableText("application", action.getName()), WorkflowTransitionDAO.DEFAULT_ACTION_NAME) + " (" + action.getId() + ")";
            RestrictionDescriptor restriction = action.getRestriction();
            if (restriction == null || !this._hasOperatorWithoutChild(rootOperator = restriction.getConditionsDescriptor())) continue;
            invalidTransitions.add((CallSite)((Object)actionLabel));
        }
        if (!invalidTransitions.isEmpty()) {
            results.put("message", "empty-condition-operator");
            results.put("invalidTransitions", invalidTransitions);
            return true;
        }
        return false;
    }

    private boolean _hasOperatorWithoutChild(ConditionsDescriptor rootOperator) {
        List conditions = rootOperator.getConditions();
        if (conditions.isEmpty()) {
            return true;
        }
        boolean hasChildFreeOperator = false;
        for (int i = 0; i < conditions.size() && !hasChildFreeOperator; ++i) {
            Object e = conditions.get(i);
            if (!(e instanceof ConditionsDescriptor)) continue;
            ConditionsDescriptor operator = (ConditionsDescriptor)e;
            hasChildFreeOperator = this._hasOperatorWithoutChild(operator);
        }
        return hasChildFreeOperator;
    }

    private void _writeI18nTranslations(String workflowName, Map<I18nizableText, Map<String, String>> translations) throws Exception {
        if (!translations.isEmpty()) {
            String workflowCatalog = this._workflowHelper.getWorkflowCatalog(workflowName);
            Map<String, Map<I18nizableText, String>> newI18nCatalogs = this._i18nHelper.createNewI18nCatalogs(translations);
            this._i18nHelper.saveCatalogs(newI18nCatalogs, workflowCatalog);
        }
    }

    private void _writeWorklowFile(String workflowName, WorkflowDescriptor workflowDescriptor) throws IOException {
        File workflowFile = new File(this._workflowHelper.getParamWorkflowDir(), workflowName + ".xml");
        if (workflowFile.exists()) {
            FileUtils.copyFile((File)workflowFile, (File)new File(String.valueOf(workflowFile) + ".bak"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        } else {
            FileUtils.createParentDirectories((File)workflowFile);
            workflowFile.createNewFile();
        }
        try (PrintWriter out = new PrintWriter(workflowFile, StandardCharsets.UTF_8);){
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.8//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_8.dtd\">");
            workflowDescriptor.writeXML(out, 0);
        }
    }

    protected Map<String, String> _getWorkflowLabels(String workflowName) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        Map<String, String> workflowLabelTranslations = this._workflowSessionHelper.getWorkflowLabelTranslations(workflowName);
        if (workflowLabelTranslations.isEmpty() && ArrayUtils.contains((Object[])this._workflowHelper.getWorkflowNames(), (Object)workflowName)) {
            I18nizableText workflowI18nLabelKey = this._workflowHelper.getWorkflowLabel(workflowName);
            for (String language : this._workflowLanguageManager.getLanguages()) {
                workflowLabelTranslations.put(language, StringUtils.defaultString((String)this._i18nUtils.translate((I18nizable)workflowI18nLabelKey, language)));
            }
        }
        return workflowLabelTranslations;
    }

    @Callable(rights={"Workflow_Right_Edit", "Workflow_Right_Edit_User"})
    public Map<String, Object> getWorkflowInfos(String workflowName) {
        HashMap<String, Object> workflowInfos = new HashMap<String, Object>();
        workflowInfos.put("workflowNames", this._workflowSessionHelper.getWorkflowNames());
        if (StringUtils.isNotBlank((CharSequence)workflowName)) {
            workflowInfos.put("labels", this._getWorkflowLabels(workflowName));
        }
        return workflowInfos;
    }

    @Callable(rights={""})
    public Map<String, Object> createWorkflow(Map<String, String> labels, String id) {
        this._workflowRightHelper.checkEditRight();
        Set<String> workflowNames = this._workflowSessionHelper.getWorkflowNames();
        if (workflowNames.contains(id)) {
            return Map.of("message", "duplicate-id");
        }
        DescriptorFactory factory = new DescriptorFactory();
        WorkflowDescriptor workflowDescriptor = factory.createWorkflowDescriptor();
        workflowDescriptor.setName(id);
        workflowDescriptor.getMetaAttributes().put("user", true);
        workflowDescriptor.getMetaAttributes().put(META_NEW_WORKFLOW, true);
        this._workflowSessionHelper.initWorkflowDescriptor(workflowDescriptor);
        this._workflowSessionHelper.updateWorkflowNames(workflowDescriptor);
        this._workflowSessionHelper.updateTranslations(id, this._i18nHelper.getWorkflowLabelKey(id), labels);
        return Map.of("workflowId", id);
    }

    @Callable(rights={""})
    public Map<String, Object> renameWorkflow(String workflowName, Map<String, String> labels) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        I18nizableText labelKey = this._i18nHelper.getWorkflowLabelKey(workflowName);
        this._workflowSessionHelper.updateTranslations(workflowName, labelKey, labels);
        return Map.of("workflowId", workflowName);
    }

    @Callable(rights={""})
    public Map<String, Object> duplicateWorkflow(String newWorkflowName, Map<String, String> labels, String duplicatedWorkflowName) {
        this._workflowRightHelper.checkEditRight();
        Set<String> workflowNames = this._workflowSessionHelper.getWorkflowNames();
        if (workflowNames.contains(newWorkflowName)) {
            return Map.of("message", "duplicate-id");
        }
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(duplicatedWorkflowName, false);
        if (workflowDescriptor.getMetaAttributes().containsKey(META_NEW_WORKFLOW)) {
            return Map.of("message", "no-save");
        }
        this._workflowSessionHelper.duplicateWorkflow(newWorkflowName, labels, duplicatedWorkflowName);
        return Map.of("workflowId", newWorkflowName);
    }
}

