/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.store;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.plugins.workflow.store.AbstractJackrabbitWorkflowStore;
import org.apache.cocoon.util.HashUtil;
import org.apache.commons.lang.StringUtils;

public class GenericWorkflowStore
extends AbstractJackrabbitWorkflowStore {
    static final String __HTREE_NT = "oswf:hashSegment";

    public GenericWorkflowStore(Repository repository) {
        super(repository);
    }

    @Override
    public boolean shouldClearHistory() {
        return true;
    }

    @Override
    protected void _createRootNode() throws RepositoryException {
        Session session = null;
        try {
            session = this._getSession();
            Node root = session.getRootNode();
            if (!root.hasNode("oswf:root")) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug("Creating osworkflow root node");
                }
                root.addNode("oswf:root", "oswf:root");
                session.save();
            } else if (this._log.isDebugEnabled()) {
                this._log.debug("Existing osworkflow root node, skipping creation.");
            }
        }
        finally {
            this._release(session);
        }
    }

    @Override
    protected Node _getRootNode(Session session) throws RepositoryException {
        return session.getRootNode().getNode("oswf:root");
    }

    protected List<String> _getEntryHash(long entryId) {
        long hash = Math.abs(HashUtil.hash((String)String.valueOf(entryId)));
        String hashHexa = StringUtils.leftPad((String)Long.toString(hash, 16), (int)4, (String)"0");
        ArrayList<String> hashSegments = new ArrayList<String>();
        hashSegments.add(hashHexa.substring(0, 2));
        hashSegments.add(hashHexa.substring(2, 4));
        return hashSegments;
    }

    @Override
    protected Node _getOrCreateParentEntryNode(Node root, long id) throws RepositoryException {
        Node htree = root;
        List<String> hashSegments = this._getEntryHash(id);
        for (String hashSegment : hashSegments) {
            if (htree.hasNode(hashSegment)) {
                htree = htree.getNode(hashSegment);
                continue;
            }
            htree = htree.addNode(hashSegment, __HTREE_NT);
        }
        return htree;
    }
}

