/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.support;

import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.TypeResolver;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.WorkflowFactory;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.util.Collections;
import java.util.Properties;
import javax.jcr.Repository;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workflow.AbstractAmetysWorkflow;
import org.ametys.plugins.workflow.AmetysWorkflowFactory;
import org.ametys.plugins.workflow.SimpleConfiguration;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.store.AmetysObjectWorkflowStore;
import org.ametys.plugins.workflow.store.GenericWorkflowStore;
import org.ametys.plugins.workflow.support.AvalonTypeResolver;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowProvider
implements Component,
Serviceable,
Contextualizable,
Initializable,
Disposable {
    public static final String ROLE = WorkflowProvider.class.getName();
    protected static Logger _logger = LoggerFactory.getLogger(WorkflowProvider.class);
    protected ServiceManager _manager;
    protected CurrentUserProvider _currentUserProvider;
    protected Repository _repository;
    protected WorkflowHelper _workflowHelper;
    protected Context _cocoonContext;
    protected WorkflowContext _workflowContext;
    protected WorkflowFactory _workflowFactory;
    protected TypeResolver _typeResolver;
    protected GenericWorkflow _genericWorkflow;
    protected SourceResolver _resolver;
    protected AmetysObjectResolver _ametysObjectResolver;

    public void contextualize(org.apache.avalon.framework.context.Context ctx) throws ContextException {
        this._cocoonContext = (Context)ctx.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._currentUserProvider = (CurrentUserProvider)this._manager.lookup(CurrentUserProvider.ROLE);
        this._repository = (Repository)this._manager.lookup("javax.jcr.Repository");
        this._workflowHelper = (WorkflowHelper)((Object)this._manager.lookup(WorkflowHelper.ROLE));
        this._resolver = (SourceResolver)this._manager.lookup(SourceResolver.ROLE);
        this._workflowFactory = (WorkflowFactory)this._manager.lookup(AmetysWorkflowFactory.ROLE);
        this._ametysObjectResolver = (AmetysObjectResolver)this._manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void initialize() throws Exception {
        this._workflowContext = new WorkflowContext(){

            public String getCaller() {
                return UserIdentity.userIdentityToString((UserIdentity)WorkflowProvider.this._currentUserProvider.getUser());
            }

            public void setRollbackOnly() {
            }
        };
        try {
            this._workflowFactory.init(new Properties());
            this._workflowFactory.initDone();
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to init workflow factory", e);
        }
        this._typeResolver = new AvalonTypeResolver(this._manager);
    }

    public void dispose() {
        this._manager = null;
        this._currentUserProvider = null;
        this._cocoonContext = null;
        this._workflowContext = null;
        this._workflowFactory = null;
        this._typeResolver = null;
        this._genericWorkflow = null;
    }

    WorkflowFactory getWorkflowFactory() {
        return this._workflowFactory;
    }

    public Workflow getGenericWorkflow() {
        if (this._genericWorkflow == null) {
            GenericWorkflowStore store = this._createGenericWorkflowStore();
            try {
                store.init(Collections.EMPTY_MAP);
            }
            catch (StoreException e) {
                throw new RuntimeException("Unable to init workflow store", e);
            }
            this._genericWorkflow = new GenericWorkflow(this._workflowHelper, this._workflowContext);
            this._genericWorkflow.setConfiguration(new SimpleConfiguration(this._workflowFactory, store));
            this._genericWorkflow.setResolver(this._typeResolver);
        }
        return this._genericWorkflow;
    }

    protected GenericWorkflowStore _createGenericWorkflowStore() {
        return new GenericWorkflowStore(this._repository);
    }

    public AmetysObjectWorkflow getAmetysObjectWorkflow() {
        return this.getAmetysObjectWorkflow(null, false);
    }

    public AmetysObjectWorkflow getAmetysObjectWorkflow(boolean preserveHistory) {
        return this.getAmetysObjectWorkflow(null, preserveHistory);
    }

    public AmetysObjectWorkflow getAmetysObjectWorkflow(WorkflowAwareAmetysObject ametysObject) {
        return this.getAmetysObjectWorkflow(ametysObject, false);
    }

    public AmetysObjectWorkflow getAmetysObjectWorkflow(WorkflowAwareAmetysObject ametysObject, boolean preserveHistory) {
        AmetysObjectWorkflowStore store = this._createAmetysObjectWorkflowStore(ametysObject, preserveHistory);
        try {
            store.init(Collections.EMPTY_MAP);
        }
        catch (StoreException e) {
            throw new RuntimeException("Unable to init workflow store", e);
        }
        AmetysObjectWorkflow ametysObjectWorkflow = new AmetysObjectWorkflow(this._workflowHelper, this._workflowContext, store);
        ametysObjectWorkflow.setConfiguration(new SimpleConfiguration(this._workflowFactory, store));
        ametysObjectWorkflow.setResolver(this._typeResolver);
        return ametysObjectWorkflow;
    }

    protected AmetysObjectWorkflowStore _createAmetysObjectWorkflowStore(WorkflowAwareAmetysObject ametysObject, boolean preserveHistory) {
        return new AmetysObjectWorkflowStore(this._repository, ametysObject, this._ametysObjectResolver, preserveHistory);
    }

    public Workflow getExternalWorkflow(String workflowStoreRole) {
        WorkflowStore workflowStore;
        try {
            workflowStore = (WorkflowStore)this._manager.lookup(workflowStoreRole);
        }
        catch (ServiceException e) {
            throw new RuntimeException(String.format("Unable to lookup workflow store for role '%s'.", workflowStoreRole), e);
        }
        ExternalWorkflow workflow = new ExternalWorkflow(this._workflowHelper, this._workflowContext, workflowStore);
        workflow.setConfiguration(new SimpleConfiguration(this._workflowFactory, workflowStore));
        workflow.setResolver(this._typeResolver);
        return workflow;
    }

    public Workflow getExternalWorkflow(WorkflowStore workflowStore) {
        ExternalWorkflow workflow = new ExternalWorkflow(this._workflowHelper, this._workflowContext, workflowStore);
        workflow.setConfiguration(new SimpleConfiguration(this._workflowFactory, workflowStore));
        workflow.setResolver(this._typeResolver);
        return workflow;
    }

    public static class GenericWorkflow
    extends AbstractAmetysWorkflow {
        GenericWorkflow(WorkflowHelper workflowHelper, WorkflowContext workflowContext) {
            super(workflowHelper, workflowContext);
        }
    }

    public static class AmetysObjectWorkflow
    extends AbstractAmetysWorkflow {
        protected AmetysObjectWorkflowStore _workflowStore;

        AmetysObjectWorkflow(WorkflowHelper workflowHelper, WorkflowContext workflowContext, AmetysObjectWorkflowStore store) {
            super(workflowHelper, workflowContext);
            this._workflowStore = store;
        }

        public <A extends WorkflowAwareAmetysObject> A getAmetysObject() {
            return (A)this._workflowStore.getAmetysObject();
        }

        public void removeWorkflow(long wId) throws WorkflowException {
            this._workflowStore.removeEntry(wId);
        }

        public String getWorkflowName(long id) {
            String workflowName = super.getWorkflowName(id);
            if (workflowName == null) {
                this.log.error((Object)("Can't get workflow name of " + this.getAmetysObject().toString()));
            }
            return workflowName;
        }
    }

    public static class ExternalWorkflow
    extends AbstractAmetysWorkflow {
        protected WorkflowStore _store;

        ExternalWorkflow(WorkflowHelper workflowHelper, WorkflowContext workflowContext, WorkflowStore workflowStore) {
            super(workflowHelper, workflowContext);
            this._store = workflowStore;
        }
    }
}

