/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the data model for workflows.
 * @private
 */
Ext.define('Ametys.plugins.workflow.models.WorkflowTreeModel', {
    extend: 'Ext.data.Model',
    
    fields: [
        {name: 'hasChildren', type: 'boolean'},
        {
            name: 'leaf', 
            type: 'boolean',
            convert: function(value, record) {
                var data = record.data;
                if (data.root)
                {
                    return false;
                }
                return !data.hasChildren;
            }
        },
        {name: 'id', type: 'string'},
        {name: 'elementId', type: 'string'},
        {name: 'hasChanges', type: 'boolean'},
        {name: 'label', type: 'string'},
        {name: 'elementType', type:'string'},
        {name: 'smallIcon', type: 'string'},
        {name: 'icon', mapping: 'smallIcon'}
    ]
});
