/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workflow.store;

import javax.jcr.Repository;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

/**
 * Ametys JDBC workflow store
 */
public class AvalonJackrabbitWorkflowStore extends GenericWorkflowStore implements Component, Serviceable, ThreadSafe, Initializable, Disposable
{
    /** Service manager. */
    protected ServiceManager _manager;
    
    /**
     * Create a new AvalonJackrabbitWorkflowStore.
     */
    public AvalonJackrabbitWorkflowStore()
    {
        super(null);
    }
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _manager = manager;
    }
    
    public void initialize() throws Exception
    {
        _repository = (Repository) _manager.lookup("javax.jcr.Repository");
    }
    
    public void dispose()
    {
        _repository = null;
    }
}
