/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.dao;

import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.workflow.EnhancedCondition;
import org.ametys.plugins.workflow.EnhancedConditionExtensionPoint;
import org.ametys.plugins.workflow.ModelItemTypeExtensionPoint;
import org.ametys.plugins.workflow.component.WorkflowArgument;
import org.ametys.plugins.workflow.dao.WorkflowResultDAO;
import org.ametys.plugins.workflow.dao.WorkflowStepDAO;
import org.ametys.plugins.workflow.dao.WorkflowTransitionDAO;
import org.ametys.plugins.workflow.support.AvalonTypeResolver;
import org.ametys.plugins.workflow.support.WorflowRightHelper;
import org.ametys.plugins.workflow.support.WorkflowElementDefinitionHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowSessionHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WorkflowConditionDAO
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = WorkflowConditionDAO.class.getName();
    public static final String AND = "AND";
    public static final String OR = "OR";
    protected static final String __ANDI18N = "PLUGIN_WORKFLOW_TRANSITION_CONDITIONS_TYPE_AND";
    protected static final String __ORI18N = "PLUGIN_WORKFLOW_TRANSITION_CONDITIONS_TYPE_OR";
    protected static ModelItemTypeExtensionPoint _workflowArgumentDataTypeExtensionPoint;
    private static final String __OR_ROOT_OPERATOR = "or0";
    private static final String __AND_ROOT_OPERATOR = "and0";
    private static final String __STEP_RESULT_PREFIX = "step";
    private static final String __ROOT_RESULT_ID = "root";
    private static final String __ATTRIBUTE_CONDITIONS_LIST = "conditions-list";
    protected WorkflowSessionHelper _workflowSessionHelper;
    protected WorkflowHelper _workflowHelper;
    protected WorflowRightHelper _workflowRightHelper;
    protected WorkflowResultDAO _workflowResultDAO;
    protected WorkflowStepDAO _workflowStepDAO;
    protected WorkflowTransitionDAO _workflowTransitionDAO;
    protected EnhancedConditionExtensionPoint _enhancedConditionExtensionPoint;
    protected ServiceManager _manager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._workflowHelper = (WorkflowHelper)((Object)smanager.lookup(WorkflowHelper.ROLE));
        this._workflowRightHelper = (WorflowRightHelper)smanager.lookup(WorflowRightHelper.ROLE);
        this._workflowSessionHelper = (WorkflowSessionHelper)((Object)smanager.lookup(WorkflowSessionHelper.ROLE));
        this._workflowResultDAO = (WorkflowResultDAO)((Object)smanager.lookup(WorkflowResultDAO.ROLE));
        this._workflowStepDAO = (WorkflowStepDAO)((Object)smanager.lookup(WorkflowStepDAO.ROLE));
        this._workflowTransitionDAO = (WorkflowTransitionDAO)smanager.lookup(WorkflowTransitionDAO.ROLE);
        _workflowArgumentDataTypeExtensionPoint = (ModelItemTypeExtensionPoint)((Object)smanager.lookup(ModelItemTypeExtensionPoint.ROLE_WORKFLOW));
        this._enhancedConditionExtensionPoint = (EnhancedConditionExtensionPoint)((Object)smanager.lookup(EnhancedConditionExtensionPoint.ROLE));
        this._manager = smanager;
    }

    @Callable(rights={"Workflow_Right_Edit", "Workflow_Right_Edit_User"})
    public Map<String, Object> getConditionsModel() throws ProcessingException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        View view = new View();
        SimpleViewItemGroup fieldset = new SimpleViewItemGroup();
        fieldset.setName("conditions");
        Set<Pair<String, EnhancedCondition>> conditions = this._enhancedConditionExtensionPoint.getAllConditions().stream().filter(this::_hasConditionRight).collect(Collectors.toSet());
        ElementDefinition<String> conditionsList = this._getConditionsListModelItem(conditions);
        List<WorkflowArgument> argumentModelItems = this._getArgumentModelItems(conditions);
        ViewElement conditionListView = new ViewElement();
        conditionListView.setDefinition(conditionsList);
        fieldset.addViewItem((ViewItem)conditionListView);
        for (WorkflowArgument functionArgument : argumentModelItems) {
            ViewElement argumentView = new ViewElement();
            argumentView.setDefinition((ElementDefinition)functionArgument);
            fieldset.addViewItem((ViewItem)argumentView);
        }
        view.addViewItem((ViewItem)fieldset);
        response.put("parameters", view.toJSON(DefinitionContext.newInstance().withEdition(true)));
        return response;
    }

    private boolean _hasConditionRight(Pair<String, EnhancedCondition> condition) {
        List<WorkflowHelper.WorkflowVisibility> conditionVisibilities = ((EnhancedCondition)condition.getRight()).getVisibilities();
        if (conditionVisibilities.contains((Object)WorkflowHelper.WorkflowVisibility.USER)) {
            return this._workflowRightHelper.hasEditUserRight();
        }
        if (conditionVisibilities.contains((Object)WorkflowHelper.WorkflowVisibility.SYSTEM)) {
            return this._workflowRightHelper.hasEditSystemRight();
        }
        return false;
    }

    private ElementDefinition<String> _getConditionsListModelItem(Set<Pair<String, EnhancedCondition>> conditions) {
        WorkflowArgument conditionsList = WorkflowElementDefinitionHelper.getElementDefinition(__ATTRIBUTE_CONDITIONS_LIST, new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_ADD_CONDITION_DIALOG_ROLE"), new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_ADD_CONDITION_DIALOG_ROLE_DESC"), true, false);
        StaticEnumerator conditionStaticEnumerator = new StaticEnumerator();
        for (Pair<String, EnhancedCondition> condition : conditions) {
            conditionStaticEnumerator.add(((EnhancedCondition)condition.getRight()).getLabel(), (Object)((String)condition.getLeft()));
        }
        conditionsList.setEnumerator((Enumerator)conditionStaticEnumerator);
        return conditionsList;
    }

    protected List<WorkflowArgument> _getArgumentModelItems(Set<Pair<String, EnhancedCondition>> conditions) {
        ArrayList<WorkflowArgument> argumentModelItems = new ArrayList<WorkflowArgument>();
        for (Pair<String, EnhancedCondition> condition : conditions) {
            String conditionId = (String)condition.getLeft();
            DisableConditions disableConditions = new DisableConditions();
            DisableCondition disableCondition = new DisableCondition(__ATTRIBUTE_CONDITIONS_LIST, DisableCondition.OPERATOR.NEQ, conditionId);
            disableConditions.getConditions().add(disableCondition);
            for (WorkflowArgument arg : ((EnhancedCondition)condition.getRight()).getArguments()) {
                arg.setName(conditionId + "-" + arg.getName());
                arg.setDisableConditions(disableConditions);
                argumentModelItems.add(arg);
            }
        }
        return argumentModelItems;
    }

    @Callable(rights={""})
    public Map<String, Object> getConditionParametersValues(String workflowName, Integer actionId, String conditionNodeId) throws ProcessingException {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ConditionDescriptor condition = this._getCondition(workflowDescriptor, actionId, conditionNodeId);
        HashMap<String, String> args = new HashMap<String, String>();
        Map conditionCurrentArguments = condition.getArgs();
        String conditionId = (String)conditionCurrentArguments.get("id");
        for (Map.Entry entry : conditionCurrentArguments.entrySet()) {
            String argName = ((String)entry.getKey()).equals("id") ? __ATTRIBUTE_CONDITIONS_LIST : conditionId + "-" + (String)entry.getKey();
            args.put(argName, (String)entry.getValue());
        }
        args.putAll(conditionCurrentArguments);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("parametersValues", args);
        return results;
    }

    protected ConditionDescriptor _getCondition(WorkflowDescriptor workflowDescriptor, Integer actionId, String conditionNodeId) {
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        String[] path = this._workflowResultDAO.getPath(conditionNodeId);
        int nodeToEdit = Integer.valueOf(path[path.length - 1].substring("condition".length()));
        boolean isResult = path[0].startsWith(__STEP_RESULT_PREFIX);
        ConditionsDescriptor rootOperator = isResult ? this._workflowResultDAO.getRootResultConditions(action.getConditionalResults(), this._getStepId(conditionNodeId)).get(0) : action.getRestriction().getConditionsDescriptor();
        String parentNodeId = conditionNodeId.substring(0, conditionNodeId.lastIndexOf(45));
        ConditionsDescriptor parentNode = this._getConditionsNode(rootOperator, parentNodeId);
        ConditionDescriptor condition = (ConditionDescriptor)parentNode.getConditions().get(nodeToEdit);
        return condition;
    }

    @Callable(rights={""})
    public Map<String, Object> editCondition(String workflowName, Integer stepId, Integer actionId, String conditionNodeId, Map<String, Object> arguments) throws WorkflowException {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ConditionDescriptor condition = this._getCondition(workflowDescriptor, actionId, conditionNodeId);
        this._updateArguments(condition, arguments);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        return this._getConditionProperties(workflowDescriptor, action, condition, stepId, conditionNodeId);
    }

    private Map<String, Object> _getConditionProperties(WorkflowDescriptor workflow, ActionDescriptor action, ConditionDescriptor condition, Integer stepId, String conditionNodeId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("conditionId", condition.getArgs().get("id"));
        results.put("nodeId", conditionNodeId);
        results.put("actionId", action.getId());
        results.put("actionLabel", this._workflowTransitionDAO.getActionLabel(action));
        results.put("stepId", stepId);
        results.put("stepLabel", this._workflowStepDAO.getStepLabel(workflow, stepId));
        results.put("workflowId", workflow.getName());
        return results;
    }

    private void _updateArguments(ConditionDescriptor condition, Map<String, Object> arguments) {
        Map args = condition.getArgs();
        args.clear();
        args.putAll(this._getConditionParamsValuesAsString(arguments));
    }

    @Callable(rights={""})
    public Map<String, Object> addCondition(String workflowName, Integer stepId, Integer actionId, String parentNodeId, Map<String, Object> arguments) {
        boolean isResultCondition;
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        boolean bl = isResultCondition = !StringUtils.isBlank((CharSequence)parentNodeId) && parentNodeId.startsWith(__STEP_RESULT_PREFIX);
        String computedParentNodeId = StringUtils.isBlank((CharSequence)parentNodeId) ? __AND_ROOT_OPERATOR : (isResultCondition && parentNodeId.split("-").length == 1 ? parentNodeId + "-and0" : parentNodeId);
        ConditionsDescriptor rootOperator = isResultCondition ? this._getResultConditionsRootOperator(workflowName, stepId, actionId, parentNodeId, action) : this._getConditionsRootOperator(workflowName, stepId, actionId, action, parentNodeId);
        ConditionsDescriptor currentParentOperator = this._getConditionsNode(rootOperator, computedParentNodeId);
        if (StringUtils.isBlank((CharSequence)currentParentOperator.getType())) {
            currentParentOperator.setType(AND);
        }
        List conditions = currentParentOperator.getConditions();
        ConditionDescriptor conditionDescriptor = this._createCondition(arguments);
        conditions.add(conditionDescriptor);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        String conditionNodeId = computedParentNodeId + "-condition" + (conditions.size() - 1);
        return this._getConditionProperties(workflowDescriptor, action, conditionDescriptor, stepId, conditionNodeId);
    }

    private ConditionDescriptor _createCondition(Map<String, Object> arguments) {
        DescriptorFactory factory = new DescriptorFactory();
        ConditionDescriptor conditionDescriptor = factory.createConditionDescriptor();
        conditionDescriptor.setType("avalon");
        this._updateArguments(conditionDescriptor, arguments);
        return conditionDescriptor;
    }

    protected Map<String, String> _getConditionParamsValuesAsString(Map<String, Object> params) {
        String conditionId = (String)params.get(__ATTRIBUTE_CONDITIONS_LIST);
        EnhancedCondition enhancedCondition = (EnhancedCondition)this._enhancedConditionExtensionPoint.getExtension(conditionId);
        HashMap<String, String> conditionParams = new HashMap<String, String>();
        conditionParams.put("id", conditionId);
        List<WorkflowArgument> arguments = enhancedCondition.getArguments();
        if (!arguments.isEmpty()) {
            for (WorkflowArgument argument : arguments) {
                String paramKey = conditionId + "-" + argument.getName();
                String paramValue = argument.isMultiple() ? this._getListAsString(params, paramKey) : (String)params.get(paramKey);
                if (StringUtils.isBlank((CharSequence)paramValue)) continue;
                conditionParams.put(argument.getName(), paramValue);
            }
        }
        return conditionParams;
    }

    private String _getListAsString(Map<String, Object> params, String paramKey) {
        List values = (List)params.get(paramKey);
        return values == null ? "" : String.join((CharSequence)",", values);
    }

    protected ConditionsDescriptor _getConditionsRootOperator(String workflowName, Integer stepId, Integer actionId, ActionDescriptor action, String parentNodeId) {
        RestrictionDescriptor restriction = action.getRestriction();
        if (StringUtils.isBlank((CharSequence)parentNodeId) && restriction == null) {
            this.addOperator(workflowName, stepId, actionId, parentNodeId, AND, false);
            restriction = action.getRestriction();
        }
        return restriction.getConditionsDescriptor();
    }

    protected ConditionsDescriptor _getResultConditionsRootOperator(String workflowName, Integer stepId, Integer actionId, String parentNodeId, ActionDescriptor action) {
        int resultStepId = this._getStepId(parentNodeId);
        List conditionalResults = action.getConditionalResults();
        List<ConditionsDescriptor> resultConditions = this._workflowResultDAO.getRootResultConditions(conditionalResults, resultStepId);
        if (resultConditions.isEmpty()) {
            this.addOperator(workflowName, stepId, actionId, parentNodeId, AND, true);
            resultConditions = this._workflowResultDAO.getRootResultConditions(conditionalResults, resultStepId);
        }
        return resultConditions.get(0);
    }

    @Callable(rights={""})
    public Map<String, Object> addOperator(String workflowName, Integer stepId, Integer actionId, String nodeId, String operatorType, boolean isResultCondition) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        DescriptorFactory factory = new DescriptorFactory();
        ConditionsDescriptor newOperator = factory.createConditionsDescriptor();
        newOperator.setType(operatorType);
        boolean isRoot = StringUtils.isBlank((CharSequence)nodeId);
        Object newNodeId = "";
        if (isResultCondition) {
            String[] path = this._workflowResultDAO.getPath(nodeId);
            List conditionalResults = action.getConditionalResults();
            List<ConditionsDescriptor> resultConditions = this._workflowResultDAO.getRootResultConditions(conditionalResults, this._getStepId(nodeId));
            if (resultConditions.isEmpty()) {
                resultConditions.add(newOperator);
                newNodeId = nodeId + "-" + operatorType.toLowerCase() + "0";
            } else {
                isRoot = path.length == 1;
                ConditionsDescriptor rootOperator = resultConditions.get(0);
                ConditionsDescriptor currentOperator = isRoot ? rootOperator : this._getConditionsNode(rootOperator, nodeId);
                List conditions = currentOperator.getConditions();
                conditions.add(newOperator);
                Object parentNodePrefix = isRoot ? nodeId + "-and0" : nodeId;
                newNodeId = (String)parentNodePrefix + "-" + operatorType.toLowerCase() + (conditions.size() - 1);
            }
        } else if (isRoot && action.getRestriction() == null) {
            RestrictionDescriptor restriction = new RestrictionDescriptor();
            restriction.setConditionsDescriptor(newOperator);
            action.setRestriction(restriction);
            newNodeId = operatorType.toLowerCase() + "0";
        } else {
            RestrictionDescriptor restriction = action.getRestriction();
            ConditionsDescriptor rootOperator = restriction.getConditionsDescriptor();
            ConditionsDescriptor currentOperator = isRoot ? rootOperator : this._getConditionsNode(rootOperator, nodeId);
            List conditions = currentOperator.getConditions();
            conditions.add(newOperator);
            String parentNodePrefix = isRoot ? __AND_ROOT_OPERATOR : nodeId;
            newNodeId = parentNodePrefix + "-" + operatorType.toLowerCase() + (conditions.size() - 1);
        }
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getOperatorProperties(workflowDescriptor, action, stepId, operatorType, (String)newNodeId);
    }

    private Map<String, Object> _getOperatorProperties(WorkflowDescriptor workflowDescriptor, ActionDescriptor action, Integer stepId, String operatorType, String newNodeId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("nodeId", newNodeId);
        results.put("type", operatorType);
        results.put("actionId", action.getId());
        results.put("actionLabel", this._workflowTransitionDAO.getActionLabel(action));
        results.put("stepId", stepId);
        results.put("stepLabel", this._workflowStepDAO.getStepLabel(workflowDescriptor, stepId));
        results.put("workflowId", workflowDescriptor.getName());
        return results;
    }

    private Integer _getStepId(String nodeId) {
        String[] path = this._workflowResultDAO.getPath(nodeId);
        return Integer.valueOf(path[0].substring(4));
    }

    private ConditionsDescriptor _getConditionsNode(ConditionsDescriptor rootOperator, String nodeId) {
        ConditionsDescriptor currentOperator = rootOperator;
        List conditions = rootOperator.getConditions();
        String[] path = this._workflowResultDAO.getPath(nodeId);
        boolean isResultCondition = path[0].startsWith(__STEP_RESULT_PREFIX);
        if (!isResultCondition && path.length > 1 || isResultCondition && path.length > 2) {
            int i = isResultCondition ? 2 : 1;
            do {
                int currentOrAndConditionIndex = this._getConditionIndex(path, i);
                currentOperator = (ConditionsDescriptor)conditions.get(currentOrAndConditionIndex);
                conditions = currentOperator.getConditions();
            } while (++i < path.length);
        }
        return currentOperator;
    }

    private int _getConditionIndex(String[] path, int conditionIndex) {
        String currentConditionId = path[conditionIndex];
        int prefixSize = currentConditionId.startsWith("and") ? "and".length() : (currentConditionId.startsWith("or") ? "or".length() : "condition".length());
        return Integer.valueOf(currentConditionId.substring(prefixSize));
    }

    @Callable(rights={""})
    public Map<String, Object> deleteOperator(String workflowName, Integer stepId, Integer actionId, String nodeId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        String[] path = this._workflowResultDAO.getPath(nodeId);
        boolean isResultCondition = nodeId.startsWith(__STEP_RESULT_PREFIX);
        if (isResultCondition) {
            this._removeResultConditionOperator(nodeId, action, path);
        } else {
            this._removeConditionOperator(nodeId, action, path);
        }
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        String type = path[path.length - 1].startsWith("and") ? AND : OR;
        return this._getOperatorProperties(workflowDescriptor, action, stepId, type, nodeId);
    }

    protected void _removeConditionOperator(String nodeId, ActionDescriptor action, String[] path) {
        if (path.length > 1) {
            ConditionsDescriptor rootCondition = action.getRestriction().getConditionsDescriptor();
            this._removeCondition(rootCondition, nodeId, path);
        } else {
            action.setRestriction(null);
        }
    }

    protected void _removeResultConditionOperator(String nodeId, ActionDescriptor action, String[] path) {
        if (path.length > 2) {
            ConditionsDescriptor rootCondition = this._workflowResultDAO.getRootResultConditions(action.getConditionalResults(), this._getStepId(nodeId)).get(0);
            this._removeCondition(rootCondition, nodeId, path);
        } else {
            Optional<Object> parentConditionalResult = action.getConditionalResults().stream().filter(cr -> ((ConditionalResultDescriptor)cr).getStep() == this._getStepId(nodeId).intValue()).findFirst();
            if (parentConditionalResult.isPresent()) {
                ((ConditionalResultDescriptor)parentConditionalResult.get()).getConditions().clear();
            }
        }
    }

    @Callable(rights={""})
    public Map<String, Object> deleteCondition(String workflowName, Integer stepId, Integer actionId, String nodeId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        String[] path = this._workflowResultDAO.getPath(nodeId);
        boolean isResultCondition = nodeId.startsWith(__STEP_RESULT_PREFIX);
        ConditionsDescriptor rootCondition = isResultCondition ? this._workflowResultDAO.getRootResultConditions(action.getConditionalResults(), this._getStepId(nodeId)).get(0) : action.getRestriction().getConditionsDescriptor();
        int lastIndexOf = nodeId.lastIndexOf(45);
        String parentNodeId = nodeId.substring(0, lastIndexOf);
        ConditionsDescriptor parentNode = this._getConditionsNode(rootCondition, parentNodeId);
        int nodeToDeleteIndex = this._getConditionIndex(path, path.length - 1);
        List conditions = parentNode.getConditions();
        ConditionDescriptor conditionToRemove = (ConditionDescriptor)conditions.get(nodeToDeleteIndex);
        conditions.remove(conditionToRemove);
        if (conditions.isEmpty() && (path.length == 1 || path.length == 2 && path[0].startsWith(AND))) {
            action.setRestriction(null);
        }
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getConditionProperties(workflowDescriptor, action, conditionToRemove, stepId, nodeId);
    }

    protected List _removeCondition(ConditionsDescriptor rootCondition, String conditionNodeId, String[] conditionPath) {
        int lastIndexOf = conditionNodeId.lastIndexOf(45);
        String parentNodeId = conditionNodeId.substring(0, lastIndexOf);
        ConditionsDescriptor parentNode = this._getConditionsNode(rootCondition, parentNodeId);
        int nodeToDeleteIndex = this._getConditionIndex(conditionPath, conditionPath.length - 1);
        List conditions = parentNode.getConditions();
        conditions.remove(nodeToDeleteIndex);
        return conditions;
    }

    @Callable(rights={""})
    public Map<String, Object> getConditionNodes(String currentNode, String workflowName, Integer actionId) {
        ActionDescriptor action;
        List<AbstractDescriptor> conditions;
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        if (this._workflowRightHelper.canRead(workflowDescriptor) && !(conditions = this._getConditions(currentNode, action = workflowDescriptor.getAction(actionId.intValue()))).isEmpty()) {
            boolean rootIsAND = !action.getRestriction().getConditionsDescriptor().getType().equals(OR);
            for (int i = 0; i < conditions.size(); ++i) {
                nodes.add(this.conditionToJSON(conditions.get(i), currentNode, i, rootIsAND));
            }
        }
        return Map.of("conditions", nodes);
    }

    protected List<AbstractDescriptor> _getConditions(String currentNode, ActionDescriptor action) {
        RestrictionDescriptor restriction = action.getRestriction();
        if (restriction != null) {
            ConditionsDescriptor rootConditionsDescriptor = restriction.getConditionsDescriptor();
            String[] path = this._workflowResultDAO.getPath(currentNode);
            if (__ROOT_RESULT_ID.equals(currentNode) && rootConditionsDescriptor.getType().equals(OR)) {
                return List.of(rootConditionsDescriptor);
            }
            if (path.length == 1) {
                return rootConditionsDescriptor.getConditions();
            }
            if (!path[path.length - 1].startsWith("condition")) {
                List conditions = rootConditionsDescriptor.getConditions();
                int i = 1;
                do {
                    String currentOrAndConditionId;
                    int currentOrAndConditionIndex = (currentOrAndConditionId = path[i]).startsWith("and") ? Integer.valueOf(currentOrAndConditionId.substring(3)) : Integer.valueOf(currentOrAndConditionId.substring(2));
                    ConditionsDescriptor currentOrAndCondition = (ConditionsDescriptor)conditions.get(currentOrAndConditionIndex);
                    conditions = currentOrAndCondition.getConditions();
                } while (++i < path.length);
                return conditions;
            }
        }
        return List.of();
    }

    public Map<String, Object> conditionToJSON(AbstractDescriptor condition, String currentNodeId, int index, boolean rootIsAND) {
        Object prefix;
        HashMap<String, Object> infosConditions = new HashMap<String, Object>();
        boolean isResult = currentNodeId.startsWith(__STEP_RESULT_PREFIX);
        boolean isRoot = __ROOT_RESULT_ID.equals(currentNodeId) || isResult && this._workflowResultDAO.getPath(currentNodeId).length == 1;
        Object object = prefix = isResult && isRoot ? currentNodeId + "-" : "";
        prefix = (String)prefix + (isRoot && rootIsAND ? __AND_ROOT_OPERATOR : (isRoot ? __OR_ROOT_OPERATOR : currentNodeId));
        if (condition instanceof ConditionsDescriptor) {
            ConditionsDescriptor operator = (ConditionsDescriptor)condition;
            String type = ((ConditionsDescriptor)condition).getType();
            if (!type.equals(OR)) {
                String id = (String)prefix + "-and" + index;
                infosConditions.put("id", id);
                I18nizableText i18nLabel = new I18nizableText("plugin.workflow", __ANDI18N);
                infosConditions.put("label", i18nLabel);
            } else {
                Object id = isRoot && !rootIsAND ? prefix : (String)prefix + "-or" + index;
                infosConditions.put("id", id);
                I18nizableText i18nLabel = new I18nizableText("plugin.workflow", __ORI18N);
                infosConditions.put("label", i18nLabel);
            }
            infosConditions.put("hasChildren", !operator.getConditions().isEmpty());
        } else {
            String id = (String)prefix + "-condition" + index;
            infosConditions.put("id", id);
            infosConditions.put("conditionId", ((ConditionDescriptor)condition).getArgs().get("id"));
            infosConditions.put("label", this._getConditionLabel((ConditionDescriptor)condition));
            infosConditions.put("hasChildren", false);
        }
        return infosConditions;
    }

    @Callable(rights={""})
    public I18nizableText getConditionLabel(String workflowName, Integer actionId, String nodeId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkReadRight(workflowDescriptor);
        ConditionDescriptor condition = this._getCondition(workflowDescriptor, actionId, nodeId);
        return this._getConditionLabel(condition);
    }

    @Callable(rights={""})
    public boolean hasChildConditions(String workflowName, Integer actionId, String nodeId) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkReadRight(workflowDescriptor);
        ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
        List<AbstractDescriptor> conditions = nodeId.startsWith(__STEP_RESULT_PREFIX) ? this._workflowResultDAO.getChildrenResultConditions(nodeId, action, action.getConditionalResults()) : this._getConditions(nodeId, action);
        return !conditions.isEmpty();
    }

    protected I18nizableText _getConditionLabel(ConditionDescriptor condition) {
        String id = (String)condition.getArgs().get("id");
        AvalonTypeResolver typeResolver = new AvalonTypeResolver(this._manager);
        try {
            Condition function = typeResolver.getCondition(condition.getType(), condition.getArgs());
            if (function instanceof EnhancedCondition) {
                EnhancedCondition enhancedCondition = (EnhancedCondition)function;
                List<WorkflowArgument> arguments = enhancedCondition.getArguments();
                HashMap<String, String> values = new HashMap<String, String>();
                for (WorkflowArgument arg : arguments) {
                    values.put(arg.getName(), (String)condition.getArgs().get(arg.getName()));
                }
                I18nizableText description = this._getDescription(enhancedCondition, values);
                return description != null ? description : new I18nizableText(id);
            }
        }
        catch (WorkflowException e) {
            this.getLogger().warn("An error occured while resolving condition with id {}", (Object)id, (Object)e);
        }
        return new I18nizableText(id);
    }

    private I18nizableText _getDescription(EnhancedCondition function, Map<String, String> values) {
        try {
            return function.getFullLabel(values);
        }
        catch (Exception e) {
            this.getLogger().warn("Can't get description for condition '{}': a parameter might be missing", (Object)function.getClass().getName(), (Object)e);
            return null;
        }
    }
}

