/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.dao;

import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.plugins.workflow.EnhancedFunctionExtensionPoint;
import org.ametys.plugins.workflow.ModelItemTypeExtensionPoint;
import org.ametys.plugins.workflow.component.WorkflowArgument;
import org.ametys.plugins.workflow.dao.WorkflowStepDAO;
import org.ametys.plugins.workflow.dao.WorkflowTransitionDAO;
import org.ametys.plugins.workflow.support.AvalonTypeResolver;
import org.ametys.plugins.workflow.support.WorflowRightHelper;
import org.ametys.plugins.workflow.support.WorkflowElementDefinitionHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowSessionHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WorkflowFunctionDAO
extends AbstractLogEnabled
implements Component,
Serviceable {
    protected static ModelItemTypeExtensionPoint _workflowArgumentDataTypeExtensionPoint;
    private static final String __FUNCTION_DEFAULT_TYPE = "avalon";
    private static final String __ATTRIBUTE_FUNCTIONS_LIST = "functions-list";
    private static final String __ATTRIBUTE_FUNCTION_TYPES = "function-types";
    protected WorkflowSessionHelper _workflowSessionHelper;
    protected WorflowRightHelper _workflowRightHelper;
    protected WorkflowStepDAO _workflowStepDAO;
    protected WorkflowTransitionDAO _workflowTransitionDAO;
    protected ServiceManager _manager;
    protected EnhancedFunctionExtensionPoint _enhancedFunctionExtensionPoint;

    public void service(ServiceManager smanager) throws ServiceException {
        this._workflowSessionHelper = (WorkflowSessionHelper)((Object)smanager.lookup(WorkflowSessionHelper.ROLE));
        this._workflowRightHelper = (WorflowRightHelper)smanager.lookup(WorflowRightHelper.ROLE);
        this._workflowStepDAO = (WorkflowStepDAO)((Object)smanager.lookup(WorkflowStepDAO.ROLE));
        this._workflowTransitionDAO = (WorkflowTransitionDAO)smanager.lookup(WorkflowTransitionDAO.ROLE);
        this._enhancedFunctionExtensionPoint = (EnhancedFunctionExtensionPoint)((Object)smanager.lookup(EnhancedFunctionExtensionPoint.ROLE));
        _workflowArgumentDataTypeExtensionPoint = (ModelItemTypeExtensionPoint)((Object)smanager.lookup(ModelItemTypeExtensionPoint.ROLE_WORKFLOW));
        this._manager = smanager;
    }

    @Callable(rights={"Workflow_Right_Edit", "Workflow_Right_Edit_User"})
    public Map<String, Object> getFunctionsModel() throws ProcessingException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        View view = new View();
        SimpleViewItemGroup fieldset = new SimpleViewItemGroup();
        fieldset.setName("functions");
        Set<Pair<String, EnhancedFunction>> enhancedFunctions = this._enhancedFunctionExtensionPoint.getAllFunctions().stream().filter(this::_hasFunctionRight).collect(Collectors.toSet());
        ElementDefinition<String> functionsList = this._getFunctionListModelItem(enhancedFunctions);
        List<ElementDefinition> argumentModelItems = this._getArgumentsAndTypeModelItems(enhancedFunctions);
        ViewElement functionListView = new ViewElement();
        functionListView.setDefinition(functionsList);
        fieldset.addViewItem((ViewItem)functionListView);
        for (ElementDefinition functionArgument : argumentModelItems) {
            ViewElement argumentView = new ViewElement();
            argumentView.setDefinition(functionArgument);
            fieldset.addViewItem((ViewItem)argumentView);
        }
        view.addViewItem((ViewItem)fieldset);
        response.put("parameters", view.toJSON(DefinitionContext.newInstance().withEdition(true)));
        return response;
    }

    private boolean _hasFunctionRight(Pair<String, EnhancedFunction> function) {
        List<WorkflowHelper.WorkflowVisibility> functionVisibilities = ((EnhancedFunction)function.getRight()).getVisibilities();
        if (functionVisibilities.contains((Object)WorkflowHelper.WorkflowVisibility.USER)) {
            return this._workflowRightHelper.hasEditUserRight();
        }
        if (functionVisibilities.contains((Object)WorkflowHelper.WorkflowVisibility.SYSTEM)) {
            return this._workflowRightHelper.hasEditSystemRight();
        }
        return false;
    }

    protected List<ElementDefinition> _getArgumentsAndTypeModelItems(Set<Pair<String, EnhancedFunction>> enhancedFunctions) {
        ArrayList<ElementDefinition> argumentModelItems = new ArrayList<ElementDefinition>();
        for (Pair<String, EnhancedFunction> functionPair : enhancedFunctions) {
            String functionId = (String)functionPair.getLeft();
            DisableCondition disableCondition = new DisableCondition(__ATTRIBUTE_FUNCTIONS_LIST, DisableCondition.OPERATOR.NEQ, functionId);
            EnhancedFunction function = (EnhancedFunction)functionPair.getRight();
            if (function.getFunctionExecType().equals((Object)EnhancedFunction.FunctionType.BOTH)) {
                argumentModelItems.add(this._getFunctionTypeModelItem(functionId, disableCondition));
            }
            for (WorkflowArgument arg : function.getArguments()) {
                arg.setName(functionId + "-" + arg.getName());
                DisableConditions disableConditions = arg.getDisableConditions();
                if (disableConditions == null) {
                    disableConditions = new DisableConditions();
                }
                disableConditions.setAssociation(DisableConditions.ASSOCIATION_TYPE.OR);
                disableConditions.getConditions().add(disableCondition);
                arg.setDisableConditions(disableConditions);
                argumentModelItems.add((ElementDefinition)arg);
            }
        }
        return argumentModelItems;
    }

    protected ElementDefinition<String> _getFunctionListModelItem(Set<Pair<String, EnhancedFunction>> enhancedFunctions) {
        WorkflowArgument functionsList = WorkflowElementDefinitionHelper.getElementDefinition(__ATTRIBUTE_FUNCTIONS_LIST, new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_ADD_FUNCTION_DIALOG_ROLE"), new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_ADD_FUNCTION_DIALOG_ROLE_DESC"), true, false);
        StaticEnumerator functionsStaticEnumerator = new StaticEnumerator();
        for (Pair<String, EnhancedFunction> function : enhancedFunctions) {
            functionsStaticEnumerator.add(((EnhancedFunction)function.getRight()).getLabel(), (Object)((String)function.getLeft()));
        }
        functionsList.setEnumerator((Enumerator)functionsStaticEnumerator);
        return functionsList;
    }

    protected ElementDefinition<String> _getFunctionTypeModelItem(String functionId, DisableCondition disableCondition) {
        DisableConditions disableConditions = new DisableConditions();
        disableConditions.getConditions().add(disableCondition);
        StaticEnumerator functionTypeStaticEnum = new StaticEnumerator();
        functionTypeStaticEnum.add(new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_ADD_FUNCTION_DIALOG_PREFUNCTION_TYPE"), (Object)EnhancedFunction.FunctionType.PRE.name());
        functionTypeStaticEnum.add(new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_ADD_FUNCTION_DIALOG_POSTFUNCTION_TYPE"), (Object)EnhancedFunction.FunctionType.POST.name());
        WorkflowArgument functionTypes = WorkflowElementDefinitionHelper.getElementDefinition("function-types-" + functionId, new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_ADD_FUNCTION_DIALOG_TYPES_LABEL"), new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_ADD_FUNCTION_DIALOG_TYPES_DESC"), true, false);
        functionTypes.setDisableConditions(disableConditions);
        functionTypes.setEnumerator((Enumerator)functionTypeStaticEnum);
        return functionTypes;
    }

    @Callable(rights={""})
    public Map<String, Object> getFunctionParametersValues(String workflowName, Integer stepId, Integer actionId, String type, String id, Integer index) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        HashMap<String, String> args = new HashMap<String, String>();
        FunctionDescriptor function = this._getFunction(workflowDescriptor, stepId, actionId, type, index);
        Map arguments = function.getArgs();
        for (Map.Entry entry : arguments.entrySet()) {
            String argName = ((String)entry.getKey()).equals("id") ? __ATTRIBUTE_FUNCTIONS_LIST : id + "-" + (String)entry.getKey();
            args.put(argName, (String)entry.getValue());
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("parametersValues", args);
        return results;
    }

    private FunctionDescriptor _getFunction(WorkflowDescriptor workflowDescriptor, Integer stepId, Integer actionId, String type, Integer index) {
        List<FunctionDescriptor> functions = this._getTypedFunctions(workflowDescriptor, stepId, actionId, type);
        FunctionDescriptor function = functions.get(index);
        return function;
    }

    @Callable(rights={""})
    public Map<String, Object> addFunction(String workflowName, Integer stepId, Integer actionId, Map<String, Object> params) {
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflowDescriptor);
        String functionId = (String)params.get(__ATTRIBUTE_FUNCTIONS_LIST);
        EnhancedFunction enhancedFunction = (EnhancedFunction)this._enhancedFunctionExtensionPoint.getExtension(functionId);
        String functionType = enhancedFunction.getFunctionExecType().equals((Object)EnhancedFunction.FunctionType.BOTH) ? (String)params.get("function-types-" + functionId) : enhancedFunction.getFunctionExecType().name();
        List<FunctionDescriptor> functions = this._getTypedFunctions(workflowDescriptor, stepId, actionId, functionType);
        Map<String, String> functionParams = this._getFunctionParamsValuesAsString(enhancedFunction, functionId, params);
        FunctionDescriptor newFunction = this._createFunctionDescriptor(functionParams);
        functions.add(newFunction);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflowDescriptor);
        return this._getFunctionInfos(workflowDescriptor, stepId, actionId, functionType, functionId, functions.size() - 1, true);
    }

    private FunctionDescriptor _createFunctionDescriptor(Map<String, String> functionParams) {
        DescriptorFactory factory = new DescriptorFactory();
        FunctionDescriptor newFunction = factory.createFunctionDescriptor();
        newFunction.setType(__FUNCTION_DEFAULT_TYPE);
        newFunction.getArgs().putAll(functionParams);
        return newFunction;
    }

    protected Map<String, String> _getFunctionParamsValuesAsString(EnhancedFunction enhancedFunction, String functionId, Map<String, Object> params) {
        HashMap<String, String> functionParams = new HashMap<String, String>();
        functionParams.put("id", functionId);
        List<WorkflowArgument> arguments = enhancedFunction.getArguments();
        if (!arguments.isEmpty()) {
            for (WorkflowArgument argument : arguments) {
                String paramKey = functionId + "-" + argument.getName();
                String paramValue = argument.isMultiple() ? this._getListAsString(params, paramKey) : (String)params.get(paramKey);
                if (!StringUtils.isNotBlank((String)paramValue)) continue;
                functionParams.put(argument.getName(), paramValue);
            }
        }
        return functionParams;
    }

    private String _getListAsString(Map<String, Object> params, String paramKey) {
        List values = (List)params.get(paramKey);
        return values == null ? "" : String.join((CharSequence)",", values);
    }

    protected List<FunctionDescriptor> _getTypedFunctions(WorkflowDescriptor workflowDescriptor, Integer stepId, Integer actionId, String functionType) {
        ArrayList<FunctionDescriptor> functions = new ArrayList();
        if (actionId != null) {
            ActionDescriptor action = workflowDescriptor.getAction(actionId.intValue());
            functions = functionType.equals(EnhancedFunction.FunctionType.PRE.name()) ? action.getPreFunctions() : action.getPostFunctions();
        } else {
            StepDescriptor step = workflowDescriptor.getStep(stepId.intValue());
            functions = functionType.equals(EnhancedFunction.FunctionType.PRE.name()) ? step.getPreFunctions() : step.getPostFunctions();
        }
        return functions;
    }

    @Callable(rights={""})
    public Map<String, Object> editFunction(String workflowName, Integer stepId, Integer actionId, String oldType, Map<String, Object> params, int indexOfFunction) {
        String newType;
        WorkflowDescriptor workflow = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflow);
        List<FunctionDescriptor> functions = this._getTypedFunctions(workflow, stepId, actionId, oldType);
        FunctionDescriptor function = functions.get(indexOfFunction);
        int index = indexOfFunction;
        String functionId = (String)params.get(__ATTRIBUTE_FUNCTIONS_LIST);
        EnhancedFunction enhancedFunction = (EnhancedFunction)this._enhancedFunctionExtensionPoint.getExtension(functionId);
        String functionType = (String)params.get("function-types-" + functionId);
        String string = newType = StringUtils.isBlank((String)functionType) ? enhancedFunction.getFunctionExecType().name() : functionType;
        if (!oldType.equals(newType)) {
            functions.remove(function);
            functions = this._getTypedFunctions(workflow, stepId, actionId, newType);
            functions.add(function);
            index = functions.size() - 1;
        }
        this._updateFunctionArguments(function, functionId, enhancedFunction, params);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflow);
        return this._getFunctionInfos(workflow, stepId, actionId, newType, functionId, index, this._isLast(functions, indexOfFunction));
    }

    private void _updateFunctionArguments(FunctionDescriptor function, String functionId, EnhancedFunction enhancedFunction, Map<String, Object> params) {
        Map args = function.getArgs();
        args.clear();
        args.putAll(this._getFunctionParamsValuesAsString(enhancedFunction, functionId, params));
    }

    @Callable(rights={""})
    public Map<String, Object> deleteFunction(String workflowName, Integer stepId, Integer actionId, String functionType, String id, int indexToRemove) {
        WorkflowDescriptor workflow = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflow);
        List<FunctionDescriptor> functions = this._getTypedFunctions(workflow, stepId, actionId, functionType);
        functions.remove(indexToRemove);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflow);
        return this._getFunctionInfos(workflow, stepId, actionId, functionType, id, indexToRemove, this._isLast(functions, indexToRemove));
    }

    @Callable(rights={""})
    public Map<String, Object> moveUp(String workflowName, Integer stepId, Integer actionId, String functionType, int functionIndex) {
        WorkflowDescriptor workflow = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflow);
        if (functionIndex == 0) {
            return Map.of("message", "top-queue");
        }
        List<FunctionDescriptor> functions = this._getTypedFunctions(workflow, stepId, actionId, functionType);
        FunctionDescriptor functionToMove = functions.get(functionIndex);
        Collections.swap(functions, functionIndex, functionIndex - 1);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflow);
        return this._getFunctionInfos(workflow, stepId, actionId, functionType, (String)functionToMove.getArgs().get("id"), functionIndex - 1, false);
    }

    @Callable(rights={""})
    public Map<String, Object> moveDown(String workflowName, Integer stepId, Integer actionId, String functionType, int functionIndex) {
        WorkflowDescriptor workflow = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, true);
        this._workflowRightHelper.checkEditRight(workflow);
        List<FunctionDescriptor> functions = this._getTypedFunctions(workflow, stepId, actionId, functionType);
        if (functionIndex == functions.size() - 1) {
            return Map.of("message", "bottom-queue");
        }
        FunctionDescriptor functionToMove = functions.get(functionIndex);
        Collections.swap(functions, functionIndex, functionIndex + 1);
        this._workflowSessionHelper.updateWorkflowDescriptor(workflow);
        return this._getFunctionInfos(workflow, stepId, actionId, functionType, (String)functionToMove.getArgs().get("id"), functionIndex + 1, this._isLast(functions, functionIndex + 1));
    }

    protected boolean _isLast(List<FunctionDescriptor> functions, int functionIndex) {
        return functionIndex == functions.size() - 1;
    }

    @Callable(rights={""})
    public Map<String, Object> getStepFunctions(String workflowName, Integer stepId) {
        StepDescriptor step;
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        ArrayList<Map<String, Object>> functions2json = new ArrayList<Map<String, Object>>();
        if (this._workflowRightHelper.canRead(workflowDescriptor) && (step = workflowDescriptor.getStep(stepId.intValue())) != null) {
            functions2json.addAll(this._functions2JSON(step.getPreFunctions(), EnhancedFunction.FunctionType.PRE.name()));
            functions2json.addAll(this._functions2JSON(step.getPostFunctions(), EnhancedFunction.FunctionType.POST.name()));
        }
        return Map.of("data", functions2json);
    }

    @Callable(rights={""})
    public Map<String, Object> getActionFunctions(String workflowName, Integer actionId) {
        ActionDescriptor action;
        WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        ArrayList<Map<String, Object>> functions2json = new ArrayList<Map<String, Object>>();
        if (this._workflowRightHelper.canRead(workflowDescriptor) && (action = workflowDescriptor.getAction(actionId.intValue())) != null) {
            functions2json.addAll(this._functions2JSON(action.getPreFunctions(), EnhancedFunction.FunctionType.PRE.name()));
            functions2json.addAll(this._functions2JSON(action.getPostFunctions(), EnhancedFunction.FunctionType.POST.name()));
        }
        return Map.of("data", functions2json);
    }

    private List<Map<String, Object>> _functions2JSON(List<FunctionDescriptor> functions, String type) {
        ArrayList<Map<String, Object>> functions2json = new ArrayList<Map<String, Object>>();
        for (int index = 0; index < functions.size(); ++index) {
            functions2json.add(this._function2JSON(functions.get(index), type, index, this._isLast(functions, index)));
        }
        return functions2json;
    }

    private Map<String, Object> _function2JSON(FunctionDescriptor workflowFunction, String type, int index, boolean isLast) {
        String id = (String)workflowFunction.getArgs().get("id");
        HashMap<String, Object> functionInfos = new HashMap<String, Object>();
        functionInfos.put("type", type);
        functionInfos.put("id", id);
        functionInfos.put("index", index);
        functionInfos.put("isLast", isLast);
        try {
            EnhancedFunction enhancedFunction;
            I18nizableText description;
            AvalonTypeResolver typeResolver = new AvalonTypeResolver(this._manager);
            FunctionProvider function = typeResolver.getFunction(workflowFunction.getType(), workflowFunction.getArgs());
            if (function instanceof EnhancedFunction && (description = this._getFunctionDescription(workflowFunction, enhancedFunction = (EnhancedFunction)function)) != null) {
                functionInfos.put("description", description);
            }
        }
        catch (WorkflowException e) {
            this.getLogger().error("Function " + id + " couldn't be resolved", (Throwable)e);
        }
        return functionInfos;
    }

    private I18nizableText _getFunctionDescription(FunctionDescriptor workflowFunction, EnhancedFunction enhancedFunction) {
        List<WorkflowArgument> arguments = enhancedFunction.getArguments();
        HashMap<String, String> values = new HashMap<String, String>();
        for (WorkflowArgument arg : arguments) {
            values.put(arg.getName(), (String)workflowFunction.getArgs().get(arg.getName()));
        }
        I18nizableText description = enhancedFunction.getFullLabel(values);
        return description;
    }

    @Callable(rights={""})
    public I18nizableText getFunctionDescription(String workflowName, Integer stepId, Integer actionId, String type, String id, Integer index) {
        WorkflowDescriptor workflow = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
        this._workflowRightHelper.checkReadRight(workflow);
        FunctionDescriptor function = this._getFunction(workflow, stepId, actionId, type, index);
        EnhancedFunction enhancedFunction = (EnhancedFunction)this._enhancedFunctionExtensionPoint.getExtension(id);
        return this._getFunctionDescription(function, enhancedFunction);
    }

    private Map<String, Object> _getFunctionInfos(WorkflowDescriptor workflow, Integer stepId, Integer actionId, String type, String id, int index, boolean isLast) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("workflowId", workflow.getName());
        results.put("stepId", stepId);
        results.put("stepLabel", this._workflowStepDAO.getStepLabel(workflow, stepId));
        if (actionId != null) {
            ActionDescriptor action = workflow.getAction(actionId.intValue());
            results.put("actionId", actionId);
            results.put("actionLabel", this._workflowTransitionDAO.getActionLabel(action));
        }
        results.put("type", type);
        results.put("id", id);
        results.put("index", index);
        results.put("isLast", isLast);
        return results;
    }
}

