/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.readers;

import org.ametys.plugins.workflow.readers.AbstractPlantUMLSVGReader;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPlantUMLMindmapSVGReader
extends AbstractPlantUMLSVGReader {
    @Override
    protected String _getPlantUMLType() {
        return "mindmap";
    }

    protected String _getMindMapNodeContent(String positionPrefix, String label, String iconPath, String color, String jsFunction, String linkTooltip, boolean isBoxless) {
        StringBuilder nodeContent = new StringBuilder(positionPrefix);
        if (isBoxless) {
            nodeContent.append("_");
        }
        if (StringUtils.isNotBlank((CharSequence)color)) {
            nodeContent.append("[" + color + "]");
        }
        if (StringUtils.isNotBlank((CharSequence)jsFunction)) {
            nodeContent.append(" [[javascript:parent." + jsFunction + " ");
            if (StringUtils.isNotBlank((CharSequence)linkTooltip)) {
                nodeContent.append("{" + linkTooltip + "}");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)iconPath)) {
            nodeContent.append(" <img:" + iconPath + ">");
        }
        nodeContent.append(" " + label);
        if (StringUtils.isNotBlank((CharSequence)jsFunction)) {
            nodeContent.append("]] ");
        }
        nodeContent.append(" \n");
        return nodeContent.toString();
    }
}

