/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.readers;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.List;
import org.ametys.plugins.workflow.dao.WorkflowStepDAO;
import org.ametys.plugins.workflow.readers.AbstractPlantUMLSVGReader;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class PlantUMLSVGReader
extends AbstractPlantUMLSVGReader {
    @Override
    protected String _getPlantUMLType() {
        return "uml";
    }

    @Override
    protected String _getPlantUMLStyle() {
        StringBuilder style = new StringBuilder();
        style.append("skinparam HyperLinkUnderline false \n");
        style.append("skinparam HyperLinkColor #0a7fb2 \n");
        style.append("skinparam State { \n");
        style.append("BorderThickness 1.5 \n");
        style.append("} \n");
        style.append("hide empty description\n");
        return style.toString();
    }

    @Override
    protected String _getPlantUMLGraphContent(Request request, WorkflowDescriptor workflowDescriptor) {
        List steps = workflowDescriptor.getSteps();
        StringBuilder content = new StringBuilder();
        if (steps.isEmpty()) {
            content.append("title \n");
            content.append(this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workflow", "PLUGIN_WORKFLOW_PREVIEW_EMPTY_WORKFLOW")) + " \n");
            content.append("end title \n");
        } else {
            for (StepDescriptor step : steps) {
                content.append(this._createState(workflowDescriptor, step));
                List actions = step.getActions();
                for (ActionDescriptor action : actions) {
                    content.append(this._createTransition(workflowDescriptor, step, action));
                }
            }
            List initialActions = workflowDescriptor.getInitialActions();
            for (ActionDescriptor initialAction : initialActions) {
                ResultDescriptor unconditionalResult = initialAction.getUnconditionalResult();
                String workflowName = workflowDescriptor.getName();
                String stepLabel = this._i18nHelper.translateKey(workflowName, this._workflowStepDAO.getStepLabel(workflowDescriptor, 0), WorkflowStepDAO.DEFAULT_STEP_NAME);
                stepLabel = this._getStringWithEscapedSpace(stepLabel);
                String actionLabel = this._workflowTransitionDAO.getActionLabel(workflowName, initialAction);
                actionLabel = this._getStringWithEscapedSpace(actionLabel);
                String actionContent = this._getTransitionArrow("[*]", String.valueOf(unconditionalResult.getStep()), this._getActionLabel(workflowName, initialAction), this._workflowTransitionDAO.getActionIconPathAsBase64(workflowName, initialAction), this._getJsFunction(workflowName, "0", stepLabel, String.valueOf(initialAction.getId()), actionLabel), this._getActionTooltip(initialAction), false);
                content.append(actionContent);
            }
        }
        return content.toString();
    }

    protected String _getTransitionArrow(String incomingState, String outgoingState, String label, String iconPath, String jsFunction, String linkTooltip, boolean isDashed) {
        StringBuilder nodeContent = new StringBuilder(incomingState);
        nodeContent.append(isDashed ? " -[dashed]-> " : " --> ");
        nodeContent.append(outgoingState);
        if (StringUtils.isNotBlank((CharSequence)label)) {
            nodeContent.append(": ");
            nodeContent.append(" [[javascript:parent." + jsFunction + " ");
            nodeContent.append("{" + linkTooltip + "}");
            if (StringUtils.isNotBlank((CharSequence)iconPath)) {
                nodeContent.append(" <img:" + iconPath + ">");
            }
            nodeContent.append(" " + label);
            nodeContent.append("]]");
        }
        nodeContent.append(" \n");
        return nodeContent.toString();
    }

    protected String _createState(WorkflowDescriptor workflow, StepDescriptor step) {
        Object stepToUML = "";
        String steplabel = this._getStepNodeLabel(workflow, step.getId());
        String stepLabelForJs = this._i18nHelper.translateKey(workflow.getName(), this._workflowStepDAO.getStepLabel(workflow, step.getId()), WorkflowStepDAO.DEFAULT_STEP_NAME);
        stepLabelForJs = this._getStringWithEscapedSpace(stepLabelForJs);
        String elementAbsoluteIconPath = this._workflowStepDAO.getStepIconPathAsBase64(workflow, step.getId());
        String stepId = String.valueOf(step.getId());
        String toolip = " {" + this._getStepTooltip(step) + "}";
        Object icon = StringUtils.isBlank((CharSequence)elementAbsoluteIconPath) ? "" : "<img:" + elementAbsoluteIconPath + "> ";
        String jsFunction = " [[javascript:parent." + this._getJsFunction(workflow.getName(), stepId, stepLabelForJs, null, null) + toolip + "]]";
        stepToUML = "state \"" + (String)icon + steplabel + "\" as " + stepId + jsFunction + "#e5f8ff \n";
        return stepToUML;
    }

    protected String _createTransition(WorkflowDescriptor workflow, StepDescriptor step, ActionDescriptor transition) {
        StringBuilder transitionToUML = new StringBuilder();
        String workflowName = workflow.getName();
        String transitionlabel = this._getActionLabel(workflowName, transition);
        String stepLabel = this._i18nHelper.translateKey(workflow.getName(), this._workflowStepDAO.getStepLabel(workflow, step.getId()), WorkflowStepDAO.DEFAULT_STEP_NAME);
        stepLabel = this._getStringWithEscapedSpace(stepLabel);
        String actionLabel = this._workflowTransitionDAO.getActionLabel(workflowName, transition);
        actionLabel = this._getStringWithEscapedSpace(actionLabel);
        String tooltip = this._getActionTooltip(transition);
        String elementAbsoluteIconPath = this._workflowTransitionDAO.getActionIconPathAsBase64(workflowName, transition);
        String jsFunction = this._getJsFunction(workflow.getName(), String.valueOf(step.getId()), stepLabel, String.valueOf(transition.getId()), actionLabel);
        String initialStep = String.valueOf(step.getId());
        ResultDescriptor unconditionalResult = transition.getUnconditionalResult();
        String finalStep = unconditionalResult.getStep() != -1 ? String.valueOf(unconditionalResult.getStep()) : initialStep;
        List conditionalResults = transition.getConditionalResults();
        if (!conditionalResults.isEmpty()) {
            String choiceStateName = "step" + initialStep + "action" + String.valueOf(transition.getId());
            transitionToUML.append("state " + choiceStateName + " <<choice>> \n");
            String actionContent = this._getTransitionArrow(initialStep, choiceStateName, transitionlabel, elementAbsoluteIconPath, jsFunction, tooltip, true);
            transitionToUML.append(actionContent);
            String unconditionalActionContent = this._getTransitionArrow(choiceStateName, finalStep, null, null, null, null, false);
            transitionToUML.append(unconditionalActionContent);
            for (ConditionalResultDescriptor result : conditionalResults) {
                String conditionalStep = result.getStep() != -1 ? String.valueOf(result.getStep()) : initialStep;
                if (conditionalStep.equals(finalStep)) continue;
                String conditionalActionContent = this._getTransitionArrow(choiceStateName, conditionalStep, null, null, null, null, false);
                transitionToUML.append(conditionalActionContent);
            }
        } else {
            String actionContent = this._getTransitionArrow(initialStep, finalStep, transitionlabel, elementAbsoluteIconPath, jsFunction, tooltip, false);
            transitionToUML.append(actionContent);
        }
        return transitionToUML.toString();
    }
}

