/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.support;

import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.commons.lang3.StringUtils;

class WorkflowToSave {
    private boolean _isCloned;
    private WorkflowDescriptor _workflow;
    private Map<I18nizableText, Map<String, String>> _translations;
    private Map<I18nizableText, I18nizableText> _clonedKeys;

    public WorkflowToSave(WorkflowDescriptor workflow, Map<I18nizableText, Map<String, String>> translations) {
        this._workflow = workflow;
        this._translations = translations;
    }

    public WorkflowDescriptor getWorkflow() {
        return this._workflow;
    }

    public void setWorkflow(WorkflowDescriptor workflowDescriptor) {
        this._workflow = workflowDescriptor;
    }

    public Map<I18nizableText, Map<String, String>> getTranslations() {
        return this._translations;
    }

    public void setTranslations(Map<I18nizableText, Map<String, String>> translations) {
        this._translations = translations;
    }

    public void updateTranslations(I18nizableText key, Map<String, String> labels) {
        Map<String, String> cleanedLabels = this._cleanEmptyEntries(labels);
        if (!cleanedLabels.isEmpty()) {
            Map translations = this._translations.computeIfAbsent(key, __ -> new HashMap());
            translations.putAll(cleanedLabels);
        }
    }

    private Map<String, String> _cleanEmptyEntries(Map<String, String> entries) {
        return entries.entrySet().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean isCloned() {
        return this._isCloned;
    }

    public void setCloned(boolean isCloned) {
        this._isCloned = isCloned;
    }

    public Map<I18nizableText, I18nizableText> getClonedKeys() {
        return this._clonedKeys;
    }

    public void setClonedKeys(Map<I18nizableText, I18nizableText> keys) {
        this._clonedKeys = keys;
    }
}

