/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls workflow ribbon buttons 
 * @private
 */
Ext.define('Ametys.plugins.workflow.controllers.WorkflowController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    constructor: function (config)
    {
        this.callParent(arguments);
        Ametys.message.MessageBus.on(Ametys.message.Message.SELECTION_CHANGED, this.updateState, this);
    },
    
    updateState: function ()
    {
        this.refreshing();
        this.disable();
            
        this._getStatus(this.getMatchingTargets());
    },
    
    /**
     * Refresh the controller dependind on the workflow elements targets status
     * @param {Ametys.message.MessageTarget[]} targets The workflow targets
     * @protected
     */
    _getStatus: function (targets)
    {
        var description = this.getInitialConfig("description") || this.getInitialConfig("default-description") || '';
        if (targets.length > 0)
        {       
            // Multiselection is currently not supported
            var matchingTarget = targets[0];
            
            var errorDescription = "";
            
            if (!matchingTarget.getParameters().canWrite)
            {
                errorDescription = "{{i18n PLUGINS_WORKFLOW_CANT_WRITE_DESCRIPTION}}";
            }
            else
            {
                errorDescription = this.getErrorDescription(matchingTarget);
            }
            
            if (errorDescription == '')
            {
                this.enable();
                var additionnalDescription = this.getAdditionnalDescription(matchingTarget);
                if (description != '' && additionnalDescription != '')
                {
                    description += "<br/><br/>";
                }
                description += additionnalDescription
            }
            else
            {
                if (description != '')
                {
                    description += "<br/><br/>";
                }
                description += errorDescription;
                this.disable();
            }
        }
        this.stopRefreshing();
        this.setDescription (description);
    },
    
    /**
     * Get an additional description to display when the button is enabled
     * @param {Ametys.message.MessageTarget} matchingTarget The matching target
     * @return {String} the additional description
     */
    getAdditionnalDescription: function(matchingTarget)
    {
        return "";
    },
    
    /**
     * @protected
     * Get an additional error not handled by default workflow controller
     * @param {Ametys.message.MessageTarget} matchingTarget The matching target
     * @return {String} additional error or empty is there is no error for current selection
     */
    getErrorDescription: function(matchingTarget)
    {
        return "";
    }
});
