/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This factory creates Ametys.message.MessageTarget for a form directory.
 * See #createTargets for more details.
 * @private
 */
Ext.define('Ametys.plugins.workflow.messages.WorkflowMessageTargetFactory', {
    extend: 'Ametys.message.factory.DefaultMessageTargetFactory',
        
    /**
     * Create the targets for a message
     * @param {Object} parameters The parameters needed by the factory to create the message. Can not be null. Handled elements are
     * @param {String[]} parameters.id The workflow's identifiers.
     * @param {Function} callback The callback function called when the targets are created. Parameters are
     * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
     */
    createTargets: function(parameters, callback)
    {
        if (parameters.workflow)
        {
            this._createTargets(parameters.workflow, callback);
        }
        else
        {
            var id = parameters.id;
            Ametys.plugins.workflow.dao.WorkflowsDAO.getWorkflowRootProperties([id], Ext.bind(this._createTargets, this, [callback], 1));
        }
    },

    /**
     * Create the form directories targets
     * @param {Ametys.plugins.workflow.messages.Workflow} workflow The workflow
     * @param {Function} callback The callback function called when the targets are created.
     * @private
     */
    _createTargets: function (workflow, callback)
    {
        var targets = [];
        
        targets.push(Ext.create("Ametys.message.MessageTarget", {
            id: Ametys.message.MessageTarget.WORKFLOW_OBJECT,
            parameters: Ext.merge(workflow.getProperties(), {workflow: workflow})
        }));
            
        callback(targets);
    }
});
