--
--  Copyright 2009 Anyware Services
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
--
-- Custom separator because ; is used internally by oracle _separator_=---
begin  
  execute immediate 'DROP TABLE OS_PROPERTYENTRY PURGE';
  exception when others then null;
end;
---
begin  
  execute immediate 'DROP TABLE OS_CURRENTSTEP_PREV PURGE';
  exception when others then null;
end;
---
begin  
  execute immediate 'DROP TABLE OS_HISTORYSTEP_PREV PURGE';
  exception when others then null;
end;
---
begin  
  execute immediate 'DROP TABLE OS_CURRENTSTEP PURGE';
  exception when others then null;
end;
---
begin  
  execute immediate 'DROP TABLE OS_HISTORYSTEP PURGE';
  exception when others then null;
end;
---
begin  
  execute immediate 'DROP TABLE OS_WFENTRY PURGE';
  exception when others then null;
end;
---
begin  
  execute immediate 'DROP SEQUENCE seq_os_wfentry';
  exception when others then null;
end;
---
begin  
  execute immediate 'DROP SEQUENCE seq_os_currentsteps';
  exception when others then null;
end;
---
-- _separator_=;

create table OS_PROPERTYENTRY
(
	GLOBAL_KEY varchar(255),
	ITEM_KEY varchar(255),
	ITEM_TYPE smallint,
	STRING_VALUE varchar(255),
	DATE_VALUE date,
	DATA_VALUE blob,
	FLOAT_VALUE float,
	NUMBER_VALUE numeric,
	primary key (GLOBAL_KEY, ITEM_KEY)
);

create table OS_WFENTRY
(
    ID number,
    NAME varchar(255),
    STATE integer,
    primary key (ID)
);

create table OS_CURRENTSTEP
(
    ID number,
    ENTRY_ID number,
    STEP_ID integer,
    ACTION_ID integer,
    OWNER varchar(200),
    START_DATE date,
    FINISH_DATE date,
    DUE_DATE date,
    STATUS varchar(40),
    CALLER varchar(200),
    primary key (ID),
    foreign key (ENTRY_ID) references OS_WFENTRY(ID) ON DELETE CASCADE
);

create table OS_HISTORYSTEP
(
    ID number,
    ENTRY_ID number,
    STEP_ID integer,
    ACTION_ID integer,
    OWNER varchar(200),
    START_DATE date,
    FINISH_DATE date,
    DUE_DATE date,
    STATUS varchar(40),
    CALLER varchar(200),
    primary key (ID),
    foreign key (ENTRY_ID) references OS_WFENTRY(ID) ON DELETE CASCADE
);

create table OS_CURRENTSTEP_PREV
(
    ID number,
    PREVIOUS_ID number,
    primary key (ID, PREVIOUS_ID),
    foreign key (ID) references OS_CURRENTSTEP(ID) ON DELETE CASCADE,
    foreign key (PREVIOUS_ID) references OS_HISTORYSTEP(ID) ON DELETE CASCADE
);

create table OS_HISTORYSTEP_PREV
(
    ID number,
    PREVIOUS_ID number,
    primary key (ID, PREVIOUS_ID),
    foreign key (ID) references OS_HISTORYSTEP(ID) ON DELETE CASCADE,
    foreign key (PREVIOUS_ID) references OS_HISTORYSTEP(ID) ON DELETE CASCADE
);

create sequence seq_os_wfentry;
create sequence seq_os_currentsteps;