/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.store;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.memory.MemoryPropertySet;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.Expression;
import com.opensymphony.workflow.query.FieldExpression;
import com.opensymphony.workflow.query.NestedExpression;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.SimpleWorkflowEntry;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workflow.store.AmetysStep;
import org.ametys.plugins.workflow.store.AmetysWorkflowStore;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJackrabbitWorkflowStore
implements AmetysWorkflowStore {
    public static final String __NAMESPACE = "http://ametys.org/plugin/workflow/1.0";
    public static final String __NAMESPACE_PREFIX = "oswf";
    public static final String __NM_PREFIX = "oswf:";
    public static final String __ROOT_NT = "oswf:root";
    static final String __ENTRY_NT = "oswf:entry";
    static final String __STEP_NT = "oswf:step";
    static final String __ROOT_NODE = "oswf:root";
    static final String __ENTRY_NODE_PREFIX = "workflow-";
    static final String __CURRENT_STEP_NODE = "oswf:currentStep";
    static final String __HISTORY_STEP_NODE = "oswf:historyStep";
    static final String __NEXT_ENTRY_ID_PROPERTY = "oswf:nextEntryId";
    static final String __ID_PROPERTY = "oswf:id";
    static final String __WF_NAME_PROPERTY = "oswf:workflowName";
    static final String __STATE_PROPERTY = "oswf:state";
    static final String __NEXT_STEP_ID_PROPERTY = "oswf:nextStepId";
    static final String __STEP_ID_PROPERTY = "oswf:stepId";
    static final String __ACTION_ID_PROPERTY = "oswf:actionId";
    static final String __OWNER_PROPERTY = "oswf:owner";
    static final String __CALLER_PROPERTY = "oswf:caller";
    static final String __START_DATE_PROPERTY = "oswf:startDate";
    static final String __DUE_DATE_PROPERTY = "oswf:dueDate";
    static final String __FINISH_DATE_PROPERTY = "oswf:finishDate";
    static final String __STATUS_PROPERTY = "oswf:status";
    static final String __PREVIOUS_STEPS_PROPERTY = "oswf:previousSteps";
    protected final Logger _log = LoggerFactory.getLogger(this.getClass());
    protected Repository _repository;

    public AbstractJackrabbitWorkflowStore(Repository repository) {
        this._repository = repository;
    }

    protected Session _getSession() throws RepositoryException {
        return this._repository.login();
    }

    protected void _release(Session session) {
        if (session != null) {
            session.logout();
        }
    }

    protected static Calendar __toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public void init(Map props) throws StoreException {
        try {
            this._createRootNode();
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to initialize repository", (Throwable)e);
        }
    }

    protected abstract void _createRootNode() throws RepositoryException;

    protected abstract Node _getRootNode(Session var1) throws RepositoryException;

    public void setEntryState(long entryId, int state) throws StoreException {
        Session session = null;
        try {
            session = this._getSession();
            Node entry = this.getEntryNode(session, entryId);
            entry.setProperty(__STATE_PROPERTY, (long)state);
            session.save();
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to change entry state for entryId: " + entryId, (Throwable)e);
        }
        finally {
            this._release(session);
        }
    }

    public PropertySet getPropertySet(long entryId) throws StoreException {
        MemoryPropertySet ps = new MemoryPropertySet();
        ps.init(null, null);
        return ps;
    }

    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        Session session = null;
        try {
            session = this._getSession();
            Node entry = this.getEntryNode(session, entryId);
            long id = this._getNextStepId(entry);
            int actionId = 0;
            Node stepNode = entry.addNode(__CURRENT_STEP_NODE, __STEP_NT);
            stepNode.setProperty(__ID_PROPERTY, id);
            AmetysStep step = new AmetysStep(stepNode, this);
            step.setStepId(stepId);
            step.setActionId(actionId);
            step.setOwner(owner);
            step.setStartDate(startDate);
            if (dueDate != null) {
                step.setDueDate(dueDate);
            }
            step.setStatus(status);
            step.setPreviousStepIds(previousIds);
            step.save();
            return step;
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to store new entry", (Throwable)e);
        }
    }

    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        long id;
        int state = 0;
        try {
            id = this._getNextEntryId();
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to store new entry", (Throwable)e);
        }
        SimpleWorkflowEntry workflowEntry = new SimpleWorkflowEntry(id, workflowName, state);
        this.storeNewEntry((WorkflowEntry)workflowEntry);
        return workflowEntry;
    }

    protected void storeNewEntry(WorkflowEntry workflowEntry) throws StoreException {
        Session session = null;
        String workflowName = workflowEntry.getWorkflowName();
        long id = workflowEntry.getId();
        int state = workflowEntry.getState();
        try {
            session = this._getSession();
            Node root = this._getRootNode(session);
            Node parentNode = this._getOrCreateParentEntryNode(root, id);
            Node entryNode = parentNode.addNode(__ENTRY_NODE_PREFIX + id, __ENTRY_NT);
            if (this._log.isDebugEnabled()) {
                try {
                    this._log.debug("Storing entry into path: " + entryNode.getPath());
                }
                catch (RepositoryException e) {
                    this._log.warn("Unable to retrieve entry node path", (Throwable)e);
                }
            }
            entryNode.setProperty(__ID_PROPERTY, id);
            entryNode.setProperty(__WF_NAME_PROPERTY, workflowName);
            entryNode.setProperty(__STATE_PROPERTY, (long)state);
            session.save();
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to store new entry", (Throwable)e);
        }
        finally {
            this._release(session);
        }
    }

    public void removeEntry(long entryId) throws StoreException {
        Session session = null;
        try {
            session = this._getSession();
            Node entryNode = this.getEntryNode(session, entryId);
            entryNode.remove();
            session.save();
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to delete workflow entry " + entryId, (Throwable)e);
        }
        finally {
            this._release(session);
        }
    }

    protected abstract Node _getOrCreateParentEntryNode(Node var1, long var2) throws RepositoryException;

    public Node getEntryNode(Session session, long entryId) throws RepositoryException {
        Node rootNode = this._getRootNode(session);
        Node parentNode = this._getOrCreateParentEntryNode(rootNode, entryId);
        return parentNode.getNode(__ENTRY_NODE_PREFIX + entryId);
    }

    Node getHistoryStepNode(Session session, long entryId, long stepId) throws RepositoryException {
        Node entryNode = this.getEntryNode(session, entryId);
        NodeIterator itNode = entryNode.getNodes(__HISTORY_STEP_NODE);
        while (itNode.hasNext()) {
            Node stepNode = itNode.nextNode();
            if (JcrUtils.getLongProperty((Node)stepNode, (String)__ID_PROPERTY, (long)-1L) != stepId) continue;
            return stepNode;
        }
        throw new RepositoryException("Unknown entry node for entryId: " + entryId + " and stepId: " + stepId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long _getNextEntryId() throws RepositoryException {
        Session session = null;
        try {
            session = this._getSession();
            Node root = this._getRootNode(session);
            long nextEntryId = root.getProperty(__NEXT_ENTRY_ID_PROPERTY).getLong();
            root.setProperty(__NEXT_ENTRY_ID_PROPERTY, nextEntryId + 1L);
            session.save();
            long l = nextEntryId;
            return l;
        }
        finally {
            this._release(session);
        }
    }

    protected synchronized long _getNextStepId(Node entry) throws RepositoryException {
        long nextStepId = entry.getProperty(__NEXT_STEP_ID_PROPERTY).getLong();
        entry.setProperty(__NEXT_STEP_ID_PROPERTY, nextStepId + 1L);
        entry.getSession().save();
        return nextStepId;
    }

    public List findCurrentSteps(long entryId) throws StoreException {
        ArrayList<AmetysStep> currentSteps = new ArrayList<AmetysStep>();
        Session session = null;
        try {
            session = this._getSession();
            Node entry = this.getEntryNode(session, entryId);
            NodeIterator nodeIterator = entry.getNodes(__CURRENT_STEP_NODE);
            while (nodeIterator.hasNext()) {
                currentSteps.add(new AmetysStep(nodeIterator.nextNode(), this));
            }
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to change entry state for entryId: " + entryId, (Throwable)e);
        }
        return currentSteps;
    }

    public WorkflowEntry findEntry(long entryId) throws StoreException {
        Session session = null;
        try {
            session = this._getSession();
            Node entry = this.getEntryNode(session, entryId);
            String workflowName = entry.getProperty(__WF_NAME_PROPERTY).getString();
            int state = (int)entry.getProperty(__STATE_PROPERTY).getLong();
            SimpleWorkflowEntry simpleWorkflowEntry = new SimpleWorkflowEntry(entryId, workflowName, state);
            return simpleWorkflowEntry;
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to change entry state for entryId: " + entryId, (Throwable)e);
        }
        finally {
            this._release(session);
        }
    }

    public List findHistorySteps(long entryId) throws StoreException {
        ArrayList<AmetysStep> historySteps = new ArrayList<AmetysStep>();
        Session session = null;
        try {
            session = this._getSession();
            Node entry = this.getEntryNode(session, entryId);
            NodeIterator nodeIterator = entry.getNodes(__HISTORY_STEP_NODE);
            while (nodeIterator.hasNext()) {
                historySteps.add(new AmetysStep(nodeIterator.nextNode(), this));
            }
            Collections.sort(historySteps, new Comparator<Step>(this){

                @Override
                public int compare(Step step1, Step step2) {
                    return -Long.valueOf(step1.getId()).compareTo(step2.getId());
                }
            });
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to change entry state for entryId: " + entryId, (Throwable)e);
        }
        return historySteps;
    }

    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        try {
            AmetysStep theStep = (AmetysStep)step;
            theStep.setActionId(actionId);
            theStep.setFinishDate(finishDate);
            theStep.setStatus(status);
            theStep.setCaller(caller);
            theStep.save();
            return theStep;
        }
        catch (AmetysRepositoryException e) {
            throw new StoreException("Unable to modify step for entryId: " + step.getEntryId() + " and stepId: " + step.getStepId(), (Throwable)e);
        }
    }

    public void moveToHistory(Step step) throws StoreException {
        try {
            Node stepNode = ((AmetysStep)step).getNode();
            Node entry = stepNode.getParent();
            String currentStepPath = stepNode.getPath();
            String historyStepPath = entry.getPath() + "/oswf:historyStep";
            stepNode.getSession().move(currentStepPath, historyStepPath);
            stepNode.getSession().save();
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to move step to history for entryId: " + step.getEntryId() + " and stepId: " + step.getStepId(), (Throwable)e);
        }
    }

    public List query(WorkflowQuery query) throws StoreException {
        ArrayList<Long> results = new ArrayList<Long>();
        Session session = null;
        try {
            session = this._getSession();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            StringBuilder xPathQuery = new StringBuilder("//element(*, ");
            xPathQuery.append(__ENTRY_NT);
            xPathQuery.append(")");
            xPathQuery.append("[");
            xPathQuery.append(this.getCondition(query));
            xPathQuery.append("]");
            if (this._log.isInfoEnabled()) {
                this._log.info("Executing xpath: " + String.valueOf(xPathQuery));
            }
            Query jcrQuery = queryManager.createQuery(xPathQuery.toString(), "xpath");
            QueryResult result = jcrQuery.execute();
            NodeIterator nodeIterator = result.getNodes();
            while (nodeIterator.hasNext()) {
                Node entry = nodeIterator.nextNode();
                results.add(entry.getProperty(__ID_PROPERTY).getLong());
            }
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to query entries", (Throwable)e);
        }
        finally {
            this._release(session);
        }
        return results;
    }

    @Override
    public void clearHistory(long entryId) throws StoreException {
        Session session = null;
        try {
            session = this._getSession();
            Node entryNode = this.getEntryNode(session, entryId);
            NodeIterator itNode = entryNode.getNodes(__HISTORY_STEP_NODE);
            while (itNode.hasNext()) {
                Node historyStepNode = itNode.nextNode();
                String historyStepNodeIdentifier = historyStepNode.getIdentifier();
                PropertyIterator itProperty = historyStepNode.getReferences();
                while (itProperty.hasNext()) {
                    Property property = itProperty.nextProperty();
                    Node parentNode = property.getParent();
                    String nodeTypeName = parentNode.getPrimaryNodeType().getName();
                    if (nodeTypeName.equals(__STEP_NT)) {
                        Value[] values;
                        ValueFactory valueFactory = session.getValueFactory();
                        ArrayList<Value> newValues = new ArrayList<Value>();
                        for (Value value : values = property.getValues()) {
                            String identifier = value.getString();
                            if (identifier.equals(historyStepNodeIdentifier)) continue;
                            newValues.add(valueFactory.createValue(identifier));
                        }
                        property.setValue(newValues.toArray(new Value[newValues.size()]));
                        continue;
                    }
                    throw new RepositoryException("An history node is references by a unknown node of type: " + nodeTypeName);
                }
                historyStepNode.remove();
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to clear entry history for entry id: " + entryId, (Throwable)e);
        }
        finally {
            this._release(session);
        }
    }

    @Override
    public void deleteInstance(long entryId) throws StoreException {
        Session session = null;
        try {
            session = this._getSession();
            Node entryNode = this.getEntryNode(session, entryId);
            entryNode.remove();
            session.save();
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to delete instance for entry id: " + entryId, (Throwable)e);
        }
        finally {
            this._release(session);
        }
    }

    protected String getCondition(WorkflowQuery query) throws StoreException {
        if (query.getLeft() == null) {
            return this.buildFieldExpression(query);
        }
        int operator = query.getOperator();
        WorkflowQuery left = query.getLeft();
        WorkflowQuery right = query.getRight();
        switch (operator) {
            case 6: {
                return "(" + this.getCondition(left) + ") and (" + this.getCondition(right) + ")";
            }
            case 7: {
                return "(" + this.getCondition(left) + ") or (" + this.getCondition(right) + ")";
            }
        }
        throw new IllegalArgumentException("Not supported operator: " + operator);
    }

    protected String buildFieldExpression(WorkflowQuery query) throws StoreException {
        StringBuilder condition = new StringBuilder();
        int qtype = query.getType();
        if (qtype == 0 && query.getLeft() != null) {
            qtype = query.getLeft().getType();
        }
        if (qtype == 2) {
            condition.append("oswf:currentStep/");
        } else {
            condition.append("oswf:historyStep/");
        }
        Object value = query.getValue();
        int operator = query.getOperator();
        int field = query.getField();
        String oper = switch (operator) {
            case 1 -> " = ";
            case 5 -> " != ";
            case 3 -> " > ";
            case 2 -> " < ";
            default -> " = ";
        };
        Object left = this.getPropertyName(field);
        String right = "";
        if (value == null) {
            if (operator == 1) {
                oper = "";
            } else if (operator == 5) {
                left = "not(" + (String)left + ")";
                oper = "";
            } else {
                right = "null";
            }
        } else {
            right = this.translateValue(value);
        }
        condition.append((String)left);
        condition.append(oper);
        condition.append(right);
        return condition.toString();
    }

    public List query(WorkflowExpressionQuery query) throws StoreException {
        ArrayList<Long> results = new ArrayList<Long>();
        Session session = null;
        try {
            session = this._getSession();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            StringBuilder xPathQuery = new StringBuilder("//element(*, ");
            xPathQuery.append(__ENTRY_NT);
            xPathQuery.append(")");
            xPathQuery.append(this.getPredicate(query));
            xPathQuery.append(this.getSortCriteria(query));
            if (this._log.isInfoEnabled()) {
                this._log.info("Executing xpath: " + String.valueOf(xPathQuery));
            }
            Query jcrQuery = queryManager.createQuery(xPathQuery.toString(), "xpath");
            QueryResult result = jcrQuery.execute();
            NodeIterator nodeIterator = result.getNodes();
            while (nodeIterator.hasNext()) {
                Node entry = nodeIterator.nextNode();
                results.add(entry.getProperty(__ID_PROPERTY).getLong());
            }
        }
        catch (RepositoryException e) {
            throw new StoreException("Unable to query entries", (Throwable)e);
        }
        finally {
            this._release(session);
        }
        return results;
    }

    protected String getSortCriteria(WorkflowExpressionQuery query) throws StoreException {
        StringBuilder criteria = new StringBuilder();
        if (query.getSortOrder() != 0) {
            criteria.append(" order by ");
            FieldExpression fieldExpr = this.getFirstFieldExpression(query.getExpression());
            if (fieldExpr == null) {
                return "";
            }
            if (fieldExpr.getContext() == 2) {
                criteria.append("oswf:currentStep/");
            } else if (fieldExpr.getContext() == 1) {
                criteria.append("oswf:historyStep/");
            }
            criteria.append(this.getPropertyName(query.getOrderBy()));
            if (query.getSortOrder() == -1) {
                criteria.append(" descending");
            } else {
                criteria.append(" ascending");
            }
        }
        return criteria.toString();
    }

    protected FieldExpression getFirstFieldExpression(Expression expression) {
        if (expression.isNested()) {
            NestedExpression nestedExpr = (NestedExpression)expression;
            for (int i = 0; i < nestedExpr.getExpressionCount(); ++i) {
                FieldExpression fieldExpr = this.getFirstFieldExpression(nestedExpr.getExpression(i));
                if (fieldExpr == null) continue;
                return fieldExpr;
            }
        } else {
            return (FieldExpression)expression;
        }
        return null;
    }

    protected String getPredicate(WorkflowExpressionQuery query) throws StoreException {
        Expression expression = query.getExpression();
        String predicate = expression.isNested() ? this.buildNestedExpression((NestedExpression)expression) : this.buildFieldExpression((FieldExpression)expression);
        return "[" + predicate + "]";
    }

    protected String buildNestedExpression(NestedExpression nestedExpr) throws StoreException {
        StringBuilder query = new StringBuilder();
        int exprCount = nestedExpr.getExpressionCount();
        block3: for (int i = 0; i < exprCount; ++i) {
            Expression subExpression = nestedExpr.getExpression(i);
            query.append("(");
            if (subExpression instanceof NestedExpression) {
                query.append(this.buildNestedExpression((NestedExpression)subExpression));
            } else if (subExpression instanceof FieldExpression) {
                query.append(this.buildFieldExpression((FieldExpression)subExpression));
            }
            query.append(")");
            if (i == exprCount - 1) continue;
            switch (nestedExpr.getExpressionOperator()) {
                case 7: {
                    query.append(" or ");
                    continue block3;
                }
                default: {
                    query.append(" and ");
                }
            }
        }
        return query.toString();
    }

    private String buildFieldExpression(FieldExpression expr) throws StoreException {
        StringBuilder query = new StringBuilder();
        if (expr.getContext() == 2) {
            query.append("oswf:currentStep/");
        } else if (expr.getContext() == 1) {
            query.append("oswf:historyStep/");
        }
        Object value = expr.getValue();
        int operator = expr.getOperator();
        int field = expr.getField();
        String oper = switch (operator) {
            case 1 -> " = ";
            case 5 -> " != ";
            case 3 -> " > ";
            case 2 -> " < ";
            default -> " = ";
        };
        Object left = this.getPropertyName(field);
        String right = "";
        if (value == null) {
            if (operator == 1) {
                oper = "";
            } else if (operator == 5) {
                left = "not(" + (String)left + ")";
                oper = "";
            } else {
                right = "null";
            }
        } else {
            right = this.translateValue(value);
        }
        if (expr.isNegate()) {
            query.append("not(");
        }
        query.append((String)left);
        query.append(oper);
        query.append(right);
        if (expr.isNegate()) {
            query.append(")");
        }
        return query.toString();
    }

    protected String translateValue(Object value) throws StoreException {
        if (value instanceof Date) {
            Date date = (Date)value;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            return " xs:dateTime('" + ISO8601.format((Calendar)calendar) + "')";
        }
        if (value instanceof Integer || value instanceof Long) {
            return value.toString();
        }
        return "'" + value.toString().replaceAll("'", "''") + "'";
    }

    protected String getPropertyName(int field) throws StoreException {
        switch (field) {
            case 4: {
                return "@oswf:actionId";
            }
            case 6: {
                return "@oswf:caller";
            }
            case 3: {
                return "@oswf:finishDate";
            }
            case 1: {
                return "@oswf:owner";
            }
            case 2: {
                return "@oswf:startDate";
            }
            case 5: {
                return "@oswf:stepId";
            }
            case 7: {
                return "@oswf:status";
            }
            case 9: {
                return "@oswf:state";
            }
            case 8: {
                return "@oswf:workflowName";
            }
            case 10: {
                return "@oswf:dueDate";
            }
        }
        throw new StoreException("Invalid field: " + field);
    }
}

