/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.support;

import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.Register;
import com.opensymphony.workflow.TypeResolver;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.WorkflowException;
import java.util.Map;
import org.ametys.plugins.workflow.EnhancedConditionExtensionPoint;
import org.ametys.plugins.workflow.EnhancedFunctionExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class AvalonTypeResolver
extends TypeResolver {
    private static final String __AVALON_TYPE = "avalon";
    private static final String __ROLE = "role";
    private static final String __ID = "id";
    private ServiceManager _serviceManager;
    private EnhancedFunctionExtensionPoint _enhancedFunctionExtensionPoint;
    private EnhancedConditionExtensionPoint _enhancedConditionExtensionPoint;

    public AvalonTypeResolver(ServiceManager serviceManager) {
        this._serviceManager = serviceManager;
        try {
            this._enhancedFunctionExtensionPoint = (EnhancedFunctionExtensionPoint)((Object)serviceManager.lookup(EnhancedFunctionExtensionPoint.ROLE));
            this._enhancedConditionExtensionPoint = (EnhancedConditionExtensionPoint)((Object)serviceManager.lookup(EnhancedConditionExtensionPoint.ROLE));
        }
        catch (ServiceException e) {
            throw new RuntimeException("Unable to lookup EnhancedFunctionExtensionPoint", e);
        }
    }

    public Condition getCondition(String type, Map args) throws WorkflowException {
        if (__AVALON_TYPE.equals(type)) {
            return (Condition)this._getConditionExtension((String)args.get(__ID));
        }
        return super.getCondition(type, args);
    }

    public FunctionProvider getFunction(String type, Map args) throws WorkflowException {
        if (__AVALON_TYPE.equals(type)) {
            return (FunctionProvider)this._getFunctionExtension((String)args.get(__ID));
        }
        return super.getFunction(type, args);
    }

    public Register getRegister(String type, Map args) throws WorkflowException {
        if (__AVALON_TYPE.equals(type)) {
            return (Register)this._getComponent((String)args.get(__ROLE));
        }
        return super.getRegister(type, args);
    }

    public Validator getValidator(String type, Map args) throws WorkflowException {
        if (__AVALON_TYPE.equals(type)) {
            return (Validator)this._getComponent((String)args.get(__ROLE));
        }
        return super.getValidator(type, args);
    }

    private Object _getComponent(String role) throws WorkflowException {
        if (role == null) {
            throw new WorkflowException("Missing 'role' argument for avalon type");
        }
        try {
            return this._serviceManager.lookup(role);
        }
        catch (ServiceException e) {
            throw new WorkflowException("Unable to retrieve avalon component for role: '" + role + "'", (Throwable)e);
        }
    }

    private Object _getFunctionExtension(String id) throws WorkflowException {
        if (id == null) {
            throw new WorkflowException("Missing 'id' argument for avalon type");
        }
        return this._enhancedFunctionExtensionPoint.getExtension(id);
    }

    private Object _getConditionExtension(String id) throws WorkflowException {
        if (id == null) {
            throw new WorkflowException("Missing 'id' argument for avalon type");
        }
        return this._enhancedConditionExtensionPoint.getExtension(id);
    }
}

