/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

 /**
  * Helper to select zone into a workflow graph.
  * @private
  */
 Ext.define('Ametys.plugins.workflow.UI.UIWorkflowGraph', {
    singleton: true,

    /**
     * Send bus message with the element selected in the diagram as target
     * @param workflowName unique name of the workflow
     * @param stepId id of the step 
     * @param stepLabel label of the step 
     * @param actionId id of the action can be null if selection is a step
     * @param hasChanges true if workflow has unsaved changes
     */
    sendSelection: function(workflowName, stepId, stepLabel, actionId, actionLabel)
    {
        var workflowTarget = {
            id: Ametys.message.MessageTarget.WORKFLOW_OBJECT,
            parameters: { 
                id: workflowName
            }
        }
        
        var stepTarget = {
            id: Ametys.message.MessageTarget.WORKFLOW_STEP,
            parameters: { 
                id: stepId,
                label: stepLabel,
                workflowId: workflowName
            }
        };
        workflowTarget.subtargets = stepTarget;
            
        if (actionId != '')
        {
            var actionTarget = {
                id: Ametys.message.MessageTarget.WORKFLOW_ACTION,
                parameters: {
                    id: actionId,
                    label: actionLabel,
                    stepId: stepId,
                    workflowId: workflowName
                }
            }
            stepTarget.subtargets = actionTarget;
        }
            
        Ext.create('Ametys.message.Message', {
            type: Ametys.message.Message.SELECTION_CHANGED,
            targets: workflowTarget
        });
    }
 });
