/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 

/**
 * This class controls the ribbon button to move the function down inside workflow element's list of pre/post functions
 */
Ext.define('Ametys.plugins.workflow.controllers.MoveDownFunctionController', {
    extend: 'Ametys.plugins.workflow.controllers.WorkflowController',
    
    getErrorDescription: function(matchingTarget)
    {
        var functionTarget = matchingTarget.getSubtarget(function(target){return target.getId() == Ametys.message.MessageTarget.WORKFLOW_FUNCTION});
        if (functionTarget)
        {
            var isLast = functionTarget.getParameters().isLast;
            return isLast ? this.getConfig("cannot-move-down-description") : "";
        }
        else
        {
            return this.getConfig("selection-description-nomatch");
        }
    }
});
