--
--  Copyright 2009 Anyware Services
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
--

--_ignore_exceptions_=on
DROP TABLE OS_PROPERTYENTRY;
DROP TABLE OS_CURRENTSTEP_PREV;
DROP TABLE OS_HISTORYSTEP_PREV;
DROP TABLE OS_CURRENTSTEP;
DROP TABLE OS_HISTORYSTEP;
DROP TABLE OS_WFENTRY;
DROP TABLE OS_STEPIDS;
DROP TABLE OS_ENTRYIDS;
--_ignore_exceptions_=off

CREATE TABLE OS_PROPERTYENTRY
(
    GLOBAL_KEY VARCHAR(250) NOT NULL,
    ITEM_KEY VARCHAR(250) NOT NULL,
    ITEM_TYPE SMALLINT,
    STRING_VALUE VARCHAR(255),
    DATE_VALUE TIMESTAMP,
    DATA_VALUE VARCHAR (32672) FOR BIT DATA,
    FLOAT_VALUE FLOAT,
    NUMBER_VALUE NUMERIC,
    PRIMARY KEY (GLOBAL_KEY, ITEM_KEY)
);

CREATE TABLE OS_WFENTRY
(
    ID BIGINT NOT NULL,
    NAME VARCHAR(255),
    STATE INTEGER,
    PRIMARY KEY (ID)
);

CREATE TABLE OS_CURRENTSTEP
(
    ID BIGINT NOT NULL,
    ENTRY_ID BIGINT,
    STEP_ID INTEGER,
    ACTION_ID INTEGER,
    OWNER VARCHAR(200),
    START_DATE TIMESTAMP,
    FINISH_DATE TIMESTAMP,
    DUE_DATE TIMESTAMP,
    STATUS VARCHAR(40),
    CALLER VARCHAR(200),

    PRIMARY KEY (ID),
    FOREIGN KEY (ENTRY_ID) REFERENCES OS_WFENTRY(ID) ON DELETE CASCADE
);

CREATE TABLE OS_HISTORYSTEP
(
    ID BIGINT NOT NULL,
    ENTRY_ID BIGINT,
    STEP_ID INTEGER,
    ACTION_ID INTEGER,
    OWNER VARCHAR(200),
    START_DATE TIMESTAMP,
    FINISH_DATE TIMESTAMP,
    DUE_DATE TIMESTAMP,
    STATUS VARCHAR(40),
    CALLER VARCHAR(200),

    PRIMARY KEY (ID),
    FOREIGN KEY (ENTRY_ID) REFERENCES OS_WFENTRY(ID) ON DELETE CASCADE
);

CREATE TABLE OS_CURRENTSTEP_PREV
(
    ID BIGINT NOT NULL,
    PREVIOUS_ID BIGINT NOT NULL,
    PRIMARY KEY (ID, PREVIOUS_ID),
    FOREIGN KEY (ID) REFERENCES OS_CURRENTSTEP(ID) ON DELETE CASCADE,
    FOREIGN KEY (PREVIOUS_ID) REFERENCES OS_HISTORYSTEP(ID) ON DELETE CASCADE
);

CREATE TABLE OS_HISTORYSTEP_PREV
(
    ID BIGINT NOT NULL,
    PREVIOUS_ID BIGINT NOT NULL,
    PRIMARY KEY (ID, PREVIOUS_ID),
    FOREIGN KEY (ID) REFERENCES OS_HISTORYSTEP(ID) ON DELETE CASCADE,
    FOREIGN KEY (PREVIOUS_ID) REFERENCES OS_HISTORYSTEP(ID) ON DELETE CASCADE
);

CREATE TABLE OS_STEPIDS
(
	ID BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
	PRIMARY KEY (ID)
);

CREATE TABLE OS_ENTRYIDS
(
	ID BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
	PRIMARY KEY (ID)
);
