/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workflow;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.plugins.workflow.definition.WorkflowDefinition;
import org.ametys.plugins.workflow.definition.WorkflowDefinitionExtensionPoint;

import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.AbstractWorkflowFactory;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowFactory;

/**
 * The {@link WorkflowFactory} implementation for Ametys.
 * Check the {@link WorkflowDefinitionExtensionPoint} and add the workflows from WEB-INF/param/workflows.
 */
public class AmetysWorkflowFactory extends AbstractWorkflowFactory implements Component, Serviceable
{
    /** Avalon role. */
    public static final String ROLE = AmetysWorkflowFactory.class.getName();
    
    /** The workflow definition extension point */
    protected WorkflowDefinitionExtensionPoint _workflowDefEP;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _workflowDefEP = (WorkflowDefinitionExtensionPoint) manager.lookup(WorkflowDefinitionExtensionPoint.ROLE);
    }
    
    @Override
    public void initDone() throws FactoryException
    {
        // Nothing to do
    }
    
    public void setLayout(String workflowName, Object layout)
    {
        // Nothing to do
    }

    public Object getLayout(String workflowName)
    {
        return null;
    }

    public boolean isModifiable(String name)
    {
        return true;
    }

    public String getName()
    {
        return null;
    }

    public WorkflowDescriptor getWorkflow(String name, boolean validate) throws FactoryException
    {
        WorkflowDefinition definition = getWorkflowDefinition(name);
        try
        {
            return definition.getDescriptor(validate); 
        }
        catch (Exception e)
        {
            throw new FactoryException("Error in workflow descriptor: " + definition.getLocation(), e);
        }
    }

    public String[] getWorkflowNames() throws FactoryException
    {
        return _workflowDefEP.getExtensionsIds().toArray(String[]::new);
    }

    public void createWorkflow(String name)
    {
        // Nothing to do
    }

    public boolean removeWorkflow(String name) throws FactoryException
    {
        throw new FactoryException("remove workflow not supported");
    }

    public void renameWorkflow(String oldName, String newName)
    {
        // Nothing to do
    }

    public void save()
    {
        // Nothing to do
    }

    public boolean saveWorkflow(String name, WorkflowDescriptor descriptor, boolean replace) throws FactoryException
    {
        throw new FactoryException("save workflow not supported");
    }
    
    /**
     * Get the workflow definition by its name
     * @param name the name
     * @return the workflow definition
     * @throws FactoryException if an error occurs
     */
    public WorkflowDefinition getWorkflowDefinition(String name) throws FactoryException
    {
        if (!_workflowDefEP.hasExtension(name))
        {
            throw new FactoryException("Unknown workflow name \"" + name + '\"');
        }
        
        return _workflowDefEP.getExtension(name);
    }
}
