/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.workflow;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang3.tuple.Pair;

import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.ametys.runtime.plugin.component.LazyInitializeExtensions;

/**
 * The enhanced function extension point
 */
@LazyInitializeExtensions
public class EnhancedFunctionExtensionPoint extends AbstractThreadSafeComponentExtensionPoint<EnhancedFunction>
{
    /** The enhanced function extension point role */
    public static final String ROLE = EnhancedFunctionExtensionPoint.class.getName();
    
    /**
     * Get all sources types
     * @return a list of {@link EnhancedFunction}
     */
    public  Set<Pair<String, EnhancedFunction>> getAllFunctions()
    {
        Set<Pair<String, EnhancedFunction>> functions = new HashSet<>();
        for (String id: getExtensionsIds())
        {
            functions.add(Pair.of(id, getExtension(id)));
        }
        return functions;
    }
    
}
