/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.component;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.Step;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.EnhancedCondition;
import org.ametys.plugins.workflow.component.WorkflowArgument;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowElementDefinitionHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class AmetysObjectCurrentStepCondition
extends AbstractWorkflowComponent
implements EnhancedCondition {
    private WorkflowProvider _workflowProvider;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
    }

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        int step = Integer.parseInt((String)args.get("step"));
        WorkflowAwareAmetysObject ametysObject = (WorkflowAwareAmetysObject)transientVars.get(this._getAmetysObjectKey(args));
        if (ametysObject == null) {
            throw new WorkflowException("Unable to retrieve the object");
        }
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow(ametysObject, true);
        long workflowId = ametysObject.getWorkflowId();
        List currentSteps = workflow.getCurrentSteps(workflowId);
        for (Step currentStep : currentSteps) {
            if (currentStep.getStepId() != step) continue;
            return true;
        }
        return false;
    }

    protected Object _getAmetysObjectKey(Map args) {
        return args.get("object-key");
    }

    @Override
    public List<WorkflowArgument> getArguments() {
        return List.of(WorkflowElementDefinitionHelper.getElementDefinition("step", new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_AMETYS_OBJECT_CURRENT_STEP_CONDITION_ARGUMENT_STEP_LABEL"), new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_AMETYS_OBJECT_CURRENT_STEP_CONDITION_ARGUMENT_STEP_DESCRIPTION"), true, false), WorkflowElementDefinitionHelper.getElementDefinition("object-key", new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_AMETYS_OBJECT_CURRENT_STEP_CONDITION_ARGUMENT_OBJECT_KEY_LABEL"), new I18nizableText("plugin.workflow", "PLUGINS_WORKFLOW_EDITOR_AMETYS_OBJECT_CURRENT_STEP_CONDITION_ARGUMENT_OBJECT_KEY_DESCRIPTION"), true, false));
    }

    @Override
    public I18nizableText getLabel() {
        return new I18nizableText("plugin.workflow", "UITOOL_WORKFLOW_EDITOR_AMETYS_OBJECT_CURRENT_STEP_CONDITION_LABEL");
    }

    @Override
    public I18nizableText getFullLabel(Map<String, String> argumentsValues) {
        String stepId = argumentsValues.get("step");
        return new I18nizableText("plugin.workflow", "UITOOL_WORKFLOW_EDITOR_AMETYS_OBJECT_CURRENT_STEP_CONDITION_DESCRIPTION", List.of(stepId));
    }
}

