/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.definition;

import java.io.File;
import org.ametys.plugins.workflow.definition.AutomaticWorkflowDefinition;
import org.ametys.plugins.workflow.definition.WorkflowDefinition;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class WorkflowDefinitionExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<WorkflowDefinition> {
    public static final String ROLE = WorkflowDefinitionExtensionPoint.class.getName();
    protected WorkflowHelper _workflowHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._workflowHelper = (WorkflowHelper)((Object)manager.lookup(WorkflowHelper.ROLE));
    }

    public void initializeExtensions() throws Exception {
        File[] workflowFiles = this._workflowHelper.getParamWorkflowDir().listFiles((file, name) -> name.endsWith(".xml"));
        if (workflowFiles != null) {
            for (File workflowFile : workflowFiles) {
                String workflowId = this._getWorkflowIdFromFilename(workflowFile.getName());
                if (this.hasExtension(workflowId)) continue;
                this._addNewExtension(workflowId);
            }
        }
    }

    private void _addNewExtension(String workflowId) throws ConfigurationException {
        DefaultConfiguration extensionConf = new DefaultConfiguration("extension");
        extensionConf.setAttribute("class", AutomaticWorkflowDefinition.class.getName());
        this.addExtension(workflowId, "_default", "_default", (Configuration)extensionConf);
    }

    public void addOrUpdateExtension(String workflowId) throws ConfigurationException {
        if (!this.hasExtension(workflowId)) {
            this._addNewExtension(workflowId);
        } else {
            ((WorkflowDefinition)((Object)this.getExtension(workflowId))).reset();
        }
    }

    protected String _getWorkflowIdFromFilename(String filename) {
        return filename.substring(0, filename.lastIndexOf(46));
    }
}

