/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.readers;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.workflow.dao.WorkflowStepDAO;
import org.ametys.plugins.workflow.dao.WorkflowTransitionDAO;
import org.ametys.plugins.workflow.support.I18nHelper;
import org.ametys.plugins.workflow.support.WorflowRightHelper;
import org.ametys.plugins.workflow.support.WorkflowSessionHelper;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public abstract class AbstractPlantUMLSVGReader
extends AbstractReader
implements Serviceable {
    protected static final String __MAIN_STEP_NODE_COLOR = "#e5f8ff";
    protected I18nUtils _i18nUtils;
    protected I18nHelper _i18nHelper;
    protected WorkflowSessionHelper _workflowSessionHelper;
    protected WorkflowStepDAO _workflowStepDAO;
    protected WorkflowTransitionDAO _workflowTransitionDAO;
    protected WorflowRightHelper _workflowRightHelper;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._i18nHelper = (I18nHelper)((Object)serviceManager.lookup(I18nHelper.ROLE));
        this._workflowStepDAO = (WorkflowStepDAO)((Object)serviceManager.lookup(WorkflowStepDAO.ROLE));
        this._workflowTransitionDAO = (WorkflowTransitionDAO)serviceManager.lookup(WorkflowTransitionDAO.ROLE);
        this._workflowSessionHelper = (WorkflowSessionHelper)((Object)serviceManager.lookup(WorkflowSessionHelper.ROLE));
        this._workflowRightHelper = (WorflowRightHelper)serviceManager.lookup(WorflowRightHelper.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
    }

    public String getMimeType() {
        return "image/svg+xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        block8: {
            try {
                Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
                String workflowName = (String)request.get("workflowName");
                this._setContextInRequestAttributes(request);
                WorkflowDescriptor workflowDescriptor = this._workflowSessionHelper.getWorkflowDescriptor(workflowName, false);
                if (!this._workflowRightHelper.canRead(workflowDescriptor)) break block8;
                this._setPlantUMLProperties();
                String content = this._getPlantUMLContent(request, workflowDescriptor);
                SourceStringReader reader = new SourceStringReader(content);
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    reader.outputImage((OutputStream)byteArrayOutputStream, new FileFormatOption(FileFormat.SVG).withSvgLinkTarget("_self"));
                    String svgContent = byteArrayOutputStream.toString(StandardCharsets.UTF_8);
                    svgContent = svgContent.replaceAll("<svg ", "<svg onclick=\"parent.Ametys.tool.ToolsManager.getTool('uitool-workflow-preview').focus();\" ");
                    IOUtils.write((String)svgContent, (OutputStream)this.out, (Charset)StandardCharsets.UTF_8);
                }
            }
            finally {
                this.out.close();
            }
        }
    }

    protected void _setContextInRequestAttributes(Request request) {
        Map contextAsMap = this._jsonUtils.convertJsonToMap(request.getParameter("context.parameters"));
        if (contextAsMap != null) {
            for (String name : contextAsMap.keySet()) {
                request.setAttribute(name, contextAsMap.get(name));
            }
        }
    }

    protected void _setPlantUMLProperties() {
        System.setProperty("PLANTUML_ALLOW_JAVASCRIPT_IN_LINK", "true");
        System.setProperty("PLANTUML_LIMIT_SIZE", String.valueOf(Integer.MAX_VALUE));
    }

    protected String _getPlantUMLContent(Request request, WorkflowDescriptor workflowDescriptor) {
        StringBuilder content = new StringBuilder("@start" + this._getPlantUMLType() + "\n");
        content.append(this._getPlantUMLStyle());
        content.append(this._getPlantUMLGraphContent(request, workflowDescriptor));
        content.append("@end" + this._getPlantUMLType());
        return content.toString();
    }

    protected abstract String _getPlantUMLType();

    protected abstract String _getPlantUMLStyle();

    protected abstract String _getPlantUMLGraphContent(Request var1, WorkflowDescriptor var2);

    protected String _getJsFunction(String workflowName, String stepId, String stepLabel, String actionId, String actionLabel) {
        String jsParameters = "'" + workflowName + "','" + stepId + "','" + stepLabel + "','";
        jsParameters = jsParameters + (String)(actionId != null ? actionId + "','" + actionLabel + "'" : "'");
        return "Ametys.plugins.workflow.UI.UIWorkflowGraph.sendSelection(" + jsParameters + ")";
    }

    protected String _getStepNodeLabel(WorkflowDescriptor workflowDescriptor, int stepId) {
        return this._workflowStepDAO.getStepLabelAsString(workflowDescriptor, stepId, true);
    }

    protected String _getStepTooltip(StepDescriptor step) {
        return this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workflow", "PLUGIN_WORKFLOW_LINK_SEE_STEP"));
    }

    protected String _getActionLabel(String workflowName, ActionDescriptor action) {
        return this._workflowTransitionDAO.getActionLabel(workflowName, action) + " (" + action.getId() + ")";
    }

    protected String _getActionTooltip(ActionDescriptor action) {
        return this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workflow", "PLUGIN_WORKFLOW_LINK_SEE_TRANSITION"));
    }

    protected String _getStringWithEscapedSpace(String stringToEscape) {
        return stringToEscape.replaceAll(" ", "&#160;");
    }
}

