/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.store;

import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.spi.WorkflowEntry;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.version.VersionAwareAmetysObject;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.store.AbstractJackrabbitWorkflowStore;

public class AmetysObjectWorkflowStore
extends AbstractJackrabbitWorkflowStore {
    protected AmetysObjectResolver _resolver;
    protected WorkflowAwareAmetysObject _ametysObject;
    protected WorkflowEntry _inMemoryEntry;
    private boolean _preserveHistory;

    public AmetysObjectWorkflowStore(Repository repository, WorkflowAwareAmetysObject ametysObject, AmetysObjectResolver resolver) {
        this(repository, ametysObject, resolver, false);
    }

    public AmetysObjectWorkflowStore(Repository repository, WorkflowAwareAmetysObject ametysObject, AmetysObjectResolver resolver, boolean preserveHistory) {
        super(repository);
        this._resolver = resolver;
        this._ametysObject = this._ensureBaseVersion(ametysObject);
        this._preserveHistory = preserveHistory;
    }

    @Override
    public boolean shouldClearHistory() {
        return !this._preserveHistory;
    }

    public WorkflowAwareAmetysObject getAmetysObject() {
        return this._ametysObject;
    }

    @Override
    protected Session _getSession() throws RepositoryException {
        return this._ametysObject != null ? this._ametysObject.getNode().getSession() : null;
    }

    @Override
    protected void _release(Session session) {
    }

    protected Node _getAmetysObjectNode() throws RepositoryException {
        return this._ametysObject.getNode();
    }

    @Override
    protected void _createRootNode() throws RepositoryException {
        if (this._ametysObject == null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Ametys object does not currently exist. Root node creation will be delayed. The creation will be done once the ametys object is available.");
            }
            return;
        }
        Session session = null;
        try {
            session = this._getSession();
            Node contentNode = this._getAmetysObjectNode();
            if (!contentNode.hasNode("ametys-internal:workflows")) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug(String.format("Creating osworkflow root node for the ametys object '%s'.", this._ametysObject.getId()));
                }
                contentNode.addNode("ametys-internal:workflows");
            } else if (this._log.isDebugEnabled()) {
                this._log.debug(String.format("Existing osworkflow root node of the ametys object '%s', skipping creation.", this._ametysObject.getId()));
            }
        }
        finally {
            this._release(session);
        }
    }

    @Override
    protected Node _getRootNode(Session session) throws RepositoryException {
        Node contentNode = this._getAmetysObjectNode();
        return contentNode.getNode("ametys-internal:workflows");
    }

    @Override
    protected Node _getOrCreateParentEntryNode(Node root, long id) throws RepositoryException {
        return root;
    }

    @Override
    protected synchronized long _getNextEntryId() throws RepositoryException {
        if (this._ametysObject == null) {
            return 0L;
        }
        return super._getNextEntryId();
    }

    @Override
    protected void storeNewEntry(WorkflowEntry workflowEntry) throws StoreException {
        if (this._ametysObject == null) {
            this._inMemoryEntry = workflowEntry;
            return;
        }
        super.storeNewEntry(workflowEntry);
    }

    public void bindAmetysObject(WorkflowAwareAmetysObject ametysObject) throws StoreException {
        this._ametysObject = this._ensureBaseVersion(ametysObject);
        if (this._inMemoryEntry != null) {
            try {
                this._createRootNode();
            }
            catch (RepositoryException e) {
                throw new StoreException("Unable to create the root node", (Throwable)e);
            }
            this.storeNewEntry(this._inMemoryEntry);
            this._inMemoryEntry = null;
        }
    }

    private WorkflowAwareAmetysObject _ensureBaseVersion(WorkflowAwareAmetysObject ametysObject) {
        VersionAwareAmetysObject vao;
        if (ametysObject instanceof VersionAwareAmetysObject && (vao = (VersionAwareAmetysObject)ametysObject).getRevision() != null) {
            WorkflowAwareAmetysObject workflowAndVersionAwareAmetysObject = (WorkflowAwareAmetysObject)this._resolver.resolveById(ametysObject.getId());
            return workflowAndVersionAwareAmetysObject;
        }
        return ametysObject;
    }
}

