/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
 * This class controls the ribbon button to save workflows
 * @private
 */
Ext.define('Ametys.plugins.workflow.controllers.SaveChangesController', {
    extend: 'Ametys.plugins.workflow.controllers.WorkflowController',

    constructor: function (config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.plugins.workflow.tools.WorkflowEditorTool.WORKFLOW_SAVED, this._onWorkflowSaved, this);
        Ametys.message.MessageBus.on(Ametys.message.Message.CREATED, this._onWorkflowSaved, this);
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onWorkflowSaved, this);
        Ametys.message.MessageBus.on(Ametys.message.Message.DELETED, this._onWorkflowSaved, this);
    },
    
    /**
     * Listener on saved message.
     * Update the state of the controller accordingly.
     * @param {Ametys.message.Message} message the message of type modified.
     * @private
     */
    _onWorkflowSaved: function(message)
    {
        this.refreshIfMatchingMessage (message);
    },
    
    getErrorDescription: function(matchingTarget)
    {
        var hasChanges = matchingTarget.getParameters().hasChanges;
        return hasChanges ? "" : this.getConfig("no-changes-description");
    }
});
