/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.definition;

import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.ametys.plugins.workflow.support.I18nHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class WorkflowDefinition
extends AbstractLogEnabled
implements Component,
Serviceable,
Configurable,
PluginAware {
    protected SourceResolver _srcResolver;
    protected WorkflowHelper _workflowHelper;
    private String _configuredFile;
    private I18nizableText _label;
    private WorkflowDescriptor _descriptor;
    private String _id;
    private String _pluginName;

    public void service(ServiceManager manager) throws ServiceException {
        this._srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._workflowHelper = (WorkflowHelper)((Object)manager.lookup(WorkflowHelper.ROLE));
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._configuredFile = configuration.getChild("file").getValue(null);
        String defaultCatalog = this.getDefaultCatalog();
        I18nizableText defaultValue = new I18nizableText(defaultCatalog, I18nHelper.buildI18nWorkflowKey(this._id));
        this._label = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("label"), (String)defaultCatalog, (I18nizableText)defaultValue);
        this._descriptor = null;
    }

    public String getDefaultCatalog() {
        return "plugin." + this._pluginName;
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
        this._pluginName = pluginName;
    }

    public I18nizableText getLabel() {
        return this._label;
    }

    public String getLocation() {
        return this._getFilePathFromParam(this._id).or(() -> Optional.ofNullable(this._configuredFile)).orElseGet(() -> this._getFilePathFromPlugin(this._pluginName, this._id));
    }

    public WorkflowDescriptor getDescriptor(boolean validate) throws Exception {
        if (this._descriptor == null) {
            try (InputStream is = this.getDefinition();){
                this._descriptor = WorkflowLoader.load((InputStream)is, (boolean)validate);
            }
            this._descriptor.setName(this._id);
        }
        return this._descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getDefinition() throws IOException {
        String location = this.getLocation();
        this.getLogger().debug("Loading '{}' for the workflow '{}'.", (Object)location, (Object)this._id);
        Source source = null;
        try {
            source = this._srcResolver.resolveURI(location);
            InputStream inputStream = source.getInputStream();
            return inputStream;
        }
        finally {
            this._srcResolver.release(source);
        }
    }

    public void reset() {
        this._descriptor = null;
    }

    private Optional<String> _getFilePathFromParam(String workflowId) {
        return Optional.of(workflowId).map(id -> id + ".xml").map(filename -> new File(this._workflowHelper.getParamWorkflowDir(), (String)filename)).filter(File::exists).filter(File::isFile).map(file -> "context://WEB-INF/param/workflows/" + file.getName());
    }

    private String _getFilePathFromPlugin(String pluginName, String workflowId) {
        return "plugin:" + pluginName + "://workflows/" + workflowId + ".xml";
    }
}

