/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.workflow.component.WorkflowLanguageManager;
import org.ametys.plugins.workflow.support.I18nMessageHandler;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowSessionHelper;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class I18nHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = I18nHelper.class.getName();
    protected I18nUtils _i18nUtils;
    protected WorkflowHelper _workflowHelper;
    protected WorkflowSessionHelper _workflowSessionHelper;
    protected WorkflowLanguageManager _workflowLanguageManager;
    protected SourceResolver _sourceResolver;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._workflowSessionHelper = (WorkflowSessionHelper)((Object)manager.lookup(WorkflowSessionHelper.ROLE));
        this._workflowLanguageManager = (WorkflowLanguageManager)manager.lookup(WorkflowLanguageManager.ROLE);
        this._workflowHelper = (WorkflowHelper)((Object)manager.lookup(WorkflowHelper.ROLE));
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public String getI18nDefaultLanguage() {
        Optional<Object> fileLanguage = Optional.empty();
        try {
            fileLanguage = this._getFileLanguage("application");
        }
        catch (Exception e) {
            this.getLogger().warn("An exception occured while getting current catalog language", (Throwable)e);
        }
        return fileLanguage.orElseGet(this._workflowLanguageManager::getCurrentLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> _getFileLanguage(String catalogName) throws Exception {
        String defaultLanguage;
        block11: {
            defaultLanguage = null;
            String defaultI18nCatalogPath = this.getPrefixCatalogLocation(catalogName) + ".xml";
            Source defaultI18nCatalogSource = null;
            try {
                defaultI18nCatalogSource = this._sourceResolver.resolveURI(defaultI18nCatalogPath);
                if (!defaultI18nCatalogSource.exists()) break block11;
                try (InputStream is = defaultI18nCatalogSource.getInputStream();){
                    defaultLanguage = new DefaultConfigurationBuilder(true).build(is).getAttribute("xml:lang", null);
                }
            }
            catch (SourceNotFoundException e) {
                this.getLogger().warn("Couldn't find file at path: {} a new file will be created", (Object)defaultI18nCatalogPath, (Object)e);
            }
            finally {
                this._sourceResolver.release(defaultI18nCatalogSource);
            }
        }
        return Optional.ofNullable(defaultLanguage).filter(StringUtils::isNotEmpty);
    }

    public String translateKey(String workflowName, I18nizableText i18nKey, I18nizableText defaultKey) {
        return Optional.of(workflowName).map(this._workflowSessionHelper::getTranslations).map(translations -> (Map)translations.get(i18nKey)).map(translation -> (String)translation.get(this._workflowLanguageManager.getCurrentLanguage())).filter(StringUtils::isNotEmpty).orElseGet(() -> this._translateKey(i18nKey, defaultKey));
    }

    private String _translateKey(I18nizableText i18nKey, I18nizableText defaultKey) {
        return Optional.ofNullable(this._i18nUtils.translate((I18nizable)i18nKey)).filter(StringUtils::isNotBlank).orElseGet(() -> this._i18nUtils.translate((I18nizable)defaultKey));
    }

    public I18nizableText getWorkflowLabelKey(String workflowName) {
        return ArrayUtils.contains((Object[])this._workflowHelper.getWorkflowNames(), (Object)workflowName) ? this._workflowHelper.getWorkflowLabel(workflowName) : new I18nizableText("application", I18nHelper.buildI18nWorkflowKey(workflowName));
    }

    public I18nizableText generateI18nKey(String workflowName, String type, int workflowElementId) {
        String key = I18nHelper.buildI18nWorkflowKey(workflowName) + "_" + type.toUpperCase() + "_" + workflowElementId;
        String workflowCatalog = this._workflowHelper.getWorkflowCatalog(workflowName);
        I18nizableText i18nKey = new I18nizableText(workflowCatalog, key);
        return i18nKey;
    }

    public void saveCatalogs(Map<String, Map<I18nizableText, String>> newI18nMessages, String currentCatalog) throws Exception {
        String prefixCatalogPath = this.getPrefixCatalogLocation(currentCatalog);
        String defaultLanguage = this.getI18nDefaultLanguage();
        HashMap<String, Map<I18nizableText, String>> i18nCatalogs = new HashMap<String, Map<I18nizableText, String>>();
        for (Map.Entry<String, Map<I18nizableText, String>> i18nMessageTranslation : newI18nMessages.entrySet()) {
            HashMap<I18nizableText, String> i18nMessages = new HashMap();
            String language = i18nMessageTranslation.getKey();
            String catalogPath = prefixCatalogPath + (String)(currentCatalog.equals("application") && language.equals(defaultLanguage) ? "" : "_" + language) + ".xml";
            i18nMessages = this.readI18nCatalog(i18nCatalogs, catalogPath, currentCatalog);
            this._updateI18nMessages(i18nMessages, i18nMessageTranslation.getValue());
            this._saveI18nCatalog(i18nMessages, catalogPath, language);
        }
    }

    public void clearCaches() {
        this._i18nUtils.reloadCatalogues();
        this._observationManager.notify(new Event("cache.reset", this._currentUserProvider.getUser(), Collections.singletonMap("cache.id", I18nUtils.I18N_CACHE)));
    }

    public Map<String, Map<I18nizableText, String>> createNewI18nCatalogs(Map<I18nizableText, Map<String, String>> translationsToConvert) {
        HashMap<String, Map<I18nizableText, String>> i18nMessageTranslations = new HashMap<String, Map<I18nizableText, String>>();
        for (Map.Entry<I18nizableText, Map<String, String>> newI18n : translationsToConvert.entrySet()) {
            this._updateI18nMessageTranslations(i18nMessageTranslations, newI18n.getKey(), newI18n.getValue());
        }
        return i18nMessageTranslations;
    }

    private void _updateI18nMessageTranslations(Map<String, Map<I18nizableText, String>> i18nMessageTranslations, I18nizableText key, Map<String, String> translations) {
        for (Map.Entry<String, String> translation : translations.entrySet()) {
            String language = translation.getKey();
            Map map = i18nMessageTranslations.computeIfAbsent(language, __ -> new HashMap());
            map.put(key, translation.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<I18nizableText, String> readI18nCatalog(Map<String, Map<I18nizableText, String>> i18nCatalogs, String path, String currentCatalog) {
        LinkedHashMap<I18nizableText, String> i18nMessages;
        block12: {
            if (i18nCatalogs.containsKey(path)) {
                return i18nCatalogs.get(path);
            }
            i18nMessages = new LinkedHashMap<I18nizableText, String>();
            Source i18nCatalogSource = null;
            try {
                i18nCatalogSource = this._sourceResolver.resolveURI(path);
                if (!i18nCatalogSource.exists()) break block12;
                try (InputStream is = i18nCatalogSource.getInputStream();){
                    SAXParserFactory.newInstance().newSAXParser().parse(is, (DefaultHandler)new I18nMessageHandler(i18nMessages, currentCatalog));
                    i18nCatalogs.put(path, i18nMessages);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                this.getLogger().error("An error occured while reading existing i18n catalog", (Throwable)e);
            }
            finally {
                this._sourceResolver.release(i18nCatalogSource);
            }
        }
        return i18nMessages;
    }

    private void _updateI18nMessages(Map<I18nizableText, String> i18nMessages, Map<I18nizableText, String> newI18nMessages) {
        for (Map.Entry<I18nizableText, String> newI18nMessage : newI18nMessages.entrySet()) {
            i18nMessages.put(newI18nMessage.getKey(), newI18nMessage.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _saveI18nCatalog(Map<I18nizableText, String> i18nMessages, String catalogPath, String language) {
        ModifiableSource defaultI18nCatalogSource = null;
        try {
            defaultI18nCatalogSource = (ModifiableSource)this._sourceResolver.resolveURI(catalogPath);
            try (OutputStream os = defaultI18nCatalogSource.getOutputStream();){
                TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
                StreamResult result = new StreamResult(os);
                th.setResult(result);
                Properties format = new Properties();
                format.put("method", "xml");
                format.put("indent", "yes");
                format.put("encoding", "UTF-8");
                format.put("{http://xml.apache.org/xalan}indent-amount", "2");
                th.getTransformer().setOutputProperties(format);
                this._saxI18nCatalog(th, i18nMessages, language);
            }
            catch (Exception e) {
                this.getLogger().error("An error occured while saving the catalog values.", (Throwable)e);
            }
        }
        catch (IOException e) {
            this.getLogger().error("An error occured while getting i18n catalog", (Throwable)e);
        }
        finally {
            this._sourceResolver.release((Source)defaultI18nCatalogSource);
        }
    }

    private void _saxI18nCatalog(TransformerHandler handler, Map<I18nizableText, String> i18nMessages, String language) throws SAXException {
        handler.startDocument();
        AttributesImpl attribute = new AttributesImpl();
        attribute.addCDATAAttribute("xml:lang", language);
        XMLUtils.startElement((ContentHandler)handler, (String)"catalogue", (Attributes)attribute);
        for (Map.Entry<I18nizableText, String> i18Message : i18nMessages.entrySet()) {
            attribute = new AttributesImpl();
            attribute.addCDATAAttribute("key", i18Message.getKey().getKey());
            XMLUtils.createElement((ContentHandler)handler, (String)"message", (Attributes)attribute, (String)i18Message.getValue());
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"catalogue");
        handler.endDocument();
    }

    public String getPrefixCatalogLocation(String catalogName) {
        if (catalogName.equals("application")) {
            return this._i18nUtils.getApplicationCatalogLocation() + "/application";
        }
        String[] catalogParts = catalogName.split("\\.", 2);
        if (catalogParts.length != 2) {
            throw new IllegalArgumentException("The catalog name should be composed of two parts (like plugin.cms): " + catalogName);
        }
        return this._i18nUtils.getOverridableCatalogLocation(catalogParts[0], catalogParts[1]) + "/messages";
    }

    public static String buildI18nWorkflowKey(String workflowName) {
        return "WORKFLOW_" + workflowName.replace("-", "_").toUpperCase();
    }
}

