/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.support;

import com.opensymphony.workflow.AbstractWorkflow;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowFactory;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.plugins.workflow.AmetysWorkflowFactory;
import org.ametys.plugins.workflow.definition.WorkflowDefinition;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class WorkflowHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = WorkflowHelper.class.getName();
    public static final String[] ICON_SIZES = new String[]{"small", "medium", "large"};
    protected WorkflowProvider _workflowProvider;
    protected SourceResolver _sourceResolver;
    protected org.apache.avalon.framework.context.Context _context;
    protected Context _cocoonContext;

    public void service(ServiceManager smanager) throws ServiceException {
        this._workflowProvider = (WorkflowProvider)smanager.lookup(WorkflowProvider.ROLE);
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)this._context.get((Object)"environment-context");
    }

    public String[] getWorkflowNames() {
        try {
            return this._workflowProvider.getWorkflowFactory().getWorkflowNames();
        }
        catch (FactoryException e) {
            this.getLogger().error("Error getting workflow names", (Throwable)e);
            return new String[0];
        }
    }

    public WorkflowDescriptor getWorkflowDescriptor(String workflowName) {
        try {
            return this._workflowProvider.getWorkflowFactory().getWorkflow(workflowName);
        }
        catch (FactoryException e) {
            this.getLogger().error("Error loading workflow " + workflowName, (Throwable)e);
            return null;
        }
    }

    public Set<Integer> getAllActions(WorkflowDescriptor workflowDesc) {
        HashSet<Integer> actions = new HashSet<Integer>();
        actions.addAll(this._getActionIds(workflowDesc.getInitialActions()));
        actions.addAll(this._getActionIds(workflowDesc.getGlobalActions()));
        actions.addAll(workflowDesc.getCommonActions().keySet());
        List stepActions = workflowDesc.getSteps().stream().map(stepDesc -> stepDesc.getActions()).map(this::_getActionIds).flatMap(Collection::stream).toList();
        actions.addAll(stepActions);
        return actions;
    }

    public String getActionName(String workflowName, int actionID) {
        return Optional.of(workflowName).map(this::getWorkflowDescriptor).map(workflowDesc -> workflowDesc.getAction(actionID)).map(ActionDescriptor::getName).orElse("");
    }

    public String getStepName(String workflowName, int stepId) {
        return Optional.of(workflowName).map(this::getWorkflowDescriptor).map(workflowDesc -> workflowDesc.getStep(stepId)).map(StepDescriptor::getName).orElse("");
    }

    public int getInitialAction(String workflowName) {
        WorkflowDescriptor workflowDesc = this.getWorkflowDescriptor(workflowName);
        if (workflowDesc == null) {
            return -1;
        }
        List actionDescriptor = workflowDesc.getInitialActions();
        if (actionDescriptor.isEmpty()) {
            return -1;
        }
        return ((ActionDescriptor)actionDescriptor.get(0)).getId();
    }

    private List<Integer> _getActionIds(List<ActionDescriptor> actionDescriptors) {
        return actionDescriptors.stream().map(AbstractDescriptor::getId).toList();
    }

    public List<Step> getStepAt(Workflow workflow, long entryId, Date timestamp) throws WorkflowException {
        return this.getStepsBetween(workflow, entryId, timestamp, timestamp);
    }

    public List<Step> getStepsBetween(Workflow workflow, long entryId, Date start, Date end) throws WorkflowException {
        WorkflowStore store = ((AbstractWorkflow)workflow).getConfiguration().getWorkflowStore();
        ArrayList<Step> steps = new ArrayList<Step>();
        ArrayList allSteps = new ArrayList();
        allSteps.addAll(store.findCurrentSteps(entryId));
        allSteps.addAll(store.findHistorySteps(entryId));
        for (Step step : allSteps) {
            Date stepStartDate = step.getStartDate();
            Date stepFinishDate = step.getFinishDate();
            if (stepStartDate != null) {
                if (!end.after(stepStartDate) || stepFinishDate != null && !start.before(stepFinishDate)) continue;
                steps.add(step);
                continue;
            }
            if (stepFinishDate != null && !start.before(stepFinishDate)) continue;
            steps.add(step);
        }
        return steps;
    }

    public I18nizableText getWorkflowLabel(String workflowName) {
        return Optional.ofNullable(this._getWorkflowDefinition(workflowName)).map(WorkflowDefinition::getLabel).orElseGet(() -> new I18nizableText(workflowName));
    }

    public String getWorkflowCatalog(String workflowName) {
        WorkflowDefinition wfDef = this._getWorkflowDefinition(workflowName);
        if (wfDef != null) {
            I18nizableText wfLabel = wfDef.getLabel();
            if (wfLabel.isI18n()) {
                return wfLabel.getCatalogue();
            }
            return wfDef.getDefaultCatalog();
        }
        return "application";
    }

    private WorkflowDefinition _getWorkflowDefinition(String workflowName) {
        try {
            WorkflowFactory wFactory = this._workflowProvider.getWorkflowFactory();
            if (wFactory instanceof AmetysWorkflowFactory) {
                AmetysWorkflowFactory ametysWFactory = (AmetysWorkflowFactory)wFactory;
                return ametysWFactory.getWorkflowDefinition(workflowName);
            }
        }
        catch (FactoryException e) {
            this.getLogger().debug("The workflow '{}' may not exist anymore", (Object)workflowName, (Object)e);
        }
        return null;
    }

    public StepDescriptor getStepDescriptor(WorkflowAwareAmetysObject ametysObject, int stepId) {
        String workflowName;
        long workflowId = ametysObject.getWorkflowId();
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow(ametysObject);
        WorkflowDescriptor workflowDescriptor = workflow.getWorkflowDescriptor(workflowName = workflow.getWorkflowName(workflowId));
        if (workflowDescriptor != null) {
            StepDescriptor stepDescriptor = workflowDescriptor.getStep(stepId);
            if (stepDescriptor != null) {
                return stepDescriptor;
            }
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Unknown step id '" + stepId + "' for workflow for name : " + workflowName);
            }
        } else if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Unknown workflow for name : " + workflowName);
        }
        return null;
    }

    public Map<String, Object> workflowStep2JSON(StepDescriptor step) {
        LinkedHashMap<String, Object> workflowInfos = new LinkedHashMap<String, Object>();
        I18nizableText workflowStepName = new I18nizableText("application", step.getName());
        workflowInfos.put("stepId", step.getId());
        workflowInfos.put("name", workflowStepName);
        String workflowIconPath = this._getWorkflowIconPath(workflowStepName.getCatalogue());
        for (String size : ICON_SIZES) {
            workflowInfos.put(size + "Icon", workflowIconPath + this._getWorkflowIconFilename(workflowStepName, size));
        }
        return workflowInfos;
    }

    private String _getWorkflowIconPath(String catalog) {
        if ("application".equals(catalog)) {
            return "/plugins/cms/resources_workflow/";
        }
        String[] catalogParts = catalog.split("\\.", 2);
        if (catalogParts.length != 2) {
            throw new IllegalArgumentException("The catalog name should be composed of two parts (like plugin.cms): " + catalog);
        }
        return "/" + catalogParts[0] + "s/" + catalogParts[1] + "/resources/img/workflow/";
    }

    private String _getWorkflowIconPathURI(String catalog) {
        if ("application".equals(catalog)) {
            return "context://WEB-INF/param/workflow_resources/";
        }
        String[] catalogParts = catalog.split("\\.", 2);
        if (catalogParts.length != 2) {
            throw new IllegalArgumentException("The catalog name should be composed of two parts (like plugin.cms): " + catalog);
        }
        return catalogParts[0] + ":" + catalogParts[1] + "://resources/img/workflow/";
    }

    private String _getWorkflowIconFilename(I18nizableText label, String size) {
        return label.getKey() + "-" + size + ".png";
    }

    public String getElementIconAsBase64(I18nizableText workflowElementName, String defaultPath) {
        String workflowIconURI = this.getElementIconURI(workflowElementName);
        String path = this._resolveImageAsBase64(workflowIconURI);
        if (path == null) {
            return this._resolveImageAsBase64(defaultPath);
        }
        return path;
    }

    /*
     * Exception decompiling
     */
    protected String _resolveImageAsBase64(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getElementIconPath(I18nizableText workflowElementName, String defaultPath) {
        return ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context).getContextPath() + this._getElementIconPath(workflowElementName, defaultPath);
    }

    private String _getElementIconPath(I18nizableText workflowElementName, String defaultPath, String size) {
        String workflowIconURI = this.getElementIconURI(workflowElementName);
        if (this._imageURIExists(workflowIconURI)) {
            return this._getWorkflowIconPath(workflowElementName.getCatalogue()) + this._getWorkflowIconFilename(workflowElementName, size);
        }
        return defaultPath;
    }

    private String _getElementIconPath(I18nizableText workflowElementName, String defaultPath) {
        return this._getElementIconPath(workflowElementName, defaultPath, "small");
    }

    public String getElementIconURI(I18nizableText workflowElementName) {
        return this._getWorkflowIconPathURI(workflowElementName.getCatalogue()) + this._getWorkflowIconFilename(workflowElementName, "small");
    }

    public String getElementIconURI(I18nizableText workflowElementName, String size) {
        return this._getWorkflowIconPathURI(workflowElementName.getCatalogue()) + this._getWorkflowIconFilename(workflowElementName, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _imageURIExists(String path) {
        Source resolveURI = null;
        try {
            resolveURI = this._sourceResolver.resolveURI(path);
            boolean bl = resolveURI.exists();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this._sourceResolver.release(resolveURI);
        }
    }

    public File getParamWorkflowDir() {
        return new File(this._cocoonContext.getRealPath("/WEB-INF/param/workflows"));
    }

    public static enum WorkflowVisibility {
        SYSTEM,
        USER;

    }
}

