/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workflow.support;

import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.workflow.component.WorkflowLanguageManager;
import org.ametys.plugins.workflow.support.I18nHelper;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowToSave;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;
import org.w3c.dom.Document;

public class WorkflowSessionHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = WorkflowSessionHelper.class.getName();
    private static final String __WORKFLOW_NAMES = "workflowNames";
    protected WorkflowLanguageManager _workflowLanguageManager;
    protected Context _context;
    protected I18nUtils _i18nUtils;
    protected WorkflowHelper _workflowHelper;
    protected I18nHelper _i18nHelper;
    protected SourceResolver _sourceResolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._workflowHelper = (WorkflowHelper)((Object)smanager.lookup(WorkflowHelper.ROLE));
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._workflowLanguageManager = (WorkflowLanguageManager)smanager.lookup(WorkflowLanguageManager.ROLE);
        this._i18nHelper = (I18nHelper)((Object)smanager.lookup(I18nHelper.ROLE));
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public boolean hasChanges(String workflowName) {
        return this._getWorkflowToSave(workflowName, false) != null;
    }

    public I18nizableText getWorkflowLabel(String workflowName) {
        WorkflowToSave workflowToSave = this._getWorkflowToSave(workflowName, false);
        if (workflowToSave != null) {
            I18nizableText workflowLabelKey = this._i18nHelper.getWorkflowLabelKey(workflowName);
            Map<String, String> workflowLabels = workflowToSave.getTranslations().get(workflowLabelKey);
            if (workflowLabels != null) {
                return new I18nizableText(workflowLabels.get(this._workflowLanguageManager.getCurrentLanguage()));
            }
        }
        return this._workflowHelper.getWorkflowLabel(workflowName);
    }

    public Map<String, String> getWorkflowLabelTranslations(String workflowName) {
        I18nizableText workflowLabelKey = this._i18nHelper.getWorkflowLabelKey(workflowName);
        return Optional.of(workflowName).map(arg_0 -> ((Session)this._getSession()).getAttribute(arg_0)).map(WorkflowToSave.class::cast).map(WorkflowToSave::getTranslations).map(translations -> (Map)translations.get(workflowLabelKey)).orElseGet(HashMap::new);
    }

    public Map<I18nizableText, Map<String, String>> getTranslations(String workflowName) {
        return Optional.ofNullable(this._getWorkflowToSave(workflowName, false)).map(WorkflowToSave::getTranslations).orElseGet(() -> this._initTranslations(workflowName));
    }

    public Map<String, String> getTranslation(String workflowName, I18nizableText i18nKey) {
        return this.getTranslations(workflowName).get(i18nKey);
    }

    public void updateTranslations(String workflowName, I18nizableText labelKey, Map<String, String> translations) {
        WorkflowToSave workflowToSave = this._getWorkflowToSave(workflowName, true);
        workflowToSave.updateTranslations(labelKey, translations);
        this._updateWorkflowToSave(workflowToSave);
    }

    public void removeTranslation(String workflowName, I18nizableText key) {
        WorkflowToSave workflowToSave = this._getWorkflowToSave(workflowName, true);
        workflowToSave.getTranslations().remove(key);
        this._updateWorkflowToSave(workflowToSave);
    }

    public Set<String> getWorkflowNames() {
        Session session = this._getSession();
        if (session.getAttribute(__WORKFLOW_NAMES) != null) {
            return (Set)session.getAttribute(__WORKFLOW_NAMES);
        }
        String[] names = this._workflowHelper.getWorkflowNames();
        return new HashSet<String>(Arrays.asList(names));
    }

    public void updateWorkflowNames(WorkflowDescriptor workflowDescriptor) {
        Set<String> workflowNames = this.getWorkflowNames();
        workflowNames.add(workflowDescriptor.getName());
        this._getSession().setAttribute(__WORKFLOW_NAMES, workflowNames);
    }

    private WorkflowToSave _getWorkflowToSave(String workflowName, boolean initIfNull) {
        Session session = this._getSession();
        if (session.getAttribute(workflowName) == null && initIfNull) {
            this._initSession(workflowName);
        }
        return (WorkflowToSave)session.getAttribute(workflowName);
    }

    private void _initSession(String workflowName) {
        WorkflowDescriptor workflow = this._cloneWorkflowDescriptor(workflowName);
        this._initSession(workflowName, workflow);
    }

    private void _initSession(String workflowName, WorkflowDescriptor workflow) {
        Session session = this._getSession();
        Map<I18nizableText, Map<String, String>> translations = this._initTranslations(workflowName);
        session.setAttribute(workflowName, (Object)new WorkflowToSave(workflow, translations));
    }

    private Map<I18nizableText, Map<String, String>> _initTranslations(String workflowName) {
        HashMap<I18nizableText, Map<String, String>> translations = new HashMap<I18nizableText, Map<String, String>>();
        Set<String> languages = this._workflowLanguageManager.getLanguages();
        String defaultLanguage = this._i18nHelper.getI18nDefaultLanguage();
        String workflowCatalog = this._workflowHelper.getWorkflowCatalog(workflowName);
        String prefixCatalogPath = this._i18nHelper.getPrefixCatalogLocation(workflowCatalog);
        for (String language : languages) {
            String catalogPath = prefixCatalogPath + (String)(workflowCatalog.equals("application") && language.equals(defaultLanguage) ? "" : "_" + language) + ".xml";
            Map<I18nizableText, String> catalog = this._i18nHelper.readI18nCatalog(new HashMap<String, Map<I18nizableText, String>>(), catalogPath, workflowCatalog);
            for (Map.Entry<I18nizableText, String> entry : catalog.entrySet()) {
                String value = entry.getValue();
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                I18nizableText i18nKey = entry.getKey();
                Map translation = translations.computeIfAbsent(i18nKey, __ -> new HashMap());
                translation.put(language, value);
            }
        }
        return translations;
    }

    private void _updateWorkflowToSave(WorkflowToSave workflowToSave) {
        this._getSession().setAttribute(workflowToSave.getWorkflow().getName(), (Object)workflowToSave);
    }

    public WorkflowDescriptor getWorkflowDescriptor(String workflowName, boolean initSessionIfNull) {
        WorkflowToSave workflowToSave = this._getWorkflowToSave(workflowName, initSessionIfNull);
        return workflowToSave != null ? workflowToSave.getWorkflow() : this._cloneWorkflowDescriptor(workflowName);
    }

    private WorkflowDescriptor _cloneWorkflowDescriptor(String workflowName) {
        WorkflowDescriptor workflowDescriptor;
        WorkflowDescriptor workflowDescriptor2 = this._workflowHelper.getWorkflowDescriptor(workflowName);
        if (workflowDescriptor2 == null) {
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder docB = dbf.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(workflowDescriptor2.asXML().getBytes(StandardCharsets.UTF_8));
        try {
            Document doc = docB.parse(is);
            WorkflowDescriptor workflowDescriptorCopy = DescriptorFactory.getFactory().createWorkflowDescriptor(doc.getDocumentElement());
            workflowDescriptorCopy.setName(workflowName);
            workflowDescriptor = workflowDescriptorCopy;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.getLogger().error("An error occurred creating clone of workflow descriptor with name {}", (Object)workflowName, (Object)e);
                return null;
            }
        }
        ((InputStream)is).close();
        return workflowDescriptor;
    }

    public void initWorkflowDescriptor(WorkflowDescriptor workflow) {
        this._initSession(workflow.getName(), workflow);
    }

    public void updateWorkflowDescriptor(WorkflowDescriptor workflow) {
        String workflowName = workflow.getName();
        WorkflowToSave workflowToSave = this._getWorkflowToSave(workflowName, true);
        workflowToSave.setWorkflow(workflow);
        this._updateWorkflowToSave(workflowToSave);
    }

    public WorkflowDescriptor duplicateWorkflow(String newWorkflowName, Map<String, String> labels, String duplicatedWorkflowName) {
        WorkflowDescriptor workflowCloned = this._cloneWorkflowDescriptor(duplicatedWorkflowName);
        workflowCloned.setName(newWorkflowName);
        workflowCloned.getMetaAttributes().put("user", true);
        workflowCloned.getMetaAttributes().put("new-workflow", true);
        this._initSession(newWorkflowName, workflowCloned);
        this.updateWorkflowNames(workflowCloned);
        WorkflowToSave workflowToSave = this._getWorkflowToSave(newWorkflowName, true);
        workflowToSave.updateTranslations(this._i18nHelper.getWorkflowLabelKey(newWorkflowName), labels);
        workflowToSave.setWorkflow(workflowCloned);
        workflowToSave.setCloned(true);
        HashMap<I18nizableText, I18nizableText> clonedKeys = new HashMap<I18nizableText, I18nizableText>();
        this._cloneStepTranslations(workflowCloned, workflowCloned.getSteps(), clonedKeys);
        Set<Integer> transitionIds = this._workflowHelper.getAllActions(workflowCloned);
        this._cloneTransitionsTranslations(workflowCloned, transitionIds, clonedKeys);
        workflowToSave.setClonedKeys(clonedKeys);
        return workflowCloned;
    }

    public void deleteSession(String workflowName) {
        this._getSession().removeAttribute(workflowName);
    }

    private Session _getSession() {
        Request request = ContextHelper.getRequest((Context)this._context);
        return request.getSession(true);
    }

    private void _cloneTransitionsTranslations(WorkflowDescriptor workflow, Set<Integer> actionIds, Map<I18nizableText, I18nizableText> clonedKeys) {
        Map<I18nizableText, Map<String, String>> applicationTranslations = this.getTranslations(workflow.getName());
        for (Integer actionId : actionIds) {
            ActionDescriptor action = workflow.getAction(actionId.intValue());
            I18nizableText actionLabelKey = new I18nizableText("application", action.getName());
            I18nizableText newActionLabelKey = this._i18nHelper.generateI18nKey(workflow.getName(), "action", action.getId());
            clonedKeys.put(newActionLabelKey, actionLabelKey);
            this._updateApplicationTranslations(applicationTranslations, actionLabelKey, newActionLabelKey);
            action.setName(newActionLabelKey.toString());
        }
    }

    private void _cloneStepTranslations(WorkflowDescriptor workflow, List<StepDescriptor> steps, Map<I18nizableText, I18nizableText> clonedKeys) {
        Map<I18nizableText, Map<String, String>> applicationTranslations = this.getTranslations(workflow.getName());
        for (StepDescriptor step : steps) {
            I18nizableText stepLabelKey = new I18nizableText("application", step.getName());
            I18nizableText newStepLabelKey = this._i18nHelper.generateI18nKey(workflow.getName(), "step", step.getId());
            clonedKeys.put(newStepLabelKey, stepLabelKey);
            this._updateApplicationTranslations(applicationTranslations, stepLabelKey, newStepLabelKey);
            step.setName(newStepLabelKey.toString());
        }
    }

    private void _updateApplicationTranslations(Map<I18nizableText, Map<String, String>> applicationTranslations, I18nizableText initialLabelKey, I18nizableText newLabelKey) {
        Set<String> languages = this._workflowLanguageManager.getLanguages();
        if (applicationTranslations.containsKey(initialLabelKey)) {
            applicationTranslations.put(newLabelKey, applicationTranslations.get(initialLabelKey));
        } else {
            HashMap<String, String> actionTranslations = new HashMap<String, String>();
            for (String language : languages) {
                String translation = this._i18nUtils.translate((I18nizable)initialLabelKey, language);
                if (!StringUtils.isNotBlank((CharSequence)translation)) continue;
                actionTranslations.put(language, translation);
            }
            if (!actionTranslations.isEmpty()) {
                applicationTranslations.put(newLabelKey, actionTranslations);
            }
        }
    }

    public void cloneImages(String workflowName) {
        WorkflowToSave workflowToSave = this._getWorkflowToSave(workflowName, false);
        if (workflowToSave.isCloned()) {
            Map<I18nizableText, I18nizableText> clonedKeys = workflowToSave.getClonedKeys();
            for (Map.Entry<I18nizableText, I18nizableText> entry : clonedKeys.entrySet()) {
                I18nizableText elementLabel = entry.getValue();
                I18nizableText newElementLabel = entry.getKey();
                for (String size : WorkflowHelper.ICON_SIZES) {
                    this._copyImage(elementLabel, newElementLabel, size);
                }
            }
            workflowToSave.setCloned(false);
        }
    }

    public I18nizableText getOldLabelKeyIfCloned(String workflowName, I18nizableText label) {
        WorkflowToSave workflowToSave = this._getWorkflowToSave(workflowName, false);
        if (workflowToSave != null && workflowToSave.isCloned()) {
            Map<I18nizableText, I18nizableText> clonedKeys = workflowToSave.getClonedKeys();
            return clonedKeys.containsKey(label) ? clonedKeys.get(label) : label;
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _copyImage(I18nizableText elementLabel, I18nizableText newElementLabel, String size) {
        FileSource clonedImageSource;
        Source imageSource;
        block15: {
            imageSource = null;
            clonedImageSource = null;
            try {
                imageSource = this._sourceResolver.resolveURI(this._workflowHelper.getElementIconURI(elementLabel, size));
                if (!imageSource.exists()) break block15;
                clonedImageSource = (FileSource)this._sourceResolver.resolveURI(this._workflowHelper.getElementIconURI(newElementLabel, size));
                File clonedImage = clonedImageSource.getFile();
                FileUtils.createParentDirectories((File)clonedImage);
                try (InputStream is = imageSource.getInputStream();
                     FileOutputStream os = new FileOutputStream(clonedImage);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
            }
            catch (IOException e) {
                try {
                    this.getLogger().error("An error occured while copying existing i18n catalog", (Throwable)e);
                }
                catch (Throwable throwable) {
                    this._sourceResolver.release(imageSource);
                    this._sourceResolver.release(clonedImageSource);
                    throw throwable;
                }
                this._sourceResolver.release(imageSource);
                this._sourceResolver.release(clonedImageSource);
            }
        }
        this._sourceResolver.release(imageSource);
        this._sourceResolver.release(clonedImageSource);
    }
}

