/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class manage edit and delete buttons
 */
Ext.define('Ametys.plugins.workflow.controllers.EditOrDeleteElementController', {
    extend: 'Ametys.plugins.workflow.controllers.WorkflowController',
    
    getErrorDescription: function(matchingTarget)
    {
        var stepTarget = matchingTarget.getSubtarget(function(target){return target.getId() == Ametys.message.MessageTarget.WORKFLOW_STEP});
        if (stepTarget)
        {
            if (stepTarget.getSubtargets().length)// if is not a step
            {
                var resultTarget = stepTarget.getSubtarget(function(target){return target.getId() == Ametys.message.MessageTarget.WORKFLOW_RESULT});
                if (resultTarget && !resultTarget.getParameters().isConditional) //is unconditional steps
                {
                     return this.getInitialConfig("unconditional-result-description");
                }
            }
            else if (stepTarget.getParameters().id == 0) // is initial step
            {
                return this.getInitialConfig("is-initial-step-description");
            }
        }
        return "";
    }
});
