/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a workflow.
 * @private
 */
Ext.define("Ametys.plugins.workflow.messages.Workflow", 
    {
        config: {
            /**
             * @cfg {String} id The unique id of the workflow
             */
            /**
             * @method getId Get the #cfg-id
             * @return {String} The id
             */
            /** @ignore */
            id: null,
            /**
             * @cfg {String} label The label of the workflow
             */
            /**
             * @method getLabel Get the #cfg-title
             * @return {String} The label
             */
            /** @ignore */
            label: null,
            /**
             * @cfg {Boolean} hasChildren True if the workflow has elements
             */
            /**
             * @method getHasChildren Get the #cfg-hasChildren
             * @return {Boolean} True if the workflow has elements
             */
            /** @ignore */
            hasChildren: null,
            /**
             * @cfg {Boolean} hasChanges True if current workflow has unsaved changes
             */
            /**
             * @method getHasChanges Get the #cfg-hasChanges
             * @return {Boolean} True if current workflow has unsaved changes
             */
            /** @ignore */
            hasChanges: null,
            /**
             * @cfg {Boolean} hasOlderVersion True if workflow has an older version file
             */
            /**
             * @method getIsNew Get the #cfg-isNew
             * @return {Boolean} True if workflow never been saved
             */
            /** @ignore */
            isNew: null,
            /**
             * @method getCanWrite Get the #cfg-canWrite
             * @return {Boolean} True if current user can write on this workflow
             */
            /** @ignore */
            canWrite: null
        },
        
        /**
         * Creates a content instance
         * @param {Object} config See configuration doc.
         */
        constructor: function (config)
        {
            this.initConfig(config);
        },
        
        /**
         * Get the workflow's properties
         * @return {Object} initialProperty The initial workflow's properties
         */
        getProperties: function (initialProperty)
        {
            initialProperty = initialProperty || {};
            
            return Ext.apply ({
                    id: this._id,
                    label: this._label,
                    hasChildren: this._hasChildren,
                    hasChanges: this._hasChanges,
                    isNew: this._isNew,
                    canWrite: this._canWrite,
                }, initialProperty
            );
        }
    }
);
