/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

class CheckGlobalNames
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private final CheckLevel level;
    private GlobalNamespace namespace = null;
    private final Set<String> objectPrototypeProps = new HashSet<String>();
    private final Set<String> functionPrototypeProps = new HashSet<String>();
    static final DiagnosticType UNDEFINED_NAME_WARNING = DiagnosticType.warning("JSC_UNDEFINED_NAME", "{0} is never defined");
    static final DiagnosticType NAME_DEFINED_LATE_WARNING = DiagnosticType.warning("JSC_NAME_DEFINED_LATE", "{0} defined before its owner. {1} is defined at {2}:{3}");
    static final DiagnosticType STRICT_MODULE_DEP_QNAME = DiagnosticType.disabled("JSC_STRICT_MODULE_DEP_QNAME", "cannot reference {2} because of a missing module dependency\ndefined in module {1}, referenced from module {0}");

    CheckGlobalNames(AbstractCompiler compiler, CheckLevel level) {
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
        this.level = level;
    }

    CheckGlobalNames injectNamespace(GlobalNamespace namespace) {
        Preconditions.checkArgument((boolean)namespace.hasExternsRoot());
        this.namespace = namespace;
        return this;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.namespace == null) {
            this.namespace = new GlobalNamespace(this.compiler, externs, root);
        }
        Preconditions.checkState((boolean)this.namespace.hasExternsRoot());
        this.findPrototypeProps("Object", this.objectPrototypeProps);
        this.findPrototypeProps("Function", this.functionPrototypeProps);
        this.objectPrototypeProps.addAll(this.convention.getIndirectlyDeclaredProperties());
        for (GlobalNamespace.Name name : this.namespace.getNameForest()) {
            if (name.inExterns) continue;
            this.checkDescendantNames(name, name.globalSets + name.localSets > 0);
        }
    }

    private void findPrototypeProps(String type, Set<String> props) {
        GlobalNamespace.Name slot = this.namespace.getSlot(type);
        if (slot != null) {
            for (GlobalNamespace.Ref ref : slot.getRefs()) {
                Node fullName;
                if (ref.type != GlobalNamespace.Ref.Type.PROTOTYPE_GET || !(fullName = ref.getNode().getGrandparent()).isGetProp()) continue;
                props.add(fullName.getLastChild().getString());
            }
        }
    }

    private void checkDescendantNames(GlobalNamespace.Name name, boolean nameIsDefined) {
        if (name.props != null) {
            for (GlobalNamespace.Name prop : name.props) {
                boolean propIsDefined = false;
                if (nameIsDefined) {
                    propIsDefined = !this.propertyMustBeInitializedByFullName(prop) || prop.globalSets + prop.localSets > 0;
                }
                this.validateName(prop, propIsDefined);
                this.checkDescendantNames(prop, propIsDefined);
            }
        }
    }

    private void validateName(GlobalNamespace.Name name, boolean isDefined) {
        GlobalNamespace.Ref declaration = name.getDeclaration();
        GlobalNamespace.Name parent = name.parent;
        JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
        for (GlobalNamespace.Ref ref : name.getRefs()) {
            boolean isPrototypeGet;
            GlobalNamespace.Name owner;
            boolean singleGlobalParentDecl;
            boolean isGlobalExpr = ref.getNode().getParent().isExprResult();
            if (!isDefined && !CheckGlobalNames.isTypedef(ref)) {
                if (isGlobalExpr) continue;
                this.reportRefToUndefinedName(name, ref);
                continue;
            }
            if (declaration != null && ref.getModule() != declaration.getModule() && !moduleGraph.dependsOn(ref.getModule(), declaration.getModule())) {
                this.reportBadModuleReference(name, ref);
                continue;
            }
            if (!((Scope)ref.scope.getClosestHoistScope()).isGlobal() || !(singleGlobalParentDecl = (owner = (isPrototypeGet = ref.type == GlobalNamespace.Ref.Type.PROTOTYPE_GET) ? name : parent) != null && owner.getDeclaration() != null && owner.localSets == 0) || owner.getDeclaration().preOrderIndex <= ref.preOrderIndex) continue;
            String refName = isPrototypeGet ? name.getFullName() + ".prototype" : name.getFullName();
            this.compiler.report(JSError.make(ref.node, NAME_DEFINED_LATE_WARNING, refName, owner.getFullName(), owner.getDeclaration().getSourceFile().getName(), String.valueOf(owner.getDeclaration().node.getLineno())));
        }
    }

    private static boolean isTypedef(GlobalNamespace.Ref ref) {
        JSDocInfo info;
        Node parent = ref.node.getParent();
        return parent.isExprResult() && (info = ref.node.getJSDocInfo()) != null && info.hasTypedefType();
    }

    private void reportBadModuleReference(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.node, STRICT_MODULE_DEP_QNAME, ref.getModule().getName(), name.getDeclaration().getModule().getName(), name.getFullName()));
    }

    private void reportRefToUndefinedName(GlobalNamespace.Name name, GlobalNamespace.Ref ref) {
        while (name.parent != null && name.parent.globalSets + name.parent.localSets == 0) {
            name = name.parent;
        }
        this.compiler.report(JSError.make(ref.node, this.level, UNDEFINED_NAME_WARNING, name.getFullName()));
    }

    private boolean propertyMustBeInitializedByFullName(GlobalNamespace.Name name) {
        if (name.parent == null) {
            return false;
        }
        boolean parentIsAliased = false;
        if (name.parent.aliasingGets > 0) {
            for (GlobalNamespace.Ref ref : name.parent.getRefs()) {
                Node aliaser;
                boolean isKnownAlias;
                if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET || (isKnownAlias = (aliaser = ref.getNode().getParent()).isCall() && (this.convention.getClassesDefinedByCall(aliaser) != null || this.convention.getSingletonGetterClassName(aliaser) != null))) continue;
                parentIsAliased = true;
            }
        }
        if (parentIsAliased) {
            return false;
        }
        if (this.objectPrototypeProps.contains(name.getBaseName())) {
            return false;
        }
        if (name.parent.type == GlobalNamespace.Name.Type.OBJECTLIT || name.parent.type == GlobalNamespace.Name.Type.CLASS) {
            return true;
        }
        return name.parent.type == GlobalNamespace.Name.Type.FUNCTION && name.parent.isDeclaredType() && !this.functionPrototypeProps.contains(name.getBaseName());
    }
}

