/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Set;
import javax.annotation.Nullable;

final class CheckJSDoc
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    public static final DiagnosticType MISPLACED_MSG_ANNOTATION = DiagnosticType.disabled("JSC_MISPLACED_MSG_ANNOTATION", "Misplaced message annotation. @desc, @hidden, and @meaning annotations should only be on message nodes.");
    public static final DiagnosticType MISPLACED_ANNOTATION = DiagnosticType.warning("JSC_MISPLACED_ANNOTATION", "Misplaced {0} annotation. {1}");
    public static final DiagnosticType ANNOTATION_DEPRECATED = DiagnosticType.warning("JSC_ANNOTATION_DEPRECATED", "The {0} annotation is deprecated. {1}");
    public static final DiagnosticType DISALLOWED_MEMBER_JSDOC = DiagnosticType.warning("JSC_DISALLOWED_MEMBER_JSDOC", "Class level JSDocs (@interface, @extends, etc.) are not allowed on class members");
    static final DiagnosticType ARROW_FUNCTION_AS_CONSTRUCTOR = DiagnosticType.error("JSC_ARROW_FUNCTION_AS_CONSTRUCTOR", "Arrow functions cannot be used as constructors");
    static final DiagnosticType DEFAULT_PARAM_MUST_BE_MARKED_OPTIONAL = DiagnosticType.error("JSC_DEFAULT_PARAM_MUST_BE_MARKED_OPTIONAL", "Inline JSDoc on default parameters must be marked as optional");
    public static final DiagnosticType INVALID_NO_SIDE_EFFECT_ANNOTATION = DiagnosticType.error("JSC_INVALID_NO_SIDE_EFFECT_ANNOTATION", "@nosideeffects may only appear in externs files.");
    public static final DiagnosticType INVALID_MODIFIES_ANNOTATION = DiagnosticType.error("JSC_INVALID_MODIFIES_ANNOTATION", "@modifies may only appear in externs files.");
    public static final DiagnosticType INVALID_DEFINE_ON_LET = DiagnosticType.error("JSC_INVALID_DEFINE_ON_LET", "variables annotated with @define may only be declared with VARs, ASSIGNs, or CONSTs");
    public static final DiagnosticType MISPLACED_SUPPRESS = DiagnosticType.warning("JSC_MISPLACED_SUPPRESS", "@suppress annotation not allowed here. See https://github.com/google/closure-compiler/wiki/@suppress-annotations");
    private final AbstractCompiler compiler;

    CheckJSDoc(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo info = n.getJSDocInfo();
        this.validateTypeAnnotations(n, info);
        this.validateFunctionJsDoc(n, info);
        this.validateMsgJsDoc(n, info);
        this.validateDeprecatedJsDoc(n, info);
        this.validateNoCollapse(n, info);
        this.validateClassLevelJsDoc(n, info);
        this.validateArrowFunction(n);
        this.validateDefaultValue(n, info);
        this.validateTemplates(n, info);
        this.validateTypedefs(n, info);
        this.validateNoSideEffects(n, info);
        this.validateAbstractJsDoc(n, info);
        this.validateDefinesDeclaration(n, info);
        this.validateSuppress(n, info);
    }

    private void validateSuppress(Node n, JSDocInfo info) {
        if (info == null || info.getSuppressions().isEmpty()) {
            return;
        }
        switch (n.getToken()) {
            case FUNCTION: 
            case CLASS: 
            case VAR: 
            case LET: 
            case CONST: 
            case SCRIPT: 
            case MEMBER_FUNCTION_DEF: 
            case GETTER_DEF: 
            case SETTER_DEF: {
                return;
            }
            case STRING_KEY: {
                if (!n.getParent().isObjectLit()) break;
                return;
            }
            case ASSIGN: 
            case GETPROP: {
                if (!n.getParent().isExprResult()) break;
                return;
            }
            case CALL: {
                if (!CheckJSDoc.containsOnlySuppressionFor(info, "extraRequire") && !CheckJSDoc.containsOnlySuppressionFor(info, "extraProvide")) break;
                return;
            }
            case WITH: {
                if (!CheckJSDoc.containsOnlySuppressionFor(info, "with")) break;
                return;
            }
        }
        if (CheckJSDoc.containsOnlySuppressionFor(info, "missingRequire")) {
            return;
        }
        this.compiler.report(JSError.make(n, MISPLACED_SUPPRESS, new String[0]));
    }

    private static boolean containsOnlySuppressionFor(JSDocInfo jsdoc, String allowedSuppression) {
        Set<String> suppressions = jsdoc.getSuppressions();
        return suppressions.size() == 1 && ((String)Iterables.getOnlyElement(suppressions)).equals(allowedSuppression);
    }

    private void validateTypedefs(Node n, JSDocInfo info) {
        if (info != null && info.getTypedefType() != null && this.isClassDecl(n)) {
            this.reportMisplaced(n, "typedef", "@typedef does not make sense on a class declaration.");
        }
    }

    private void validateTemplates(Node n, JSDocInfo info) {
        if (!(info == null || info.getTemplateTypeNames().isEmpty() || info.isConstructorOrInterface() || this.isClassDecl(n) || info.containsFunctionDeclaration())) {
            if (this.getFunctionDecl(n) != null) {
                this.reportMisplaced(n, "template", "The template variable is unused. Please remove the @template annotation.");
            } else {
                this.reportMisplaced(n, "template", "@template is only allowed in class, constructor, interface, function or method declarations");
            }
        }
    }

    @Nullable
    private Node getFunctionDecl(Node n) {
        if (n.isFunction()) {
            return n;
        }
        if (n.isMemberFunctionDef()) {
            return n.getFirstChild();
        }
        if (NodeUtil.isNameDeclaration(n) && n.getFirstFirstChild() != null && n.getFirstFirstChild().isFunction()) {
            return n.getFirstFirstChild();
        }
        if (n.isAssign() && n.getFirstChild().isQualifiedName() && n.getLastChild().isFunction()) {
            return n.getLastChild();
        }
        if (n.isStringKey() && n.getGrandparent() != null && ClosureRewriteClass.isGoogDefineClass(n.getGrandparent()) && n.getFirstChild().isFunction()) {
            return n.getFirstChild();
        }
        if (n.isGetterDef() || n.isSetterDef()) {
            return n.getFirstChild();
        }
        return null;
    }

    private boolean isClassDecl(Node n) {
        return this.isClass(n) || n.isAssign() && this.isClass(n.getLastChild()) || NodeUtil.isNameDeclaration(n) && this.isNameInitializeWithClass(n.getFirstChild()) || this.isNameInitializeWithClass(n);
    }

    private boolean isNameInitializeWithClass(Node n) {
        return n != null && n.isName() && n.hasChildren() && this.isClass(n.getFirstChild());
    }

    private boolean isClass(Node n) {
        return n.isClass() || n.isCall() && this.compiler.getCodingConvention().isClassFactoryCall(n);
    }

    private void validateClassLevelJsDoc(Node n, JSDocInfo info) {
        if (info != null && n.isMemberFunctionDef() && this.hasClassLevelJsDoc(info)) {
            this.report(n, DISALLOWED_MEMBER_JSDOC, new String[0]);
        }
    }

    private void validateAbstractJsDoc(Node n, JSDocInfo info) {
        if (info == null || !info.isAbstract()) {
            return;
        }
        if (this.isClassDecl(n)) {
            return;
        }
        Node functionNode = this.getFunctionDecl(n);
        if (functionNode == null) {
            this.report(n, MISPLACED_ANNOTATION, "@abstract", "only functions or non-static methods can be abstract");
            return;
        }
        if (!info.isConstructor() && NodeUtil.getFunctionBody(functionNode).hasChildren()) {
            this.report(n, MISPLACED_ANNOTATION, "@abstract", "function with a non-empty body cannot be abstract");
            return;
        }
        if ((n.isMemberFunctionDef() || n.isStringKey()) && "constructor".equals(n.getString())) {
            this.report(n, MISPLACED_ANNOTATION, "@abstract", "constructors cannot be abstract");
            return;
        }
        if (!(info.isConstructor() || n.isMemberFunctionDef() || n.isStringKey() || n.isGetterDef() || n.isSetterDef() || NodeUtil.isPrototypeMethod(functionNode))) {
            this.report(n, MISPLACED_ANNOTATION, "@abstract", "only functions or non-static methods can be abstract");
            return;
        }
        if (n.isStaticMember()) {
            this.report(n, MISPLACED_ANNOTATION, "@abstract", "static methods cannot be abstract");
            return;
        }
    }

    private boolean hasClassLevelJsDoc(JSDocInfo info) {
        return info.isConstructorOrInterface() || info.hasBaseType() || info.getImplementedInterfaceCount() != 0 || info.getExtendedInterfacesCount() != 0;
    }

    private void validateDeprecatedJsDoc(Node n, JSDocInfo info) {
        if (info != null && info.isExpose()) {
            this.report(n, ANNOTATION_DEPRECATED, "@expose", "Use @nocollapse or @export instead.");
        }
    }

    private void validateNoCollapse(Node n, JSDocInfo info) {
        if (n.isFromExterns()) {
            if (info != null && info.isNoCollapse()) {
                this.reportMisplaced(n, "nocollapse", "This JSDoc has no effect in externs.");
            }
            return;
        }
        if (!NodeUtil.isPrototypePropertyDeclaration(n.getParent())) {
            return;
        }
        JSDocInfo jsdoc = n.getJSDocInfo();
        if (jsdoc != null && jsdoc.isNoCollapse()) {
            this.reportMisplaced(n, "nocollapse", "This JSDoc has no effect on prototype properties.");
        }
    }

    private void validateFunctionJsDoc(Node n, JSDocInfo info) {
        if (info == null) {
            return;
        }
        if (info.containsFunctionDeclaration() && !info.hasType()) {
            switch (n.getToken()) {
                case FUNCTION: 
                case MEMBER_FUNCTION_DEF: 
                case GETTER_DEF: 
                case SETTER_DEF: 
                case STRING_KEY: 
                case COMPUTED_PROP: 
                case EXPORT: {
                    return;
                }
                case GETPROP: 
                case GETELEM: {
                    if (!n.getFirstChild().isQualifiedName()) break;
                    return;
                }
                case VAR: 
                case LET: 
                case CONST: 
                case ASSIGN: {
                    Node lhs = n.getFirstChild();
                    Node rhs = NodeUtil.getRValueOfLValue(lhs);
                    if (rhs != null && this.isClass(rhs) && !info.isConstructor()) break;
                    return;
                }
            }
            this.reportMisplaced(n, "function", "This JSDoc is not attached to a function node. Are you missing parentheses?");
        }
    }

    private void validateMsgJsDoc(Node n, JSDocInfo info) {
        if (info == null) {
            return;
        }
        if (info.getDescription() != null || info.isHidden() || info.getMeaning() != null) {
            boolean descOkay = false;
            switch (n.getToken()) {
                case VAR: 
                case LET: 
                case CONST: 
                case ASSIGN: {
                    descOkay = this.isValidMsgName(n.getFirstChild());
                    break;
                }
                case STRING_KEY: {
                    descOkay = this.isValidMsgName(n);
                    break;
                }
                case GETPROP: {
                    if (!n.isFromExterns() || !n.isQualifiedName()) break;
                    descOkay = this.isValidMsgName(n);
                    break;
                }
            }
            if (!descOkay) {
                this.report(n, MISPLACED_MSG_ANNOTATION, new String[0]);
            }
        }
    }

    private boolean isValidMsgName(Node nameNode) {
        if (nameNode.isName() || nameNode.isStringKey()) {
            return nameNode.getString().startsWith("MSG_");
        }
        Preconditions.checkState((boolean)nameNode.isQualifiedName());
        return nameNode.getLastChild().getString().startsWith("MSG_");
    }

    private void validateTypeAnnotations(Node n, JSDocInfo info) {
        if (info != null && info.hasType()) {
            boolean valid = false;
            block0 : switch (n.getToken()) {
                case FUNCTION: {
                    valid = NodeUtil.isFunctionDeclaration(n);
                    break;
                }
                case NAME: 
                case DEFAULT_VALUE: 
                case ARRAY_PATTERN: 
                case OBJECT_PATTERN: {
                    Node parent = n.getParent();
                    switch (parent.getToken()) {
                        case FUNCTION: 
                        case VAR: 
                        case LET: 
                        case CONST: 
                        case GETTER_DEF: 
                        case SETTER_DEF: 
                        case CATCH: 
                        case PARAM_LIST: {
                            valid = true;
                            break block0;
                        }
                    }
                    break;
                }
                case VAR: 
                case LET: 
                case CONST: 
                case GETTER_DEF: 
                case SETTER_DEF: 
                case STRING_KEY: 
                case EXPORT: 
                case CAST: {
                    valid = true;
                    break;
                }
                case ASSIGN: {
                    Node lvalue = n.getFirstChild();
                    valid = n.getParent().isExprResult() && (lvalue.isGetProp() || lvalue.isGetElem() || lvalue.matchesQualifiedName("exports"));
                    break;
                }
                case GETPROP: {
                    valid = n.getParent().isExprResult() && n.isQualifiedName();
                    break;
                }
                case CALL: {
                    valid = info.isDefine();
                    break;
                }
            }
            if (!valid) {
                this.reportMisplaced(n, "type", "Type annotations are not allowed here. Are you missing parentheses?");
            }
        }
    }

    private void reportMisplaced(Node n, String annotationName, String note) {
        this.compiler.report(JSError.make(n, MISPLACED_ANNOTATION, annotationName, note));
    }

    private void report(Node n, DiagnosticType type, String ... arguments) {
        this.compiler.report(JSError.make(n, type, arguments));
    }

    private void validateArrowFunction(Node n) {
        JSDocInfo info;
        if (n.isArrowFunction() && (info = NodeUtil.getBestJSDocInfo(n)) != null && info.isConstructorOrInterface()) {
            this.report(n, ARROW_FUNCTION_AS_CONSTRUCTOR, new String[0]);
        }
    }

    private void validateDefaultValue(Node n, JSDocInfo info) {
        if (n.isDefaultValue() && n.getParent().isParamList() && info != null) {
            JSTypeExpression typeExpr = info.getType();
            if (typeExpr == null) {
                return;
            }
            Node typeNode = typeExpr.getRoot();
            if (typeNode.getToken() != Token.EQUALS) {
                this.report(typeNode, DEFAULT_PARAM_MUST_BE_MARKED_OPTIONAL, new String[0]);
            }
        }
    }

    private void validateNoSideEffects(Node n, JSDocInfo info) {
        if (info == null) {
            return;
        }
        if (n.isFromExterns()) {
            return;
        }
        if (info.hasSideEffectsArgumentsAnnotation() || info.modifiesThis()) {
            this.report(n, INVALID_MODIFIES_ANNOTATION, new String[0]);
        }
        if (info.isNoSideEffects()) {
            this.report(n, INVALID_NO_SIDE_EFFECT_ANNOTATION, new String[0]);
        }
    }

    private void validateDefinesDeclaration(Node n, JSDocInfo info) {
        if (info != null && info.isDefine() && n.isLet()) {
            this.report(n, INVALID_DEFINE_ON_LET, new String[0]);
        }
    }
}

