/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

final class CheckSuper
implements HotSwapCompilerPass,
NodeTraversal.Callback {
    static final DiagnosticType MISSING_CALL_TO_SUPER = DiagnosticType.error("JSC_MISSING_CALL_TO_SUPER", "constructor is missing a call to super()");
    static final DiagnosticType THIS_BEFORE_SUPER = DiagnosticType.error("JSC_THIS_BEFORE_SUPER", "cannot access this before calling super()");
    static final DiagnosticType INVALID_SUPER_CALL = DiagnosticType.error("JSC_INVALID_SUPER_CALL", "super() not allowed except in the constructor of a subclass");
    static final DiagnosticType INVALID_SUPER_CALL_WITH_SUGGESTION = DiagnosticType.error("JSC_INVALID_SUPER_CALL_WITH_SUGGESTION", "super() not allowed here. Did you mean super.{0}?");
    private final AbstractCompiler compiler;

    public CheckSuper(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isClass()) {
            return this.visitClass(t, n);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isSuper()) {
            this.visitSuper(t, n, parent);
        }
    }

    private boolean visitClass(NodeTraversal t, Node n) {
        Node superclass = n.getSecondChild();
        if (superclass.isEmpty()) {
            return true;
        }
        Node constructor = NodeUtil.getFirstPropMatchingKey(NodeUtil.getClassMembers(n), "constructor");
        if (constructor == null) {
            return true;
        }
        FindSuper finder = new FindSuper();
        NodeTraversal.traverseEs6(this.compiler, NodeUtil.getFunctionBody(constructor), finder);
        if (!finder.found) {
            t.report(constructor, MISSING_CALL_TO_SUPER, new String[0]);
            return false;
        }
        return true;
    }

    private void visitSuper(NodeTraversal t, Node n, Node parent) {
        Node classNode = NodeUtil.getEnclosingClass(n);
        if (classNode == null || classNode.getSecondChild().isEmpty()) {
            t.report(n, INVALID_SUPER_CALL, new String[0]);
            return;
        }
        if (parent.isCall()) {
            Node fn = NodeUtil.getEnclosingFunction(parent);
            if (fn == null) {
                t.report(n, INVALID_SUPER_CALL, new String[0]);
                return;
            }
            Node memberDef = fn.getParent();
            if (memberDef.isMemberFunctionDef()) {
                if (!memberDef.matchesQualifiedName("constructor")) {
                    t.report(n, INVALID_SUPER_CALL_WITH_SUGGESTION, memberDef.getString());
                }
            } else {
                t.report(n, INVALID_SUPER_CALL, new String[0]);
            }
        }
    }

    private static final class FindSuper
    implements NodeTraversal.Callback {
        boolean found = false;

        private FindSuper() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return !this.found && !n.isFunction();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isThis()) {
                t.report(n, THIS_BEFORE_SUPER, new String[0]);
            }
            if (n.isSuper() && parent.isCall()) {
                this.found = true;
                return;
            }
        }
    }
}

