/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ClosureCheckModule
extends NodeTraversal.AbstractModuleCallback
implements HotSwapCompilerPass {
    static final DiagnosticType AT_EXPORT_IN_GOOG_MODULE = DiagnosticType.error("JSC_AT_EXPORT_IN_GOOG_MODULE", "@export has no effect here");
    static final DiagnosticType AT_EXPORT_IN_NON_LEGACY_GOOG_MODULE = DiagnosticType.error("JSC_AT_EXPORT_IN_NON_LEGACY_GOOG_MODULE", "@export is not allowed here in a non-legacy goog.module. Consider using goog.exportSymbol instead.");
    static final DiagnosticType GOOG_MODULE_IN_NON_MODULE = DiagnosticType.error("JSC_GOOG_MODULE_IN_NON_MODULE", "goog.module() call must be the first statement in a module.");
    static final DiagnosticType GOOG_MODULE_REFERENCES_THIS = DiagnosticType.error("JSC_GOOG_MODULE_REFERENCES_THIS", "The body of a goog.module cannot reference 'this'.");
    static final DiagnosticType GOOG_MODULE_USES_THROW = DiagnosticType.error("JSC_GOOG_MODULE_USES_THROW", "The body of a goog.module cannot use 'throw'.");
    static final DiagnosticType GOOG_MODULE_USES_GOOG_MODULE_GET = DiagnosticType.error("JSC_GOOG_MODULE_USES_GOOG_MODULE_GET", "It's illegal to use a 'goog.module.get' at the module top-level. Did you mean to use goog.require instead?");
    static final DiagnosticType DUPLICATE_NAME_SHORT_REQUIRE = DiagnosticType.error("JSC_DUPLICATE_NAME_SHORT_REQUIRE", "Found multiple goog.require statements importing identifier ''{0}''.");
    static final DiagnosticType INVALID_DESTRUCTURING_REQUIRE = DiagnosticType.error("JSC_INVALID_DESTRUCTURING_REQUIRE", "Destructuring goog.require must be a simple object pattern.");
    static final DiagnosticType INVALID_DESTRUCTURING_FORWARD_DECLARE = DiagnosticType.error("JSC_INVALID_DESTRUCTURING_FORWARD_DECLARE", "Cannot destructure a forward-declared type");
    static final DiagnosticType LET_GOOG_REQUIRE = DiagnosticType.disabled("JSC_LET_GOOG_REQUIRE", "Module imports must be constant. Please use 'const' instead of 'let'.");
    static final DiagnosticType MULTIPLE_MODULES_IN_FILE = DiagnosticType.error("JSC_MULTIPLE_MODULES_IN_FILE", "There should only be a single goog.module() statement per file.");
    static final DiagnosticType MODULE_AND_PROVIDES = DiagnosticType.error("JSC_MODULE_AND_PROVIDES", "A file using goog.module() may not also use goog.provide() statements.");
    static final DiagnosticType ONE_REQUIRE_PER_DECLARATION = DiagnosticType.error("JSC_ONE_REQUIRE_PER_DECLARATION", "There may only be one goog.require() per var/let/const declaration.");
    static final DiagnosticType INCORRECT_SHORTNAME_CAPITALIZATION = DiagnosticType.disabled("JSC_INCORRECT_SHORTNAME_CAPITALIZATION", "The capitalization of short name {0} is incorrect; it should be {1}.");
    static final DiagnosticType EXPORT_NOT_A_MODULE_LEVEL_STATEMENT = DiagnosticType.error("JSC_EXPORT_NOT_A_MODULE_LEVEL_STATEMENT", "Exports must be a statement at the top-level of a module");
    static final DiagnosticType EXPORT_REPEATED_ERROR = DiagnosticType.error("JSC_EXPORT_REPEATED_ERROR", "Name cannot be exported multiple times. Previous export on line {0}.");
    static final DiagnosticType REFERENCE_TO_MODULE_GLOBAL_NAME = DiagnosticType.error("JSC_REFERENCE_TO_MODULE_GLOBAL_NAME", "References to the global name of a module are not allowed. Perhaps you meant exports?");
    static final DiagnosticType REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME = DiagnosticType.disabled("JSC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME", "Reference to fully qualified import name ''{0}''. Imports in goog.module should use the return value of goog.require / goog.forwardDeclare instead.");
    public static final DiagnosticType REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME = DiagnosticType.disabled("JSC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME", "Reference to fully qualified import name ''{0}''. Please use the short name ''{1}'' instead.");
    static final DiagnosticType JSDOC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME = DiagnosticType.disabled("JSC_JSDOC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME", "Reference to fully qualified import name ''{0}'' in JSDoc. Imports in goog.module should use the return value of goog.require / goog.forwardDeclare instead.");
    public static final DiagnosticType JSDOC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME = DiagnosticType.disabled("JSC_JSDOC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME", "Reference to fully qualified import name ''{0}'' in JSDoc. Please use the short name ''{1}'' instead.");
    static final DiagnosticType REQUIRE_NOT_AT_TOP_LEVEL = DiagnosticType.error("JSC_REQUIRE_NOT_AT_TOP_LEVEL", "goog.require() must be called at file scope.");
    private final AbstractCompiler compiler;
    private ModuleInfo currentModule = null;

    public ClosureCheckModule(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void enterModule(NodeTraversal t, Node scopeRoot) {
        Node call;
        Node callee;
        Node firstStatement = scopeRoot.getFirstChild();
        if (NodeUtil.isExprCall(firstStatement) && (callee = (call = firstStatement.getFirstChild()).getFirstChild()).matchesQualifiedName("goog.module")) {
            Preconditions.checkState((this.currentModule == null ? 1 : 0) != 0);
            String moduleName = this.extractFirstArgumentName(call);
            if (moduleName == null) {
                t.report(scopeRoot, ClosureRewriteModule.INVALID_MODULE_NAMESPACE, new String[0]);
            } else {
                this.currentModule = new ModuleInfo(moduleName);
            }
        }
    }

    @Override
    public void exitModule(NodeTraversal t, Node scopeRoot) {
        this.currentModule = null;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.currentModule == null) {
            if (NodeUtil.isCallTo(n, "goog.module")) {
                t.report(n, GOOG_MODULE_IN_NON_MODULE, new String[0]);
            }
            return;
        }
        JSDocInfo jsDoc = n.getJSDocInfo();
        if (jsDoc != null) {
            this.checkJSDoc(t, jsDoc);
        }
        switch (n.getToken()) {
            case CALL: {
                Node callee = n.getFirstChild();
                if (callee.matchesQualifiedName("goog.module") && !this.currentModule.name.equals(this.extractFirstArgumentName(n))) {
                    t.report(n, MULTIPLE_MODULES_IN_FILE, new String[0]);
                    break;
                }
                if (callee.matchesQualifiedName("goog.provide")) {
                    t.report(n, MODULE_AND_PROVIDES, new String[0]);
                    break;
                }
                if (callee.matchesQualifiedName("goog.require") || callee.matchesQualifiedName("goog.forwardDeclare")) {
                    this.checkRequireCall(t, n, parent);
                    break;
                }
                if (!callee.matchesQualifiedName("goog.module.get") || !t.inModuleHoistScope()) break;
                t.report(n, GOOG_MODULE_USES_GOOG_MODULE_GET, new String[0]);
                break;
            }
            case ASSIGN: {
                if (!this.isExportLhs(n.getFirstChild())) break;
                this.checkModuleExport(t, n, parent);
                break;
            }
            case CLASS: 
            case FUNCTION: {
                if (!NodeUtil.isStatement(n)) break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                JSDocInfo jsdoc;
                if (!t.inModuleHoistScope() || !n.isClass() && NodeUtil.getEnclosingClass(n) != null || NodeUtil.getEnclosingType(n, Token.OBJECTLIT) != null || (jsdoc = NodeUtil.getBestJSDocInfo(n)) == null || !jsdoc.isExport()) break;
                t.report(n, AT_EXPORT_IN_GOOG_MODULE, new String[0]);
                break;
            }
            case THIS: {
                if (!t.inModuleHoistScope()) break;
                t.report(n, GOOG_MODULE_REFERENCES_THIS, new String[0]);
                break;
            }
            case THROW: {
                if (!t.inModuleHoistScope()) break;
                t.report(n, GOOG_MODULE_USES_THROW, new String[0]);
                break;
            }
            case GETPROP: {
                if (n.matchesQualifiedName(this.currentModule.name)) {
                    t.report(n, REFERENCE_TO_MODULE_GLOBAL_NAME, new String[0]);
                    break;
                }
                if (!this.currentModule.importsByLongRequiredName.containsKey(n.getQualifiedName())) break;
                Node importLhs = (Node)this.currentModule.importsByLongRequiredName.get(n.getQualifiedName());
                if (importLhs == null) {
                    t.report(n, REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, n.getQualifiedName());
                    break;
                }
                if (importLhs.isName()) {
                    t.report(n, REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, n.getQualifiedName(), importLhs.getString());
                    break;
                }
                if (importLhs.isDestructuringLhs()) {
                    if (parent.isGetProp()) {
                        String shortName = parent.getQualifiedName().substring(parent.getQualifiedName().lastIndexOf(46) + 1);
                        Node objPattern = importLhs.getFirstChild();
                        Preconditions.checkState((boolean)objPattern.isObjectPattern(), (Object)objPattern);
                        for (Node strKey : objPattern.children()) {
                            if (!strKey.hasChildren() && strKey.getString().equals(shortName)) {
                                t.report(parent, REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, parent.getQualifiedName(), shortName);
                                return;
                            }
                            if (!strKey.hasOneChild() || !strKey.getString().equals(shortName)) continue;
                            t.report(parent, REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, parent.getQualifiedName(), strKey.getFirstChild().getString());
                            return;
                        }
                    }
                    t.report(n, REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, n.getQualifiedName());
                    break;
                }
                Preconditions.checkState((boolean)importLhs.isExprResult(), (Object)importLhs);
                t.report(n, REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, n.getQualifiedName());
                break;
            }
        }
    }

    private void checkJSDoc(NodeTraversal t, JSDocInfo jsDoc) {
        for (Node typeNode : jsDoc.getTypeNodes()) {
            this.checkTypeExpression(t, typeNode);
        }
    }

    private void checkTypeExpression(final NodeTraversal t, Node typeNode) {
        NodeUtil.visitPreOrder(typeNode, new NodeUtil.Visitor(){

            @Override
            public void visit(Node node) {
                if (!node.isString()) {
                    return;
                }
                String type = node.getString();
                while (true) {
                    if (ClosureCheckModule.this.currentModule.importsByLongRequiredName.containsKey(type)) {
                        Node importLhs = (Node)ClosureCheckModule.this.currentModule.importsByLongRequiredName.get(type);
                        if (importLhs == null || !importLhs.isName()) {
                            t.report(node, JSDOC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, type);
                        } else if (!importLhs.getString().equals(type)) {
                            t.report(node, JSDOC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, type, importLhs.getString());
                        }
                    }
                    if (!type.contains(".")) break;
                    type = type.substring(0, type.lastIndexOf(46));
                }
            }
        });
    }

    private boolean isExportLhs(Node lhs) {
        if (!lhs.isQualifiedName()) {
            return false;
        }
        return lhs.matchesQualifiedName("exports") || lhs.isGetProp() && lhs.getFirstChild().matchesQualifiedName("exports");
    }

    private void checkModuleExport(NodeTraversal t, Node n, Node parent) {
        JSDocInfo jsDoc;
        Preconditions.checkArgument((boolean)n.isAssign());
        Node lhs = n.getFirstChild();
        Preconditions.checkState((boolean)this.isExportLhs(lhs));
        if (!(this.currentModule.defaultExportNode != null || t.inModuleScope() && parent.isExprResult())) {
            t.report(n, EXPORT_NOT_A_MODULE_LEVEL_STATEMENT, new String[0]);
        }
        if (lhs.isName()) {
            if (this.currentModule.defaultExportNode != null) {
                int previousLine = this.currentModule.defaultExportNode.getLineno();
                t.report(n, EXPORT_REPEATED_ERROR, String.valueOf(previousLine));
            }
            this.currentModule.defaultExportNode = lhs;
        }
        if ((lhs.isName() || !NodeUtil.isPrototypeProperty(lhs)) && !NodeUtil.isLegacyGoogModuleFile(NodeUtil.getEnclosingScript(n)) && (jsDoc = n.getJSDocInfo()) != null && jsDoc.isExport()) {
            t.report(n, AT_EXPORT_IN_NON_LEGACY_GOOG_MODULE, new String[0]);
        }
    }

    private String extractFirstArgumentName(Node callNode) {
        Node firstArg = callNode.getSecondChild();
        if (firstArg != null && firstArg.isString()) {
            return firstArg.getString();
        }
        return null;
    }

    private void checkRequireCall(NodeTraversal t, Node callNode, Node parent) {
        Preconditions.checkState((boolean)callNode.isCall());
        if (!callNode.getLastChild().isString()) {
            t.report(callNode, ProcessClosurePrimitives.INVALID_ARGUMENT_ERROR, "goog.require");
            return;
        }
        switch (parent.getToken()) {
            case EXPR_RESULT: {
                String key = this.extractFirstArgumentName(callNode);
                if (!this.currentModule.importsByLongRequiredName.containsKey(key)) {
                    this.currentModule.importsByLongRequiredName.put(key, parent);
                }
                return;
            }
            case NAME: 
            case DESTRUCTURING_LHS: {
                this.checkShortGoogRequireCall(t, callNode, parent.getParent());
                return;
            }
        }
        t.report(callNode, REQUIRE_NOT_AT_TOP_LEVEL, new String[0]);
    }

    private void checkShortGoogRequireCall(NodeTraversal t, Node callNode, Node declaration) {
        if (declaration.isLet() && !callNode.getFirstChild().matchesQualifiedName("goog.forwardDeclare")) {
            t.report(declaration, LET_GOOG_REQUIRE, new String[0]);
        }
        if (!declaration.hasOneChild()) {
            t.report(declaration, ONE_REQUIRE_PER_DECLARATION, new String[0]);
            return;
        }
        Node lhs = declaration.getFirstChild();
        if (lhs.isDestructuringLhs()) {
            if (!ClosureCheckModule.isValidDestructuringImport(lhs)) {
                t.report(declaration, INVALID_DESTRUCTURING_REQUIRE, new String[0]);
            }
            if (callNode.getFirstChild().matchesQualifiedName("goog.forwardDeclare")) {
                t.report(lhs, INVALID_DESTRUCTURING_FORWARD_DECLARE, new String[0]);
            }
        } else {
            Preconditions.checkState((boolean)lhs.isName());
            ClosureCheckModule.checkShortName(t, lhs, callNode.getLastChild().getString());
        }
        this.currentModule.importsByLongRequiredName.put(this.extractFirstArgumentName(callNode), lhs);
        for (Node nameNode : NodeUtil.findLhsNodesInNode(declaration)) {
            String name = nameNode.getString();
            if (this.currentModule.shortImportNames.add(name)) continue;
            t.report(nameNode, DUPLICATE_NAME_SHORT_REQUIRE, name);
        }
    }

    private static void checkShortName(NodeTraversal t, Node shortNameNode, String namespace) {
        String lastSegment;
        String shortName = shortNameNode.getString();
        if (shortName.equals(lastSegment = namespace.substring(namespace.lastIndexOf(46) + 1)) || lastSegment.isEmpty()) {
            return;
        }
        if (Ascii.isUpperCase((char)shortName.charAt(0)) != Ascii.isUpperCase((char)lastSegment.charAt(0))) {
            char newStartChar = Ascii.isUpperCase((char)shortName.charAt(0)) ? Ascii.toLowerCase((char)shortName.charAt(0)) : Ascii.toUpperCase((char)shortName.charAt(0));
            String correctedName = newStartChar + shortName.substring(1);
            t.report(shortNameNode, INCORRECT_SHORTNAME_CAPITALIZATION, shortName, correctedName);
        }
    }

    private static boolean isValidDestructuringImport(Node destructuringLhs) {
        Preconditions.checkArgument((boolean)destructuringLhs.isDestructuringLhs());
        Node objectPattern = destructuringLhs.getFirstChild();
        if (!objectPattern.isObjectPattern()) {
            return false;
        }
        for (Node stringKey : objectPattern.children()) {
            if (!stringKey.isStringKey()) {
                return false;
            }
            if (!stringKey.hasChildren() || stringKey.getFirstChild().isName()) continue;
            return false;
        }
        return true;
    }

    private static class ModuleInfo {
        private final String name;
        private final Map<String, Node> importsByLongRequiredName = new HashMap<String, Node>();
        private final Set<String> shortImportNames = new HashSet<String>();
        private Node defaultExportNode = null;

        ModuleInfo(String moduleName) {
            this.name = moduleName;
        }
    }
}

