/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractVar;
import com.google.javascript.jscomp.Es6RenameReferences;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class Es6RewriteBlockScopedDeclaration
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final Table<Node, String, String> renameTable = HashBasedTable.create();
    private final Set<Node> letConsts = new HashSet<Node>();
    private final Set<String> undeclaredNames = new HashSet<String>();
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.LET_DECLARATIONS, FeatureSet.Feature.CONST_DECLARATIONS);
    private static final Predicate<Node> isLoopOrFunction = new Predicate<Node>(){

        public boolean apply(Node n) {
            return n.isFunction() || NodeUtil.isLoopStructure(n);
        }
    };

    public Es6RewriteBlockScopedDeclaration(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Scope hoistScope;
        if (!n.hasChildren() || !NodeUtil.isBlockScopedDeclaration(n.getFirstChild())) {
            return;
        }
        Scope scope = t.getScope();
        Node nameNode = n.getFirstChild();
        if (!(n.isClass() || n.isFunction() || nameNode.hasChildren() || parent != null && NodeUtil.isEnhancedFor(parent) || n.isCatch() || !this.inLoop(n))) {
            Node undefined = IR.name("undefined");
            if (nameNode.getJSDocInfo() != null || n.getJSDocInfo() != null) {
                JSDocInfoBuilder jsDoc = new JSDocInfoBuilder(false);
                jsDoc.recordType(new JSTypeExpression(new Node(Token.QMARK), n.getSourceFileName()));
                undefined = IR.cast(undefined, jsDoc.build());
            }
            undefined.useSourceInfoFromForTree(nameNode);
            nameNode.addChildToFront(undefined);
            this.compiler.reportChangeToEnclosingScope(undefined);
        }
        String oldName = nameNode.getString();
        if (n.isLet() || n.isConst()) {
            this.letConsts.add(n);
        }
        if (scope != (hoistScope = (Scope)scope.getClosestHoistScope())) {
            String newName = oldName;
            if (hoistScope.hasSlot(oldName) || this.undeclaredNames.contains(oldName)) {
                while (hoistScope.hasSlot(newName = oldName + "$" + (String)this.compiler.getUniqueNameIdSupplier().get())) {
                }
                nameNode.setString(newName);
                this.compiler.reportChangeToEnclosingScope(nameNode);
                Node scopeRoot = scope.getRootNode();
                this.renameTable.put((Object)scopeRoot, (Object)oldName, (Object)newName);
            }
            Var oldVar = (Var)scope.getVar(oldName);
            scope.undeclare(oldVar);
            hoistScope.declare(newName, nameNode, oldVar.input);
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, new CollectUndeclaredNames());
        NodeTraversal.traverseEs6(this.compiler, root, this);
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        NodeTraversal.traverseEs6(this.compiler, root, new Es6RenameReferences(this.renameTable));
        LoopClosureTransformer transformer = new LoopClosureTransformer();
        NodeTraversal.traverseEs6(this.compiler, root, transformer);
        transformer.transformLoopClosure();
        this.rewriteDeclsToVars();
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, new CollectUndeclaredNames());
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, new Es6RenameReferences(this.renameTable));
        LoopClosureTransformer transformer = new LoopClosureTransformer();
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, transformer);
        transformer.transformLoopClosure();
        this.rewriteDeclsToVars();
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    private boolean inLoop(Node n) {
        Node enclosingNode = NodeUtil.getEnclosingNode(n, isLoopOrFunction);
        return enclosingNode != null && !enclosingNode.isFunction();
    }

    private static void extractInlineJSDoc(Node srcDeclaration, Node srcName, Node destDeclaration) {
        JSDocInfo existingInfo = srcDeclaration.getJSDocInfo();
        if (existingInfo == null) {
            existingInfo = srcName.getJSDocInfo();
            srcName.setJSDocInfo(null);
        }
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(existingInfo);
        destDeclaration.setJSDocInfo(builder.build());
    }

    private static void maybeAddConstJSDoc(Node srcDeclaration, Node srcParent, Node srcName, Node destDeclaration) {
        if (srcDeclaration.isConst() && (!srcParent.isForIn() || srcDeclaration != srcParent.getFirstChild())) {
            Es6RewriteBlockScopedDeclaration.extractInlineJSDoc(srcDeclaration, srcName, destDeclaration);
            JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(destDeclaration.getJSDocInfo());
            builder.recordConstancy();
            destDeclaration.setJSDocInfo(builder.build());
        }
    }

    private void handleDeclarationList(Node declarationList, Node parent) {
        while (declarationList.hasMoreThanOneChild()) {
            Node name = declarationList.getLastChild();
            Node newDeclaration = IR.var(name.detach()).useSourceInfoFrom(declarationList);
            Es6RewriteBlockScopedDeclaration.maybeAddConstJSDoc(declarationList, parent, name, newDeclaration);
            parent.addChildAfter(newDeclaration, declarationList);
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        Es6RewriteBlockScopedDeclaration.maybeAddConstJSDoc(declarationList, parent, declarationList.getFirstChild(), declarationList);
        declarationList.setToken(Token.VAR);
    }

    private void addNodeBeforeLoop(Node newNode, Node loopNode) {
        Node insertSpot = loopNode;
        while (insertSpot.getParent().isLabel()) {
            insertSpot = insertSpot.getParent();
        }
        insertSpot.getParent().addChildBefore(newNode, insertSpot);
        this.compiler.reportChangeToEnclosingScope(newNode);
    }

    private void rewriteDeclsToVars() {
        if (!this.letConsts.isEmpty()) {
            for (Node n : this.letConsts) {
                if (n.isConst()) {
                    this.handleDeclarationList(n, n.getParent());
                }
                n.setToken(Token.VAR);
                this.compiler.reportChangeToEnclosingScope(n);
            }
        }
    }

    private class LoopClosureTransformer
    extends NodeTraversal.AbstractPostOrderCallback {
        private static final String LOOP_OBJECT_NAME = "$jscomp$loop";
        private final Map<Node, LoopObject> loopObjectMap = new LinkedHashMap<Node, LoopObject>();
        private final Multimap<Node, LoopObject> functionLoopObjectsMap = LinkedHashMultimap.create();
        private final Multimap<Node, String> functionHandledMap = HashMultimap.create();
        private final Multimap<Var, Node> referenceMap = LinkedHashMultimap.create();

        private LoopClosureTransformer() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            String name = n.getString();
            Scope referencedIn = t.getScope();
            Var var = (Var)referencedIn.getVar(name);
            if (var == null) {
                return;
            }
            if (!var.isLet() && !var.isConst()) {
                return;
            }
            if (n.getParent().isLet() || n.getParent().isConst()) {
                Es6RewriteBlockScopedDeclaration.this.letConsts.add(n.getParent());
            }
            Scope declaredIn = (Scope)var.getScope();
            Node loopNode = null;
            Scope s = declaredIn;
            while (true) {
                Node scopeRoot = s.getRootNode();
                if (NodeUtil.isLoopStructure(s.getRootNode())) {
                    loopNode = scopeRoot;
                    break;
                }
                if (scopeRoot.getParent() != null && NodeUtil.isLoopStructure(scopeRoot.getParent())) {
                    loopNode = scopeRoot.getParent();
                    break;
                }
                if (s.isFunctionBlockScope() || s.isGlobal()) {
                    return;
                }
                s = (Scope)s.getParent();
            }
            this.referenceMap.put((Object)var, (Object)n);
            Scope outerMostFunctionScope = null;
            for (Scope s2 = referencedIn; s2 != declaredIn && s2.getRootNode() != loopNode; s2 = (Scope)s2.getParent()) {
                if (!s2.isFunctionScope()) continue;
                outerMostFunctionScope = s2;
            }
            if (outerMostFunctionScope != null) {
                Node function = outerMostFunctionScope.getRootNode();
                if (this.functionHandledMap.containsEntry((Object)function, (Object)name)) {
                    return;
                }
                this.functionHandledMap.put((Object)function, (Object)name);
                if (!this.loopObjectMap.containsKey(loopNode)) {
                    this.loopObjectMap.put(loopNode, new LoopObject("$jscomp$loop$" + (String)Es6RewriteBlockScopedDeclaration.this.compiler.getUniqueNameIdSupplier().get()));
                }
                LoopObject object = this.loopObjectMap.get(loopNode);
                object.vars.add(var);
                this.functionLoopObjectsMap.put((Object)function, (Object)object);
            }
        }

        private void transformLoopClosure() {
            if (this.loopObjectMap.isEmpty()) {
                return;
            }
            for (Node loopNode : this.loopObjectMap.keySet()) {
                LoopObject loopObject = this.loopObjectMap.get(loopNode);
                Node objectLitNextIteration = IR.objectlit(new Node[0]);
                for (Var var : loopObject.vars) {
                    objectLitNextIteration.addChildToBack(IR.stringKey(var.name, IR.getprop(IR.name(loopObject.name), IR.string(var.name))));
                }
                Node updateLoopObject = IR.assign(IR.name(loopObject.name), objectLitNextIteration);
                Node objectLit = IR.var(IR.name(loopObject.name), IR.objectlit(new Node[0])).useSourceInfoFromForTree(loopNode);
                Es6RewriteBlockScopedDeclaration.this.addNodeBeforeLoop(objectLit, loopNode);
                if (loopNode.isVanillaFor()) {
                    Node increment;
                    Node initializer = loopNode.getFirstChild();
                    loopNode.replaceChild(initializer, IR.empty());
                    if (!initializer.isEmpty()) {
                        if (!NodeUtil.isNameDeclaration(initializer)) {
                            initializer = IR.exprResult(initializer).useSourceInfoFrom(initializer);
                        }
                        Es6RewriteBlockScopedDeclaration.this.addNodeBeforeLoop(initializer, loopNode);
                    }
                    if ((increment = loopNode.getChildAtIndex(2)).isEmpty()) {
                        loopNode.replaceChild(increment, updateLoopObject.useSourceInfoIfMissingFromForTree(loopNode));
                    } else {
                        Node placeHolder = IR.empty();
                        loopNode.replaceChild(increment, placeHolder);
                        loopNode.replaceChild(placeHolder, IR.comma(updateLoopObject, increment).useSourceInfoIfMissingFromForTree(loopNode));
                    }
                } else {
                    String innerBlockLabel = loopObject.name;
                    Node loopBody = NodeUtil.getLoopCodeBlock(loopNode);
                    if (this.maybeUpdateContinueStatements(loopNode, innerBlockLabel)) {
                        Node innerBlock = IR.block().srcref(loopBody);
                        innerBlock.addChildrenToFront(loopBody.removeChildren());
                        loopBody.addChildToFront(IR.label(IR.labelName(innerBlockLabel).srcref(loopBody), innerBlock).srcref(loopBody));
                    }
                    loopBody.addChildToBack(IR.exprResult(updateLoopObject).useSourceInfoIfMissingFromForTree(loopNode));
                }
                Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToEnclosingScope(loopNode);
                for (Object var : loopObject.vars) {
                    for (Node reference : this.referenceMap.get(var)) {
                        if (NodeUtil.isEnhancedFor(loopNode) && loopNode.getFirstChild() == reference.getParent()) {
                            loopNode.getLastChild().addChildToFront(IR.exprResult(IR.assign(IR.getprop(IR.name(loopObject.name), IR.string(((Var)var).name)), ((AbstractVar)var).getNameNode().cloneNode())).useSourceInfoIfMissingFromForTree(reference));
                            continue;
                        }
                        if (NodeUtil.isNameDeclaration(reference.getParent())) {
                            Node declaration = reference.getParent();
                            Node grandParent = declaration.getParent();
                            Es6RewriteBlockScopedDeclaration.this.handleDeclarationList(declaration, grandParent);
                            declaration = reference.getParent();
                            if (reference.hasChildren()) {
                                Node newReference = reference.cloneNode();
                                Node assign = IR.assign(newReference, reference.removeFirstChild());
                                Es6RewriteBlockScopedDeclaration.extractInlineJSDoc(declaration, reference, declaration);
                                Es6RewriteBlockScopedDeclaration.maybeAddConstJSDoc(declaration, grandParent, reference, declaration);
                                assign.setJSDocInfo(declaration.getJSDocInfo());
                                Node replacement = IR.exprResult(assign).useSourceInfoIfMissingFromForTree(declaration);
                                grandParent.replaceChild(declaration, replacement);
                                reference = newReference;
                            } else {
                                grandParent.removeChild(declaration);
                            }
                            Es6RewriteBlockScopedDeclaration.this.letConsts.remove(declaration);
                            Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToEnclosingScope(grandParent);
                        }
                        if (reference.getParent().isCall() && reference.getParent().getFirstChild() == reference) {
                            reference.getParent().putBooleanProp((byte)50, false);
                        }
                        Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(reference);
                        reference.replaceWith(IR.getprop(IR.name(loopObject.name), IR.string(((Var)var).name)).useSourceInfoIfMissingFromForTree(reference));
                        if (changeScope == null) continue;
                        Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToChangeScope(changeScope);
                    }
                }
            }
            for (Node function : this.functionLoopObjectsMap.keySet()) {
                Node returnNode = IR.returnNode();
                Collection objects = this.functionLoopObjectsMap.get((Object)function);
                Node[] objectNames = new Node[objects.size()];
                Node[] objectNamesForCall = new Node[objects.size()];
                int i = 0;
                for (LoopObject object : objects) {
                    objectNames[i] = IR.name(object.name);
                    objectNamesForCall[i] = IR.name(object.name);
                    ++i;
                }
                Node iife = IR.function(IR.name(""), IR.paramList(objectNames), IR.block(returnNode));
                Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToChangeScope(iife);
                Node call = IR.call(iife, objectNamesForCall);
                call.putBooleanProp((byte)50, true);
                Node replacement = NodeUtil.isFunctionDeclaration(function) ? IR.var(IR.name(function.getFirstChild().getString()), call).useSourceInfoIfMissingFromForTree(function) : call.useSourceInfoIfMissingFromForTree(function);
                function.replaceWith(replacement);
                returnNode.addChildToFront(function);
                Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToEnclosingScope(replacement);
            }
        }

        private boolean maybeUpdateContinueStatements(Node loopNode, String breakLabel) {
            Node loopParent = loopNode.getParent();
            String originalLoopLabel = loopParent.isLabel() ? loopParent.getFirstChild().getString() : null;
            ContinueStatementUpdater continueStatementUpdater = new ContinueStatementUpdater(breakLabel, originalLoopLabel);
            NodeTraversal.traverseEs6(Es6RewriteBlockScopedDeclaration.this.compiler, NodeUtil.getLoopCodeBlock(loopNode), continueStatementUpdater);
            return continueStatementUpdater.replacedAContinueStatement;
        }

        private class LoopObject {
            private final String name;
            private final Set<Var> vars = new LinkedHashSet<Var>();

            private LoopObject(String name) {
                this.name = name;
            }
        }

        private class ContinueStatementUpdater
        implements NodeTraversal.Callback {
            private final String breakLabel;
            @Nullable
            private final String originalLoopLabel;
            int loopDepth = 0;
            boolean replacedAContinueStatement = false;

            public ContinueStatementUpdater(@Nullable String breakLabel, String originalLoopLabel) {
                this.breakLabel = breakLabel;
                this.originalLoopLabel = originalLoopLabel;
            }

            @Override
            public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
                Preconditions.checkState((!n.isClass() ? 1 : 0) != 0, (Object)n);
                if (n.isFunction()) {
                    return false;
                }
                if (NodeUtil.isLoopStructure(n)) {
                    if (this.originalLoopLabel == null) {
                        return false;
                    }
                    ++this.loopDepth;
                    return true;
                }
                return true;
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (NodeUtil.isLoopStructure(n)) {
                    --this.loopDepth;
                } else if (n.isContinue()) {
                    if (this.loopDepth == 0 && !n.hasChildren()) {
                        this.replaceWithBreak(n);
                    } else if (this.originalLoopLabel != null && n.hasChildren() && this.originalLoopLabel.equals(n.getOnlyChild().getString())) {
                        this.replaceWithBreak(n);
                    }
                }
            }

            private void replaceWithBreak(Node continueNode) {
                Node labelName = IR.labelName(this.breakLabel).srcref(continueNode);
                Node breakNode = IR.breakNode(labelName).srcref(continueNode);
                continueNode.replaceWith(breakNode);
                this.replacedAContinueStatement = true;
            }
        }
    }

    private class CollectUndeclaredNames
    extends NodeTraversal.AbstractPostOrderCallback {
        private CollectUndeclaredNames() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() && !t.getScope().hasSlot(n.getString())) {
                Es6RewriteBlockScopedDeclaration.this.undeclaredNames.add(n.getString());
            }
        }
    }
}

