/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

public final class Es6RewriteBlockScopedFunctionDeclaration
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.BLOCK_SCOPED_FUNCTION_DECLARATION);

    public Es6RewriteBlockScopedFunctionDeclaration(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction() && parent != null && parent.isNormalBlock() && !parent.getParent().isFunction()) {
            this.visitBlockScopedFunctionDeclaration(n, parent);
        }
    }

    private void visitBlockScopedFunctionDeclaration(Node n, Node parent) {
        Node oldNameNode = n.getFirstChild();
        Node fnNameNode = oldNameNode.cloneNode();
        Node let = IR.declaration(fnNameNode, Token.LET).srcref(n);
        oldNameNode.setString("");
        this.compiler.reportChangeToEnclosingScope(oldNameNode);
        parent.removeChild(n);
        parent.addChildToFront(let);
        this.compiler.reportChangeToEnclosingScope(let);
        fnNameNode.addChildToFront(n);
    }
}

