/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class Es6RewriteModulesToCommonJsModules
implements CompilerPass {
    private static final String JSCOMP_DEFAULT_EXPORT = "$$default";
    private static final String MODULE = "$$module";
    private static final String EXPORTS = "$$exports";
    private static final String REQUIRE = "$$require";
    private final AbstractCompiler compiler;
    private final String pragma;

    public Es6RewriteModulesToCommonJsModules(AbstractCompiler compiler) {
        this(compiler, "use strict");
    }

    @VisibleForTesting
    Es6RewriteModulesToCommonJsModules(AbstractCompiler compiler, String pragma) {
        this.compiler = compiler;
        this.pragma = pragma;
    }

    @Override
    public void process(Node externs, Node root) {
        for (Node script : root.children()) {
            if (!Es6RewriteModules.isEs6ModuleRoot(script)) continue;
            NodeTraversal.traverseEs6(this.compiler, script, new Rewriter(this.compiler, script));
        }
    }

    private class Rewriter
    extends NodeTraversal.AbstractPostOrderCallback {
        private Node requireInsertSpot;
        private final Node script;
        private final Map<String, LocalQName> exportedNameToLocalQName;
        private final Set<Node> imports;
        private final Set<String> importRequests;
        private final AbstractCompiler compiler;
        private final ModuleLoader.ModulePath modulePath;

        Rewriter(AbstractCompiler compiler, Node script) {
            this.compiler = compiler;
            this.script = script;
            this.requireInsertSpot = null;
            this.exportedNameToLocalQName = new TreeMap<String, LocalQName>();
            this.importRequests = new LinkedHashSet<String>();
            this.imports = new HashSet<Node>();
            this.modulePath = compiler.getInput(script.getInputId()).getPath();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case IMPORT: {
                    this.visitImport(n);
                    break;
                }
                case EXPORT: {
                    this.visitExport(t, n, parent);
                    break;
                }
                case SCRIPT: {
                    this.visitScript(t, n);
                    break;
                }
                case NAME: {
                    this.maybeRenameImportedValue(t, n);
                    break;
                }
            }
        }

        private String getVarNameOfImport(Node importDecl) {
            Preconditions.checkState((boolean)importDecl.isImport());
            return this.getVarNameOfImport(importDecl.getLastChild().getString());
        }

        private String getVarNameOfImport(String importRequest) {
            return this.modulePath.resolveModuleAsPath(importRequest).toModuleName();
        }

        private String getNameOfImportedValue(Node nameNode) {
            Node importDecl = nameNode;
            while (!importDecl.isImport()) {
                importDecl = importDecl.getParent();
            }
            String moduleName = this.getVarNameOfImport(importDecl);
            if (nameNode.getParent().isImportSpec()) {
                return moduleName + "." + nameNode.getParent().getFirstChild().getString();
            }
            if (nameNode.isImportStar()) {
                return moduleName;
            }
            Preconditions.checkState((boolean)nameNode.getParent().isImport());
            return moduleName + ".default";
        }

        @Nullable
        private String maybeGetNameOfImportedValue(Scope s, Node nameNode) {
            Preconditions.checkState((boolean)nameNode.isName());
            Var var = (Var)s.getVar(nameNode.getString());
            if (var != null && var.getNameNode() != null && NodeUtil.isImportedName(var.getNameNode()) && nameNode != var.getNameNode()) {
                return this.getNameOfImportedValue(var.getNameNode());
            }
            return null;
        }

        private void maybeRenameImportedValue(NodeTraversal t, Node n) {
            Preconditions.checkState((boolean)n.isName());
            Node parent = n.getParent();
            if (parent.isExport() || parent.isExportSpec() || parent.isImport() || parent.isImportSpec()) {
                return;
            }
            String qName = this.maybeGetNameOfImportedValue(t.getScope(), n);
            if (qName != null) {
                n.replaceWith(NodeUtil.newQName(this.compiler, qName));
                t.reportCodeChange();
            }
        }

        private void visitScript(NodeTraversal t, Node script) {
            Preconditions.checkState((this.script == script ? 1 : 0) != 0);
            Node moduleNode = script.getFirstChild();
            Preconditions.checkState((boolean)moduleNode.isModuleBody());
            moduleNode.detach();
            script.addChildrenToFront(moduleNode.removeChildren());
            this.addRequireCalls();
            this.addExportDef();
            this.registerAndLoadModule(t);
        }

        private void addRequireCalls() {
            if (!this.importRequests.isEmpty()) {
                for (Node importDecl : this.imports) {
                    importDecl.detach();
                }
                HashSet<String> importedNames = new HashSet<String>();
                for (String request : this.importRequests) {
                    String varName = this.getVarNameOfImport(request);
                    if (!importedNames.add(varName)) continue;
                    Node requireCall = IR.call(IR.name(Es6RewriteModulesToCommonJsModules.REQUIRE), IR.string(request));
                    requireCall.putBooleanProp((byte)50, true);
                    Node var = IR.var(IR.name(varName), requireCall);
                    var.useSourceInfoIfMissingFromForTree(this.script);
                    this.script.addChildAfter(var, this.requireInsertSpot);
                    this.requireInsertSpot = var;
                }
            }
        }

        private void registerAndLoadModule(NodeTraversal t) {
            Node block = IR.block();
            block.addChildrenToFront(this.script.removeChildren());
            block.addChildToFront(IR.exprResult(IR.string(Es6RewriteModulesToCommonJsModules.this.pragma)));
            Node moduleFunction = IR.function(IR.name(""), IR.paramList(IR.name(Es6RewriteModulesToCommonJsModules.REQUIRE), IR.name(Es6RewriteModulesToCommonJsModules.EXPORTS), IR.name(Es6RewriteModulesToCommonJsModules.MODULE)), block);
            Node shallowDeps = new Node(Token.ARRAYLIT);
            for (String request : this.importRequests) {
                shallowDeps.addChildToBack(IR.string(request));
            }
            Node exprResult = IR.exprResult(IR.call(IR.getprop(IR.name("$jscomp"), IR.string("registerAndLoadModule")), moduleFunction, IR.string(t.getInput().getName()), shallowDeps));
            this.script.addChildToBack(exprResult.useSourceInfoIfMissingFromForTree(this.script));
            this.compiler.reportChangeToChangeScope(this.script);
            this.compiler.reportChangeToChangeScope(moduleFunction);
            t.reportCodeChange();
        }

        private void addExportDef() {
            if (!this.exportedNameToLocalQName.isEmpty()) {
                Node definePropertiesLit = IR.objectlit(new Node[0]);
                for (Map.Entry<String, LocalQName> entry : this.exportedNameToLocalQName.entrySet()) {
                    this.addExport(definePropertiesLit, entry.getKey(), entry.getValue());
                }
                this.script.addChildToFront(IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "Object.defineProperties"), IR.name(Es6RewriteModulesToCommonJsModules.EXPORTS), definePropertiesLit)).useSourceInfoIfMissingFromForTree(this.script));
            }
        }

        private void addExport(Node definePropertiesLit, String exportedName, LocalQName localQName) {
            Node exportedValue = NodeUtil.newQName(this.compiler, localQName.qName);
            Node getterFunction = IR.function(IR.name(""), IR.paramList(), IR.block(IR.returnNode(exportedValue)));
            getterFunction.useSourceInfoFromForTree(localQName.nodeForSourceInfo);
            Node objLit = IR.objectlit(IR.stringKey("enumerable", IR.trueNode()), IR.stringKey("get", getterFunction));
            definePropertiesLit.addChildToBack(IR.stringKey(exportedName, objLit));
            this.compiler.reportChangeToChangeScope(getterFunction);
        }

        private void visitImport(Node importDecl) {
            this.importRequests.add(importDecl.getLastChild().getString());
            this.imports.add(importDecl);
        }

        private void visitExportDefault(NodeTraversal t, Node export, Node parent) {
            Node child = export.getFirstChild();
            String name = null;
            if (child.isFunction() || child.isClass()) {
                name = NodeUtil.getName(child);
            }
            if (name != null) {
                Node decl = child.detach();
                parent.replaceChild(export, decl);
            } else {
                name = Es6RewriteModulesToCommonJsModules.JSCOMP_DEFAULT_EXPORT;
                Node var = IR.constNode(IR.name(name), export.removeFirstChild());
                parent.replaceChild(export, var.useSourceInfoIfMissingFromForTree(export));
            }
            this.exportedNameToLocalQName.put("default", new LocalQName(name, export));
            t.reportCodeChange();
        }

        private void visitExportFrom(NodeTraversal t, Node export, Node parent) {
            Node moduleIdentifier = export.getLastChild();
            Node importNode = IR.importNode(IR.empty(), IR.empty(), moduleIdentifier.cloneNode());
            importNode.useSourceInfoFrom(export);
            parent.addChildBefore(importNode, export);
            this.visit(t, importNode, parent);
            String moduleName = this.getVarNameOfImport(moduleIdentifier.getString());
            for (Node exportSpec : export.getFirstChild().children()) {
                this.exportedNameToLocalQName.put(exportSpec.getLastChild().getString(), new LocalQName(moduleName + "." + exportSpec.getFirstChild().getString(), exportSpec));
            }
            parent.removeChild(export);
            t.reportCodeChange();
        }

        private void visitExportSpecs(NodeTraversal t, Node export, Node parent) {
            for (Node exportSpec : export.getFirstChild().children()) {
                String localName = exportSpec.getFirstChild().getString();
                Var var = (Var)t.getScope().getVar(localName);
                if (var != null && NodeUtil.isImportedName(var.getNameNode())) {
                    localName = this.maybeGetNameOfImportedValue(t.getScope(), exportSpec.getFirstChild());
                    Preconditions.checkNotNull((Object)localName);
                }
                this.exportedNameToLocalQName.put(exportSpec.getLastChild().getString(), new LocalQName(localName, exportSpec));
            }
            parent.removeChild(export);
            t.reportCodeChange();
        }

        private void visitExportNameDeclaration(Node declaration) {
            List<Node> lhsNodes = NodeUtil.findLhsNodesInNode(declaration);
            for (Node lhs : lhsNodes) {
                Preconditions.checkState((boolean)lhs.isName());
                String name = lhs.getString();
                this.exportedNameToLocalQName.put(name, new LocalQName(name, lhs));
            }
        }

        private void visitExportDeclaration(NodeTraversal t, Node export, Node parent) {
            Node declaration = export.getFirstChild();
            if (NodeUtil.isNameDeclaration(declaration)) {
                this.visitExportNameDeclaration(declaration);
            } else {
                Preconditions.checkState((declaration.isFunction() || declaration.isClass() ? 1 : 0) != 0);
                String name = declaration.getFirstChild().getString();
                this.exportedNameToLocalQName.put(name, new LocalQName(name, export));
            }
            parent.replaceChild(export, declaration.detach());
            t.reportCodeChange();
        }

        private void visitExport(NodeTraversal t, Node export, Node parent) {
            if (export.getBooleanProp((byte)63)) {
                this.visitExportDefault(t, export, parent);
            } else if (export.getBooleanProp((byte)64)) {
                this.compiler.report(JSError.make(export, Es6ToEs3Util.CANNOT_CONVERT_YET, "Wildcard export"));
            } else if (export.hasTwoChildren()) {
                this.visitExportFrom(t, export, parent);
            } else if (export.getFirstChild().getToken() == Token.EXPORT_SPECS) {
                this.visitExportSpecs(t, export, parent);
            } else {
                this.visitExportDeclaration(t, export, parent);
            }
        }
    }

    private static class LocalQName {
        final String qName;
        final Node nodeForSourceInfo;

        LocalQName(String qName, Node nodeForSourceInfo) {
            this.qName = qName;
            this.nodeForSourceInfo = nodeForSourceInfo;
        }
    }
}

