/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AutoValue_EsNextToEs8Converter_ComputedPropertyName;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayList;
import java.util.List;

public final class EsNextToEs8Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.OBJECT_LITERALS_WITH_SPREAD).with(FeatureSet.Feature.OBJECT_PATTERN_REST);
    private final boolean addTypes;
    private static final String PATTERN_TEMP_VAR = "$jscomp$objpattern$var";
    private int patternVarCounter = 0;

    public EsNextToEs8Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.addTypes = AbstractCompiler.MostRecentTypechecker.NTI.equals((Object)compiler.getMostRecentTypechecker());
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case OBJECTLIT: {
                this.visitObject(n);
                break;
            }
            case OBJECT_PATTERN: {
                if (!n.hasChildren() || !n.getLastChild().isRest()) break;
                this.visitObjectPatternWithRest(n, parent);
                break;
            }
        }
    }

    private void visitObject(Node obj) {
        for (Node child : obj.children()) {
            if (!child.isSpread()) continue;
            this.visitObjectWithSpread(obj);
            return;
        }
    }

    private boolean canOmitResult(Node n) {
        if (n.getParent().isExprResult()) {
            return true;
        }
        if (n.getParent().isComma()) {
            if (n.getNext() != null) {
                return true;
            }
            return this.canOmitResult(n.getParent());
        }
        return false;
    }

    private void visitObjectPatternWithRest(Node pattern, Node parent) {
        Node let;
        Node block;
        Node enhancedFor;
        Preconditions.checkArgument((boolean)pattern.isObjectPattern(), (Object)pattern);
        ObjectPatternConverter converter = new ObjectPatternConverter(pattern);
        if (parent.isCatch()) {
            Node block2 = parent.getSecondChild();
            converter.prependDeclStatements(Token.LET, block2);
            parent.addChildToFront(converter.newName());
            this.compiler.reportChangeToEnclosingScope(parent);
            return;
        }
        Node grandparent = parent.getParent();
        if (parent.isParamList() || parent.isDefaultValue() && grandparent.isParamList()) {
            Node body = parent.isParamList() ? parent.getNext() : grandparent.getNext();
            converter.prependDeclStatements(Token.LET, body);
            parent.addChildToFront(converter.newName());
            this.compiler.reportChangeToEnclosingScope(parent);
            return;
        }
        if (NodeUtil.isEnhancedFor(parent)) {
            enhancedFor = parent;
            block = enhancedFor.getLastChild();
            converter.prependDeclStatements(Token.ASSIGN, block);
            let = new Node(Token.LET, converter.newName());
            let.useSourceInfoIfMissingFrom(pattern);
            enhancedFor.addChildToFront(let);
            this.compiler.reportChangeToEnclosingScope(enhancedFor);
        }
        if (parent.isDestructuringLhs() && NodeUtil.isNameDeclaration(grandparent)) {
            if (NodeUtil.isEnhancedFor(grandparent.getParent())) {
                enhancedFor = grandparent.getParent();
                block = enhancedFor.getLastChild();
                converter.prependDeclStatements(grandparent.getToken(), block);
                let = new Node(Token.LET, converter.newName());
                let.useSourceInfoIfMissingFrom(pattern);
                enhancedFor.replaceChild(grandparent, let);
                this.compiler.reportChangeToEnclosingScope(enhancedFor);
                return;
            }
            converter.insertBindings();
            this.compiler.reportChangeToEnclosingScope(grandparent);
        }
        if (parent.isAssign()) {
            Node rhs = pattern.getNext();
            Node body = IR.block();
            converter.prependDeclStatements(Token.ASSIGN, body);
            if (!this.canOmitResult(parent)) {
                String copyName = PATTERN_TEMP_VAR + this.patternVarCounter++;
                body.addChildToFront(IR.let(IR.name(copyName), converter.newName()));
                body.addChildToBack(IR.returnNode(IR.name(copyName)));
            }
            body.addChildToFront(IR.let(converter.newName(), rhs.detach()));
            Node call = IR.call(IR.arrowFunction(IR.name(""), IR.paramList(), body), new Node[0]);
            call.putBooleanProp((byte)50, true);
            call.useSourceInfoIfMissingFromForTree(pattern);
            NodeUtil.markNewScopesChanged(call, this.compiler);
            grandparent.replaceChild(parent, call);
            this.compiler.reportChangeToEnclosingScope(grandparent);
            return;
        }
    }

    private void visitObjectWithSpread(Node obj) {
        TypeI simpleObjectType;
        Preconditions.checkArgument((boolean)obj.isObjectLit());
        TypeI resultType = simpleObjectType = Es6ToEs3Util.createType(this.addTypes, this.compiler.getTypeIRegistry(), JSTypeNative.EMPTY_OBJECT_LITERAL_TYPE);
        Node result = Es6ToEs3Util.withType(IR.call(NodeUtil.newQName(this.compiler, "Object.assign"), new Node[0]), resultType);
        result.addChildToBack(Es6ToEs3Util.withType(IR.objectlit(new Node[0]), simpleObjectType));
        Node trailingObjectLiteral = null;
        for (Node child : obj.children()) {
            if (child.isSpread()) {
                Node spreaded = child.removeFirstChild();
                result.addChildToBack(spreaded);
                trailingObjectLiteral = null;
                continue;
            }
            if (trailingObjectLiteral == null) {
                trailingObjectLiteral = Es6ToEs3Util.withType(IR.objectlit(new Node[0]), simpleObjectType);
                result.addChildToBack(trailingObjectLiteral);
            }
            trailingObjectLiteral.addChildToBack(child.detach());
        }
        result.useSourceInfoIfMissingFromForTree(obj);
        obj.replaceWith(result);
        this.compiler.reportChangeToEnclosingScope(result);
    }

    private class ObjectPatternConverter {
        private final Node pattern;
        private final String varName;
        private final List<Node> deletions = new ArrayList<Node>();
        private final List<ComputedPropertyName> computedProperties = new ArrayList<ComputedPropertyName>();

        private Node getRestRhs() {
            Node restRhs = this.newName();
            if (!this.deletions.isEmpty()) {
                Node comma = this.deletions.remove(0);
                for (Node deletion : this.deletions) {
                    comma = IR.comma(comma, deletion);
                }
                restRhs = IR.comma(comma, restRhs);
            }
            restRhs.useSourceInfoIfMissingFromForTree(this.pattern);
            return restRhs;
        }

        ObjectPatternConverter(Node pattern) {
            this.pattern = pattern;
            this.varName = EsNextToEs8Converter.PATTERN_TEMP_VAR + EsNextToEs8Converter.this.patternVarCounter++;
            for (Node child : pattern.children()) {
                if (child.isStringKey()) {
                    this.deletions.add(new Node(Token.DELPROP, new Node(child.isQuotedString() ? Token.GETELEM : Token.GETPROP, this.newName(), IR.string(child.getString()))));
                    continue;
                }
                if (!child.isComputedProp()) continue;
                String auxTempVarName = EsNextToEs8Converter.PATTERN_TEMP_VAR + EsNextToEs8Converter.this.patternVarCounter++;
                this.deletions.add(new Node(Token.DELPROP, IR.getelem(this.newName(), IR.name(auxTempVarName))));
                ComputedPropertyName pair = ComputedPropertyName.create(auxTempVarName, child.getFirstChild());
                this.computedProperties.add(pair);
            }
        }

        Node newName() {
            Node name = IR.name(this.varName);
            name.useSourceInfoIfMissingFrom(this.pattern);
            return name;
        }

        void insertBindings() {
            Node parent = this.pattern.getParent();
            Preconditions.checkState((boolean)parent.isDestructuringLhs(), (Object)parent);
            Node grandparent = parent.getParent();
            Preconditions.checkState((boolean)NodeUtil.isNameDeclaration(grandparent), (Object)grandparent);
            Node varName = this.newName();
            varName.addChildToBack(this.pattern.getNext().detach());
            grandparent.addChildBefore(varName, parent);
            for (ComputedPropertyName pair : this.computedProperties) {
                pair.computation().replaceWith(IR.name(pair.varName()));
                Node compPropLhs = IR.name(pair.varName());
                compPropLhs.addChildToBack(pair.computation());
                compPropLhs.useSourceInfoIfMissingFromForTree(this.pattern);
                grandparent.addChildBefore(compPropLhs, parent);
            }
            Node restNode = this.pattern.getLastChild().detach();
            parent.addChildToBack(this.newName());
            Node restLhs = restNode.removeFirstChild();
            restLhs.addChildToBack(this.getRestRhs());
            grandparent.addChildAfter(restLhs, parent);
        }

        void prependDeclStatements(Token declType, Node block) {
            ArrayList<Node> statements = new ArrayList<Node>();
            for (ComputedPropertyName pair : this.computedProperties) {
                pair.computation().replaceWith(IR.name(pair.varName()));
                Node let = IR.let(IR.name(pair.varName()), pair.computation());
                let.useSourceInfoIfMissingFromForTree(this.pattern);
                statements.add(let);
            }
            Node headLhs = this.pattern.detach();
            Node headRhs = this.newName();
            Node restNode = this.pattern.getLastChild().detach();
            Node restLhs = restNode.removeFirstChild();
            Node restRhs = this.getRestRhs();
            if (declType == Token.ASSIGN) {
                Node assign = IR.exprResult(IR.comma(IR.assign(headLhs, headRhs), IR.assign(restLhs, restRhs)));
                assign.useSourceInfoIfMissingFromForTree(this.pattern);
                statements.add(assign);
            } else {
                Node decl = IR.declaration(headLhs, headRhs, declType);
                restLhs.addChildToBack(restRhs);
                decl.addChildToBack(restLhs);
                decl.useSourceInfoIfMissingFromForTree(this.pattern);
                statements.add(decl);
            }
            Node next = block.getFirstChild();
            for (Node statement : statements) {
                if (next == null) {
                    block.addChildToBack(statement);
                    continue;
                }
                block.addChildBefore(statement, next);
            }
        }
    }

    static abstract class ComputedPropertyName {
        ComputedPropertyName() {
        }

        static ComputedPropertyName create(String varName, Node computation) {
            return new AutoValue_EsNextToEs8Converter_ComputedPropertyName(varName, computation);
        }

        abstract String varName();

        abstract Node computation();
    }
}

