/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.ScopedName;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.StaticTypedRef;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class LinkedFlowScope
implements FlowScope {
    private final FlatFlowScopeCache cache;
    private final LinkedFlowScope parent;
    private int depth;
    static final int MAX_DEPTH = 250;
    private FlatFlowScopeCache flattened;
    private boolean frozen = false;
    private LinkedFlowSlot lastSlot;

    private LinkedFlowScope(FlatFlowScopeCache cache) {
        this.cache = cache;
        this.lastSlot = null;
        this.depth = 0;
        this.parent = cache.linkedEquivalent;
    }

    private LinkedFlowScope(LinkedFlowScope directParent) {
        this.cache = directParent.cache;
        this.lastSlot = directParent.lastSlot;
        this.depth = directParent.depth + 1;
        this.parent = directParent;
    }

    private TypedScope getFunctionScope() {
        return this.cache.functionScope;
    }

    private boolean flowsFromBottom() {
        return this.getFunctionScope().isBottom();
    }

    public static LinkedFlowScope createEntryLattice(TypedScope scope) {
        return new LinkedFlowScope(new FlatFlowScopeCache(scope));
    }

    @Override
    public void inferSlotType(String symbol, JSType type) {
        Preconditions.checkState((!this.frozen ? 1 : 0) != 0);
        ScopedName var = this.getVarFromFunctionScope(symbol);
        this.lastSlot = new LinkedFlowSlot(var, type, this.lastSlot);
        ++this.depth;
        this.cache.dirtySymbols.add(var);
    }

    @Override
    public void inferQualifiedSlot(Node node, String symbol, JSType bottomType, JSType inferredType, boolean declared) {
        JSType declaredType;
        TypedScope functionScope = this.getFunctionScope();
        if (functionScope.isGlobal()) {
            return;
        }
        TypedVar v = (TypedVar)functionScope.getVar(symbol);
        if (v == null && !functionScope.isBottom()) {
            v = functionScope.declare(symbol, node, bottomType, null, !declared);
        }
        JSType jSType = declaredType = v != null ? v.getType() : null;
        if (v != null) {
            if (!v.isTypeInferred()) {
                if (declaredType == null || !inferredType.isSubtypeOf(declaredType) || declaredType.isSubtypeOf(inferredType) || inferredType.isEquivalentTo(declaredType)) {
                    return;
                }
            } else if (declaredType != null && !inferredType.isSubtypeOf(declaredType)) {
                v.setType(v.getType().getLeastSupertype(inferredType));
            }
        }
        this.inferSlotType(symbol, inferredType);
    }

    @Override
    public JSType getTypeOfThis() {
        return this.cache.functionScope.getTypeOfThis();
    }

    @Override
    public Node getRootNode() {
        return this.getFunctionScope().getRootNode();
    }

    @Override
    public StaticTypedScope<JSType> getParentScope() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StaticTypedSlot<JSType> getSlot(String name) {
        return this.getSlot(this.getVarFromFunctionScope(name));
    }

    private StaticTypedSlot<JSType> getSlot(ScopedName var) {
        LinkedFlowSlot slot;
        if (this.cache.dirtySymbols.contains(var)) {
            slot = this.lastSlot;
            while (slot != null) {
                if (slot.var.equals(var)) {
                    return slot;
                }
                slot = slot.parent;
            }
        }
        return (slot = this.cache.symbols.get(var)) != null ? slot : (StaticTypedSlot)this.getFunctionScope().getSlot(var.getName());
    }

    private static String getRootOfQualifiedName(String name) {
        int index = name.indexOf(46);
        return index < 0 ? name : name.substring(0, index);
    }

    private ScopedName getVarFromFunctionScope(String name) {
        TypedVar v = (TypedVar)this.getFunctionScope().getVar(name);
        if (v != null) {
            return v;
        }
        TypedVar rootVar = (TypedVar)this.getFunctionScope().getVar(LinkedFlowScope.getRootOfQualifiedName(name));
        TypedScope rootScope = rootVar != null ? (TypedScope)rootVar.getScope() : null;
        rootScope = rootScope != null ? rootScope : (TypedScope)this.getFunctionScope().getGlobalScope();
        return ScopedName.of(name, rootScope.getRootNode());
    }

    @Override
    public StaticTypedSlot<JSType> getOwnSlot(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FlowScope createChildFlowScope() {
        this.frozen = true;
        if (this.depth > 250) {
            if (this.flattened == null) {
                this.flattened = new FlatFlowScopeCache(this);
            }
            return new LinkedFlowScope(this.flattened);
        }
        return new LinkedFlowScope(this);
    }

    @Override
    public StaticTypedSlot<JSType> findUniqueRefinedSlot(FlowScope blindScope) {
        LinkedFlowSlot result = null;
        LinkedFlowScope currentScope = this;
        while (currentScope != blindScope) {
            LinkedFlowSlot parentSlot = currentScope.parent != null ? currentScope.parent.lastSlot : null;
            LinkedFlowSlot currentSlot = currentScope.lastSlot;
            while (currentSlot != null && currentSlot != parentSlot) {
                if (result == null) {
                    result = currentSlot;
                } else if (!currentSlot.var.equals(result.var)) {
                    return null;
                }
                currentSlot = currentSlot.parent;
            }
            currentScope = currentScope.parent;
        }
        return result;
    }

    @Override
    public LinkedFlowScope optimize() {
        LinkedFlowScope current = this;
        while (current.parent != null && current.lastSlot == current.parent.lastSlot) {
            current = current.parent;
        }
        return current;
    }

    private boolean optimizesToSameScope(LinkedFlowScope that) {
        if (this.lastSlot == null) {
            return that.lastSlot == null && this.cache == that.cache;
        }
        Preconditions.checkState((this.cache == that.cache || this.lastSlot != that.lastSlot ? 1 : 0) != 0);
        return this.lastSlot == that.lastSlot;
    }

    public TypedScope getDeclarationScope() {
        return this.getFunctionScope();
    }

    public boolean equals(Object other) {
        if (!(other instanceof LinkedFlowScope)) {
            return false;
        }
        LinkedFlowScope that = (LinkedFlowScope)other;
        if (this.optimizesToSameScope(that)) {
            return true;
        }
        if (this.getFunctionScope() != that.getFunctionScope()) {
            return false;
        }
        if (this.cache == that.cache) {
            for (ScopedName var : this.cache.dirtySymbols) {
                if (!LinkedFlowScope.diffSlots(this.getSlot(var), that.getSlot(var))) continue;
                return false;
            }
            return true;
        }
        Map<ScopedName, LinkedFlowSlot> myFlowSlots = this.allFlowSlots();
        Map<ScopedName, LinkedFlowSlot> otherFlowSlots = that.allFlowSlots();
        for (ScopedName name : Sets.union(myFlowSlots.keySet(), otherFlowSlots.keySet())) {
            if (!LinkedFlowScope.diffSlots(myFlowSlots.get(name), otherFlowSlots.get(name))) continue;
            return false;
        }
        return true;
    }

    private static boolean diffSlots(StaticTypedSlot<JSType> slotA, StaticTypedSlot<JSType> slotB) {
        boolean bIsNull;
        boolean aIsNull = slotA == null || slotA.getType() == null;
        boolean bl = bIsNull = slotB == null || slotB.getType() == null;
        if (aIsNull && bIsNull) {
            return false;
        }
        if (aIsNull ^ bIsNull) {
            return true;
        }
        return slotA.getType().differsFrom(slotB.getType());
    }

    private Map<ScopedName, LinkedFlowSlot> allFlowSlots() {
        HashMap<ScopedName, LinkedFlowSlot> slots = new HashMap<ScopedName, LinkedFlowSlot>();
        LinkedFlowSlot slot = this.lastSlot;
        while (slot != null) {
            slots.putIfAbsent(slot.var, slot);
            slot = slot.parent;
        }
        for (Map.Entry<ScopedName, LinkedFlowSlot> symbolEntry : this.cache.symbols.entrySet()) {
            slots.putIfAbsent(symbolEntry.getKey(), symbolEntry.getValue());
        }
        return slots;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    private static class FlatFlowScopeCache {
        final TypedScope functionScope;
        final LinkedFlowScope linkedEquivalent;
        final Map<ScopedName, LinkedFlowSlot> symbols;
        final Set<ScopedName> dirtySymbols = new HashSet<ScopedName>();

        FlatFlowScopeCache(TypedScope functionScope) {
            this.functionScope = functionScope;
            this.symbols = ImmutableMap.of();
            this.linkedEquivalent = null;
        }

        FlatFlowScopeCache(LinkedFlowScope directParent) {
            FlatFlowScopeCache cache = directParent.cache;
            this.functionScope = cache.functionScope;
            this.symbols = directParent.allFlowSlots();
            this.linkedEquivalent = directParent;
        }

        FlatFlowScopeCache(LinkedFlowScope joinedScopeA, LinkedFlowScope joinedScopeB) {
            this.linkedEquivalent = null;
            this.functionScope = joinedScopeA.flowsFromBottom() ? joinedScopeB.getFunctionScope() : joinedScopeA.getFunctionScope();
            Map slotsA = joinedScopeA.allFlowSlots();
            Map slotsB = joinedScopeB.allFlowSlots();
            this.symbols = slotsA;
            for (ScopedName var : Sets.union(slotsA.keySet(), slotsB.keySet())) {
                JSType fnSlotType;
                TypedVar fnSlot;
                LinkedFlowSlot slotA = (LinkedFlowSlot)slotsA.get(var);
                LinkedFlowSlot slotB = (LinkedFlowSlot)slotsB.get(var);
                JSType joinedType = null;
                if (slotB == null || slotB.getType() == null) {
                    fnSlot = (TypedVar)joinedScopeB.getFunctionScope().getVar(var.getName());
                    JSType jSType = fnSlotType = fnSlot == null ? null : fnSlot.getType();
                    if (fnSlotType != null && fnSlotType != slotA.getType()) {
                        joinedType = slotA.getType().getLeastSupertype(fnSlotType);
                    }
                } else if (slotA == null || slotA.getType() == null) {
                    fnSlot = (TypedVar)joinedScopeA.getFunctionScope().getVar(var.getName());
                    JSType jSType = fnSlotType = fnSlot == null ? null : fnSlot.getType();
                    if (fnSlotType == null || fnSlotType == slotB.getType()) {
                        this.symbols.put(var, slotB);
                    } else {
                        joinedType = slotB.getType().getLeastSupertype(fnSlotType);
                    }
                } else if (slotA.getType() != slotB.getType()) {
                    joinedType = slotA.getType().getLeastSupertype(slotB.getType());
                }
                if (joinedType == null) continue;
                this.symbols.put(var, new LinkedFlowSlot(var, joinedType, null));
            }
        }
    }

    private static class LinkedFlowSlot
    implements StaticTypedSlot<JSType> {
        final ScopedName var;
        final JSType type;
        final LinkedFlowSlot parent;

        LinkedFlowSlot(ScopedName var, JSType type, LinkedFlowSlot parent) {
            this.var = var;
            this.type = type;
            this.parent = parent;
        }

        @Override
        public String getName() {
            return this.var.getName();
        }

        @Override
        public JSType getType() {
            return this.type;
        }

        @Override
        public boolean isTypeInferred() {
            return true;
        }

        @Override
        public StaticTypedRef<JSType> getDeclaration() {
            return null;
        }

        @Override
        public JSDocInfo getJSDocInfo() {
            return null;
        }

        @Override
        public StaticTypedScope<JSType> getScope() {
            throw new UnsupportedOperationException();
        }
    }

    static class FlowScopeJoinOp
    extends JoinOp.BinaryJoinOp<FlowScope> {
        FlowScopeJoinOp() {
        }

        @Override
        public FlowScope apply(FlowScope a, FlowScope b) {
            LinkedFlowScope linkedA = (LinkedFlowScope)a;
            LinkedFlowScope linkedB = (LinkedFlowScope)b;
            linkedA.frozen = true;
            linkedB.frozen = true;
            if (linkedA.optimizesToSameScope(linkedB)) {
                return linkedA.createChildFlowScope();
            }
            return new LinkedFlowScope(new FlatFlowScopeCache(linkedA, linkedB));
        }
    }
}

