/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.SimpleErrorReporter;
import java.util.Map;
import java.util.regex.Pattern;

class RhinoErrorReporter {
    static final DiagnosticType PARSE_ERROR = DiagnosticType.error("JSC_PARSE_ERROR", "Parse error. {0}");
    static final DiagnosticType TYPE_PARSE_ERROR = DiagnosticType.warning("JSC_TYPE_PARSE_ERROR", "{0}");
    static final DiagnosticType UNRECOGNIZED_TYPE_ERROR = DiagnosticType.warning("JSC_UNRECOGNIZED_TYPE_ERROR", "{0}");
    static final DiagnosticType JSDOC_MISSING_BRACES_WARNING = DiagnosticType.disabled("JSC_JSDOC_MISSING_BRACES_WARNING", "{0}");
    static final DiagnosticType JSDOC_MISSING_TYPE_WARNING = DiagnosticType.disabled("JSC_JSDOC_MISSING_TYPE_WARNING", "{0}");
    static final DiagnosticType TOO_MANY_TEMPLATE_PARAMS = DiagnosticType.disabled("JSC_TOO_MANY_TEMPLATE_PARAMS", "{0}");
    static final DiagnosticType TRAILING_COMMA = DiagnosticType.error("JSC_TRAILING_COMMA", "Parse error. IE8 (and below) will parse trailing commas in array and object literals incorrectly. If you are targeting newer versions of JS, set the appropriate language_in option.");
    static final DiagnosticType DUPLICATE_PARAM = DiagnosticType.error("JSC_DUPLICATE_PARAM", "Parse error. {0}");
    static final DiagnosticType UNNECESSARY_ESCAPE = DiagnosticType.disabled("JSC_UNNECESSARY_ESCAPE", "Parse error. {0}");
    static final DiagnosticType INVALID_PARAM = DiagnosticType.warning("JSC_INVALID_PARAM", "Parse error. {0}");
    static final DiagnosticType BAD_JSDOC_ANNOTATION = DiagnosticType.warning("JSC_BAD_JSDOC_ANNOTATION", "Parse error. {0}");
    static final DiagnosticType JSDOC_IN_BLOCK_COMMENT = DiagnosticType.warning("JSC_JSDOC_IN_BLOCK_COMMENT", "Parse error. {0}");
    static final DiagnosticType INVALID_ES3_PROP_NAME = DiagnosticType.warning("JSC_INVALID_ES3_PROP_NAME", "Keywords and reserved words are not allowed as unquoted property names in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.");
    static final DiagnosticType PARSE_TREE_TOO_DEEP = DiagnosticType.error("PARSE_TREE_TOO_DEEP", "Parse tree too deep.");
    static final DiagnosticType INVALID_OCTAL_LITERAL = DiagnosticType.warning("INVALID_OCTAL_LITERAL", "This style of octal literal is not supported in strict mode.");
    static final DiagnosticType STRING_CONTINUATION = DiagnosticType.warning("JSC_STRING_CONTINUATION", "{0}");
    static final DiagnosticType LANGUAGE_FEATURE = DiagnosticType.error("JSC_LANGUAGE_FEATURE", "{0}.");
    static final DiagnosticType ES6_TYPED = DiagnosticType.error("ES6_TYPED", "{0}. Use --language_in=ECMASCRIPT6_TYPED to enable ES6 typed features.");
    static final DiagnosticType MISPLACED_TYPE_SYNTAX = DiagnosticType.error("MISPLACED_TYPE_SYNTAX", "Can only have JSDoc or inline type annotations, not both");
    private final Map<Pattern, DiagnosticType> typeMap;
    final AbstractCompiler compiler;

    private static Pattern replacePlaceHolders(String s) {
        s = Pattern.quote(s);
        return Pattern.compile(s.replaceAll("\\{\\d+\\}", "\\\\E.*\\\\Q"));
    }

    private RhinoErrorReporter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeMap = ImmutableMap.builder().put((Object)Pattern.compile("Trailing comma is not legal in an ECMA-262 object initializer"), (Object)TRAILING_COMMA).put((Object)RhinoErrorReporter.replacePlaceHolders("Duplicate parameter name \"{0}\""), (Object)DUPLICATE_PARAM).put((Object)Pattern.compile("Unnecessary escape:.*"), (Object)UNNECESSARY_ESCAPE).put((Object)Pattern.compile("^invalid param name.*"), (Object)INVALID_PARAM).put((Object)RhinoErrorReporter.replacePlaceHolders(SimpleErrorReporter.getMessage0("msg.bad.jsdoc.tag")), (Object)BAD_JSDOC_ANNOTATION).put((Object)Pattern.compile("^" + Pattern.quote("Non-JSDoc comment has annotations. Did you mean to start it with '/**'?")), (Object)JSDOC_IN_BLOCK_COMMENT).put((Object)Pattern.compile("^Keywords and reserved words are not allowed as unquoted property.*"), (Object)INVALID_ES3_PROP_NAME).put((Object)Pattern.compile("^Too many template parameters"), (Object)TOO_MANY_TEMPLATE_PARAMS).put((Object)Pattern.compile(".*Type annotations should have curly braces.*"), (Object)JSDOC_MISSING_BRACES_WARNING).put((Object)Pattern.compile("Missing type declaration\\."), (Object)JSDOC_MISSING_TYPE_WARNING).put((Object)Pattern.compile(".*Unknown type.*"), (Object)UNRECOGNIZED_TYPE_ERROR).put((Object)Pattern.compile("^Bad type annotation.*"), (Object)TYPE_PARSE_ERROR).put((Object)Pattern.compile("Too deep recursion while parsing"), (Object)PARSE_TREE_TOO_DEEP).put((Object)Pattern.compile("^Octal .*literal.*"), (Object)INVALID_OCTAL_LITERAL).put((Object)Pattern.compile("^String continuations.*"), (Object)STRING_CONTINUATION).put((Object)Pattern.compile("^This language feature is only supported for .*"), (Object)LANGUAGE_FEATURE).put((Object)Pattern.compile("^type syntax is only supported in ES6 typed mode.*"), (Object)ES6_TYPED).put((Object)Pattern.compile("^Can only have JSDoc or inline type.*"), (Object)MISPLACED_TYPE_SYNTAX).build();
    }

    public static ErrorReporter forOldRhino(AbstractCompiler compiler) {
        return new OldRhinoErrorReporter(compiler);
    }

    void warningAtLine(String message, String sourceName, int line, int lineOffset) {
        this.compiler.report(this.makeError(message, sourceName, line, lineOffset, CheckLevel.WARNING));
    }

    void errorAtLine(String message, String sourceName, int line, int lineOffset) {
        this.compiler.report(this.makeError(message, sourceName, line, lineOffset, CheckLevel.ERROR));
    }

    protected DiagnosticType mapError(String message) {
        for (Map.Entry<Pattern, DiagnosticType> entry : this.typeMap.entrySet()) {
            if (!entry.getKey().matcher(message).matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    private JSError makeError(String message, String sourceName, int line, int lineOffset, CheckLevel defaultLevel) {
        DiagnosticType type = this.mapError(message);
        if (type != null) {
            return JSError.make(sourceName, line, lineOffset, type, message);
        }
        return JSError.make(sourceName, line, lineOffset, defaultLevel, PARSE_ERROR, message);
    }

    private static class OldRhinoErrorReporter
    extends RhinoErrorReporter
    implements ErrorReporter {
        private OldRhinoErrorReporter(AbstractCompiler compiler) {
            super(compiler);
        }

        @Override
        public void error(String message, String sourceName, int line, int lineOffset) {
            super.errorAtLine(message, sourceName, line, lineOffset);
        }

        @Override
        public void warning(String message, String sourceName, int line, int lineOffset) {
            super.warningAtLine(message, sourceName, line, lineOffset);
        }
    }
}

