/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.GlobalTypeInfo;
import com.google.javascript.jscomp.NTIScope;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.newtypes.Declaration;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionNamespace;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.rhino.Node;
import java.util.List;

final class SimpleInference {
    private static final QualifiedName CONST_INFERENCE_MARKER = new QualifiedName("jscomp$infer$const$property");
    private final JSTypes commonTypes;
    private final GlobalTypeInfo gti;
    private boolean scopesAreFrozen = false;

    SimpleInference(GlobalTypeInfo gti) {
        this.gti = gti;
        this.commonTypes = gti.getCommonTypes();
    }

    void setScopesAreFrozen() {
        this.scopesAreFrozen = true;
    }

    JSType inferDeclaration(Declaration decl) {
        if (decl == null) {
            return null;
        }
        if (decl.getNamespace() != null && this.scopesAreFrozen) {
            return decl.getNamespace().toJSType();
        }
        if (decl.getNominal() != null) {
            FunctionType ctorFn = decl.getNominal().getConstructorFunction();
            if (ctorFn == null) {
                return null;
            }
            if (this.scopesAreFrozen) {
                return this.commonTypes.fromFunctionType(ctorFn);
            }
            return this.commonTypes.fromFunctionType(ctorFn).withProperty(CONST_INFERENCE_MARKER, this.commonTypes.UNKNOWN);
        }
        if (decl.getTypeOfSimpleDecl() != null) {
            return decl.getTypeOfSimpleDecl();
        }
        NTIScope funScope = (NTIScope)decl.getFunctionScope();
        if (funScope != null) {
            DeclaredFunctionType dft = funScope.getDeclaredFunctionType();
            if (dft == null) {
                return null;
            }
            return this.commonTypes.fromFunctionType(dft.toFunctionType());
        }
        return null;
    }

    JSType inferExpr(Node n, NTIScope scope) {
        JSType t = this.inferExprRecur(n, scope);
        if (t == null || t.mayHaveProp(CONST_INFERENCE_MARKER)) {
            return null;
        }
        return t;
    }

    private FunctionType inferFunction(Node n, NTIScope scope) {
        JSType t;
        if (n.isQualifiedName()) {
            Declaration decl = scope.getDeclaration(QualifiedName.fromNode(n), false);
            if (decl == null) {
                JSType t2 = this.inferExprRecur(n, scope);
                if (t2 != null) {
                    return t2.getFunTypeIfSingletonObj();
                }
            } else {
                if (decl.getNominal() != null) {
                    return decl.getNominal().getConstructorFunction();
                }
                if (decl.getFunctionScope() != null) {
                    DeclaredFunctionType funType = decl.getFunctionScope().getDeclaredFunctionType();
                    if (funType != null) {
                        return funType.toFunctionType();
                    }
                } else if (decl.getNamespace() != null) {
                    Namespace ns = decl.getNamespace();
                    if (ns instanceof FunctionNamespace) {
                        DeclaredFunctionType funType = ((FunctionNamespace)ns).getScope().getDeclaredFunctionType();
                        return ((DeclaredFunctionType)Preconditions.checkNotNull((Object)funType)).toFunctionType();
                    }
                } else if (decl.getTypeOfSimpleDecl() != null) {
                    return decl.getTypeOfSimpleDecl().getFunTypeIfSingletonObj();
                }
            }
        }
        return (t = this.inferExprRecur(n, scope)) == null ? null : t.getFunTypeIfSingletonObj();
    }

    private JSType inferCallNew(Node n, NTIScope scope) {
        Node callee = n.getFirstChild();
        if (callee.matchesQualifiedName("goog.getMsg")) {
            return this.commonTypes.STRING;
        }
        FunctionType funType = this.inferFunction(callee, scope);
        if (funType == null) {
            return null;
        }
        if (funType.isGeneric() && (funType = this.inferInstantiatedCallee(n, funType, true, scope)) == null) {
            return null;
        }
        JSType retType = n.isNew() ? funType.getThisType() : funType.getReturnType();
        return retType;
    }

    private JSType inferExprRecur(Node n, NTIScope scope) {
        switch (n.getToken()) {
            case REGEXP: {
                return this.commonTypes.getRegexpType();
            }
            case CAST: {
                return (JSType)n.getTypeI();
            }
            case ARRAYLIT: {
                if (!n.hasChildren()) {
                    return this.commonTypes.getArrayInstance();
                }
                Node child = n.getFirstChild();
                JSType arrayType = this.inferExprRecur(child, scope);
                if (arrayType == null) {
                    return null;
                }
                while (null != (child = child.getNext())) {
                    if (arrayType.equals(this.inferExprRecur(child, scope))) continue;
                    return null;
                }
                return this.commonTypes.getArrayInstance(arrayType);
            }
            case TRUE: 
            case FALSE: {
                return this.commonTypes.BOOLEAN;
            }
            case THIS: {
                return scope.getDeclaredTypeOf("this");
            }
            case NAME: {
                return this.inferDeclaration(scope.getDeclaration(n.getString(), false));
            }
            case OBJECTLIT: {
                JSType objLitType = this.commonTypes.getEmptyObjectLiteral();
                for (Node prop : n.children()) {
                    JSType propType = null;
                    if (prop.hasChildren()) {
                        propType = this.inferExprRecur(prop.getFirstChild(), scope);
                    }
                    if (propType == null || prop.isComputedProp()) {
                        return null;
                    }
                    objLitType = objLitType.withProperty(new QualifiedName(NodeUtil.getObjectLitKeyName(prop)), propType);
                }
                return objLitType;
            }
            case GETPROP: {
                return this.inferPropAccess(n.getFirstChild(), n.getLastChild().getString(), scope);
            }
            case GETELEM: {
                return this.inferGetelem(n, scope);
            }
            case COMMA: 
            case ASSIGN: {
                return this.inferExprRecur(n.getLastChild(), scope);
            }
            case CALL: 
            case NEW: {
                return this.inferCallNew(n, scope);
            }
            case AND: 
            case OR: {
                return this.inferAndOr(n, scope);
            }
            case HOOK: {
                JSType lhs = this.inferExprRecur(n.getSecondChild(), scope);
                JSType rhs = this.inferExprRecur(n.getLastChild(), scope);
                return lhs == null || rhs == null ? null : JSType.join(lhs, rhs);
            }
            case FUNCTION: {
                NTIScope s = scope.getScope(this.gti.getFunInternalName(n));
                DeclaredFunctionType dft = s.getDeclaredFunctionType();
                return dft == null ? null : this.commonTypes.fromFunctionType(dft.toFunctionType());
            }
        }
        switch (NodeUtil.getKnownValueType(n)) {
            case NULL: {
                return this.commonTypes.NULL;
            }
            case VOID: {
                return this.commonTypes.UNDEFINED;
            }
            case NUMBER: {
                return this.commonTypes.NUMBER;
            }
            case STRING: {
                return this.commonTypes.STRING;
            }
            case BOOLEAN: {
                return this.commonTypes.BOOLEAN;
            }
        }
        return null;
    }

    private JSType inferPrototypeProperty(Node recv, String pname, NTIScope scope) {
        Namespace ns;
        QualifiedName recvQname = QualifiedName.fromNode(recv);
        Declaration decl = scope.getDeclaration(recvQname, false);
        if (decl != null && (ns = decl.getNamespace()) instanceof RawNominalType) {
            return ((RawNominalType)ns).getProtoPropDeclaredType(pname);
        }
        return null;
    }

    private JSType inferPropAccess(Node recv, String pname, NTIScope scope) {
        FunctionType ft;
        QualifiedName recvQname;
        Declaration decl;
        if (recv.isGetProp() && recv.getLastChild().getString().equals("prototype")) {
            return this.inferPrototypeProperty(recv.getFirstChild(), pname, scope);
        }
        QualifiedName propQname = new QualifiedName(pname);
        JSType recvType = null;
        if (recv.isQualifiedName() && (decl = scope.getDeclaration(recvQname = QualifiedName.fromNode(recv), false)) != null) {
            EnumType et = decl.getEnum();
            if (et != null && et.enumLiteralHasKey(pname)) {
                return et.getPropType();
            }
            Namespace ns = decl.getNamespace();
            if (ns != null) {
                return this.inferDeclaration(ns.getDeclaration(propQname));
            }
            recvType = decl.getTypeOfSimpleDecl();
        }
        if (recvType == null) {
            recvType = this.inferExprRecur(recv, scope);
        }
        if (recvType == null) {
            return null;
        }
        if (recvType.isScalar()) {
            recvType = recvType.autobox();
        }
        if ((ft = recvType.getFunTypeIfSingletonObj()) != null && pname.equals("call")) {
            return this.commonTypes.fromFunctionType(ft.transformByCallProperty());
        }
        if (ft != null && pname.equals("apply")) {
            return this.commonTypes.fromFunctionType(ft.transformByApplyProperty());
        }
        if (recvType.mayHaveProp(propQname)) {
            return recvType.getProp(propQname);
        }
        return null;
    }

    private JSType inferGetelem(Node n, NTIScope scope) {
        JSType propType;
        JSType indexType;
        JSType propType2;
        Preconditions.checkState((boolean)n.isGetElem());
        Node recv = n.getFirstChild();
        Node propNode = n.getLastChild();
        if (propNode.isString() && (propType2 = this.inferPropAccess(recv, propNode.getString(), scope)) != null) {
            return propType2;
        }
        JSType recvType = this.inferExprRecur(recv, scope);
        if (recvType != null && (indexType = recvType.getIndexType()) != null && (propType = this.inferExprRecur(propNode, scope)) != null && propType.isSubtypeOf(indexType)) {
            return recvType.getIndexedType();
        }
        return null;
    }

    private JSType inferAndOr(Node n, NTIScope scope) {
        Preconditions.checkState((n.isOr() || n.isAnd() ? 1 : 0) != 0);
        JSType lhs = this.inferExprRecur(n.getFirstChild(), scope);
        if (lhs == null) {
            return null;
        }
        JSType rhs = this.inferExprRecur(n.getSecondChild(), scope);
        if (rhs == null) {
            return null;
        }
        if (lhs.equals(rhs)) {
            return lhs;
        }
        if (n.isAnd()) {
            return JSType.join(lhs.specialize(this.commonTypes.FALSY), rhs);
        }
        return JSType.join(lhs.specialize(this.commonTypes.TRUTHY), rhs);
    }

    FunctionType inferInstantiatedCallee(Node call, FunctionType calleeType, boolean bailForUntypedArguments, NTIScope scope) {
        Node recv;
        QualifiedName recvQname;
        Declaration decl;
        Node callee = call.getFirstChild();
        Preconditions.checkArgument((boolean)calleeType.isGeneric(), (String)"Expected generic type for %s but found %s", (Object)callee, (Object)calleeType);
        JSType recvType = null;
        if (callee.isGetProp() && callee.getFirstChild().isQualifiedName() && (decl = scope.getDeclaration(recvQname = QualifiedName.fromNode(recv = callee.getFirstChild()), false)) != null) {
            recvType = decl.getTypeOfSimpleDecl();
        }
        ImmutableList.Builder argTypes = ImmutableList.builder();
        for (Node argNode = call.getSecondChild(); argNode != null; argNode = argNode.getNext()) {
            JSType t = this.inferExprRecur(argNode, scope);
            if (t == null) {
                if (bailForUntypedArguments && !argNode.isFunction()) {
                    return null;
                }
                t = this.commonTypes.BOTTOM;
            }
            argTypes.add((Object)t);
        }
        return calleeType.instantiateGenericsFromArgumentTypes(recvType, (List<JSType>)argTypes.build());
    }
}

