/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceFileMapping;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SourceMap {
    private static final Logger logger = Logger.getLogger("com.google.javascript.jscomp");
    private final SourceMapGenerator generator;
    private List<LocationMapping> prefixMappings = Collections.emptyList();
    private final Map<String, String> sourceLocationFixupCache = new HashMap<String, String>();
    @Nullable
    private SourceFileMapping mapping;

    private SourceMap(SourceMapGenerator generator) {
        this.generator = generator;
    }

    public void addMapping(Node node, FilePosition outputStartPosition, FilePosition outputEndPosition) {
        Mapping.OriginalMapping sourceMapping;
        String sourceFile = node.getSourceFileName();
        if (sourceFile == null || node.getLineno() < 0) {
            return;
        }
        int lineNo = node.getLineno();
        int charNo = node.getCharno();
        String originalName = node.getOriginalName();
        if (this.mapping != null && (sourceMapping = this.mapping.getSourceMapping(sourceFile, lineNo, charNo)) != null) {
            sourceFile = sourceMapping.getOriginalFile();
            lineNo = sourceMapping.getLineNumber();
            charNo = sourceMapping.getColumnPosition();
            originalName = sourceMapping.getIdentifier();
        }
        sourceFile = this.fixupSourceLocation(sourceFile);
        int lineBaseOffset = 1;
        this.generator.addMapping(sourceFile, originalName, new FilePosition(lineNo - lineBaseOffset, charNo), outputStartPosition, outputEndPosition);
    }

    public void addSourceFile(SourceFile sourceFile) {
        try {
            this.generator.addSourcesContent(this.fixupSourceLocation(sourceFile.getName()), sourceFile.getCode());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception while adding source content to source map.", e);
        }
    }

    private String fixupSourceLocation(String sourceFile) {
        if (this.prefixMappings.isEmpty()) {
            return sourceFile;
        }
        String fixed = this.sourceLocationFixupCache.get(sourceFile);
        if (fixed != null) {
            return fixed;
        }
        for (LocationMapping mapping : this.prefixMappings) {
            if (!sourceFile.startsWith(mapping.prefix)) continue;
            fixed = mapping.replacement + sourceFile.substring(mapping.prefix.length());
            break;
        }
        if (fixed == null) {
            fixed = sourceFile;
        }
        this.sourceLocationFixupCache.put(sourceFile, fixed);
        return fixed;
    }

    public void appendTo(Appendable out, String name) throws IOException {
        this.generator.appendTo(out, this.fixupSourceLocation(name));
    }

    public void reset() {
        this.generator.reset();
        this.sourceLocationFixupCache.clear();
    }

    public void setStartingPosition(int offsetLine, int offsetIndex) {
        this.generator.setStartingPosition(offsetLine, offsetIndex);
    }

    public void setWrapperPrefix(String prefix) {
        this.generator.setWrapperPrefix(prefix);
    }

    public void validate(boolean validate) {
        this.generator.validate(validate);
    }

    public void setPrefixMappings(List<LocationMapping> sourceMapLocationMappings) {
        this.prefixMappings = sourceMapLocationMappings;
    }

    public void setSourceFileMapping(SourceFileMapping mapping) {
        this.mapping = mapping;
    }

    public static final class LocationMapping {
        final String prefix;
        final String replacement;

        public LocationMapping(String prefix, String replacement) {
            this.prefix = prefix;
            this.replacement = replacement;
        }

        public String toString() {
            return "(" + this.prefix + "|" + this.replacement + ")";
        }

        public boolean equals(Object other) {
            if (other instanceof LocationMapping) {
                return ((LocationMapping)other).prefix.equals(this.prefix) && ((LocationMapping)other).replacement.equals(this.replacement);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.replacement);
        }
    }

    public static enum DetailLevel implements Predicate<Node>
    {
        ALL{

            public boolean apply(Node node) {
                return true;
            }
        }
        ,
        SYMBOLS{

            public boolean apply(Node node) {
                return node.isCall() || node.isNew() || node.isFunction() || node.isName() || NodeUtil.isGet(node) || NodeUtil.isObjectLitKey(node) || node.isString() && NodeUtil.isGet(node.getParent()) || node.isTaggedTemplateLit();
            }
        };

    }

    public static enum Format {
        DEFAULT{

            @Override
            SourceMap getInstance() {
                return new SourceMap(SourceMapGeneratorFactory.getInstance(SourceMapFormat.DEFAULT));
            }
        }
        ,
        V3{

            @Override
            SourceMap getInstance() {
                return new SourceMap(SourceMapGeneratorFactory.getInstance(SourceMapFormat.V3));
            }
        };


        abstract SourceMap getInstance();
    }
}

